
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.stl.STLHeaderRS;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_AccountingRS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:STL_Header.RS" name="Header"/>
 *     &lt;xs:element type="ns1:_AccountingHeader" name="AccountingHeader" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element name="Remark" minOccurs="0" maxOccurs="2">
 *       &lt;!-- Reference to inner class Remark -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns1:_AccountingVariance" name="Variance" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:_AccountingTotalsByCurrency" name="TotalsByCurrency" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:_AccountingExpectedTotals" name="ExpectedTotals" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:Misc.Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="isQueryStillRunning"/>
 *   &lt;xs:attribute type="xs:integer" name="reportId"/>
 *   &lt;xs:attribute type="xs:integer" name="chunkNumber"/>
 *   &lt;xs:attribute type="xs:integer" name="maxChunks"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _AccountingRS implements Serializable
{
    private STLHeaderRS header;
    private _AccountingHeader accountingHeader;
    private List<Remark> remarkList = new ArrayList<Remark>();
    private List<_AccountingVariance> varianceList = new ArrayList<_AccountingVariance>();
    private List<_AccountingTotalsByCurrency> totalsByCurrencyList = new ArrayList<_AccountingTotalsByCurrency>();
    private List<_AccountingExpectedTotals> expectedTotalList = new ArrayList<_AccountingExpectedTotals>();
    private List<MiscDiagnostic> diagnosticList = new ArrayList<MiscDiagnostic>();
    private String version;
    private boolean isQueryStillRunning;
    private BigInteger reportId;
    private BigInteger chunkNumber;
    private BigInteger maxChunks;

    /** 
     * Get the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @return value
     */
    public STLHeaderRS getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @param header
     */
    public void setHeader(STLHeaderRS header) {
        this.header = header;
    }

    /** 
     * Get the 'AccountingHeader' element value. Describes data contained within the whole report
     * 
     * @return value
     */
    public _AccountingHeader getAccountingHeader() {
        return accountingHeader;
    }

    /** 
     * Set the 'AccountingHeader' element value. Describes data contained within the whole report
     * 
     * @param accountingHeader
     */
    public void setAccountingHeader(_AccountingHeader accountingHeader) {
        this.accountingHeader = accountingHeader;
    }

    /** 
     * Get the list of 'Remark' element items.
     * 
     * @return list
     */
    public List<Remark> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items.
     * 
     * @param list
     */
    public void setRemarkList(List<Remark> list) {
        remarkList = list;
    }

    /** 
     * Get the list of 'Variance' element items. Displays any overage or shortage in the cash drawer after the report has been closed. The information comes from the data the agent provides during the close function.
     * 
     * @return list
     */
    public List<_AccountingVariance> getVarianceList() {
        return varianceList;
    }

    /** 
     * Set the list of 'Variance' element items. Displays any overage or shortage in the cash drawer after the report has been closed. The information comes from the data the agent provides during the close function.
     * 
     * @param list
     */
    public void setVarianceList(List<_AccountingVariance> list) {
        varianceList = list;
    }

    /** 
     * Get the list of 'TotalsByCurrency' element items. Contains the totals listed by currency
     * 
     * @return list
     */
    public List<_AccountingTotalsByCurrency> getTotalsByCurrencyList() {
        return totalsByCurrencyList;
    }

    /** 
     * Set the list of 'TotalsByCurrency' element items. Contains the totals listed by currency
     * 
     * @param list
     */
    public void setTotalsByCurrencyList(List<_AccountingTotalsByCurrency> list) {
        totalsByCurrencyList = list;
    }

    /** 
     * Get the list of 'ExpectedTotals' element items. Contains the total amounts the system expects the agent to have in their cash/check drawer at time of closing out their report.  
     * 
     * @return list
     */
    public List<_AccountingExpectedTotals> getExpectedTotalList() {
        return expectedTotalList;
    }

    /** 
     * Set the list of 'ExpectedTotals' element items. Contains the total amounts the system expects the agent to have in their cash/check drawer at time of closing out their report.  
     * 
     * @param list
     */
    public void setExpectedTotalList(List<_AccountingExpectedTotals> list) {
        expectedTotalList = list;
    }

    /** 
     * Get the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @return list
     */
    public List<MiscDiagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @param list
     */
    public void setDiagnosticList(List<MiscDiagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value. Asr Services web service version.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Asr Services web service version.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later.
     * 
     * @return value
     */
    public boolean isIsQueryStillRunning() {
        return isQueryStillRunning;
    }

    /** 
     * Set the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later.
     * 
     * @param isQueryStillRunning
     */
    public void setIsQueryStillRunning(boolean isQueryStillRunning) {
        this.isQueryStillRunning = isQueryStillRunning;
    }

    /** 
     * Get the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @return value
     */
    public BigInteger getReportId() {
        return reportId;
    }

    /** 
     * Set the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @param reportId
     */
    public void setReportId(BigInteger reportId) {
        this.reportId = reportId;
    }

    /** 
     * Get the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @return value
     */
    public BigInteger getChunkNumber() {
        return chunkNumber;
    }

    /** 
     * Set the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @param chunkNumber
     */
    public void setChunkNumber(BigInteger chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    /** 
     * Get the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @return value
     */
    public BigInteger getMaxChunks() {
        return maxChunks;
    }

    /** 
     * Set the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @param maxChunks
     */
    public void setMaxChunks(BigInteger maxChunks) {
        this.maxChunks = maxChunks;
    }
    /** 
     * Contains the remarks that have been added
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark" minOccurs="0" maxOccurs="2">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:integer" use="required" name="sequenceNumber"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Remark implements Serializable
    {
        private String string;
        private BigInteger sequenceNumber;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'sequenceNumber' attribute value.
         * 
         * @return value
         */
        public BigInteger getSequenceNumber() {
            return sequenceNumber;
        }

        /** 
         * Set the 'sequenceNumber' attribute value.
         * 
         * @param sequenceNumber
         */
        public void setSequenceNumber(BigInteger sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }
    }
}
