
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_AccountingTotalsByCurrency">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CurrencyCode"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="TotalAmount"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="ExchangeAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="PrepaidAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="CommissionAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="IgnoredResidualAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:_AccountingFopLine" name="FopLine" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _AccountingTotalsByCurrency implements Serializable
{
    private String currencyCode;
    private MiscMoney totalAmount;
    private MiscMoney exchangeAmount;
    private MiscMoney prepaidAmount;
    private MiscMoney commissionAmount;
    private MiscMoney ignoredResidualAmount;
    private _AccountingFopLine fopLine;

    /** 
     * Get the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'TotalAmount' element value. Total Amount of the transactions by currency
     * 
     * @return value
     */
    public MiscMoney getTotalAmount() {
        return totalAmount;
    }

    /** 
     * Set the 'TotalAmount' element value. Total Amount of the transactions by currency
     * 
     * @param totalAmount
     */
    public void setTotalAmount(MiscMoney totalAmount) {
        this.totalAmount = totalAmount;
    }

    /** 
     * Get the 'ExchangeAmount' element value. Total amount of exchange transactions by currency.
     * 
     * @return value
     */
    public MiscMoney getExchangeAmount() {
        return exchangeAmount;
    }

    /** 
     * Set the 'ExchangeAmount' element value. Total amount of exchange transactions by currency.
     * 
     * @param exchangeAmount
     */
    public void setExchangeAmount(MiscMoney exchangeAmount) {
        this.exchangeAmount = exchangeAmount;
    }

    /** 
     * Get the 'PrepaidAmount' element value. Total amount of Pre-Paid transactions by currency.
     * 
     * @return value
     */
    public MiscMoney getPrepaidAmount() {
        return prepaidAmount;
    }

    /** 
     * Set the 'PrepaidAmount' element value. Total amount of Pre-Paid transactions by currency.
     * 
     * @param prepaidAmount
     */
    public void setPrepaidAmount(MiscMoney prepaidAmount) {
        this.prepaidAmount = prepaidAmount;
    }

    /** 
     * Get the 'CommissionAmount' element value. Total amount of commission paid  by currency.
     * 
     * @return value
     */
    public MiscMoney getCommissionAmount() {
        return commissionAmount;
    }

    /** 
     * Set the 'CommissionAmount' element value. Total amount of commission paid  by currency.
     * 
     * @param commissionAmount
     */
    public void setCommissionAmount(MiscMoney commissionAmount) {
        this.commissionAmount = commissionAmount;
    }

    /** 
     * Get the 'IgnoredResidualAmount' element value. This functionality requires activation and is controlled by settings in the Ticketing Options Table (maintained by Sabre) and CAT31 fare filings. When active, the system does not include a residual value from an exchange document in the grand total of the report.
     * 
     * @return value
     */
    public MiscMoney getIgnoredResidualAmount() {
        return ignoredResidualAmount;
    }

    /** 
     * Set the 'IgnoredResidualAmount' element value. This functionality requires activation and is controlled by settings in the Ticketing Options Table (maintained by Sabre) and CAT31 fare filings. When active, the system does not include a residual value from an exchange document in the grand total of the report.
     * 
     * @param ignoredResidualAmount
     */
    public void setIgnoredResidualAmount(MiscMoney ignoredResidualAmount) {
        this.ignoredResidualAmount = ignoredResidualAmount;
    }

    /** 
     * Get the 'FopLine' element value. Line noting the form of payment
     * 
     * @return value
     */
    public _AccountingFopLine getFopLine() {
        return fopLine;
    }

    /** 
     * Set the 'FopLine' element value. Line noting the form of payment
     * 
     * @param fopLine
     */
    public void setFopLine(_AccountingFopLine fopLine) {
        this.fopLine = fopLine;
    }
}
