
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;

/** 
 * Carrier code and Carrier number that the document was issued for. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_AirlineChoice">
 *   &lt;xs:choice>
 *     &lt;xs:element type="xs:string" name="AirlineCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AirlineNumber" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:choice>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _AirlineChoice implements Serializable
{
    private int choiceSelect = -1;
    private static final int AIRLINE_CODE_CHOICE = 0;
    private static final int AIRLINE_NUMBER_CHOICE = 1;
    private String airlineCode;
    private String airlineNumber;

    private void setChoiceSelect(int choice) {
        if (choiceSelect == -1) {
            choiceSelect = choice;
        } else if (choiceSelect != choice) {
            throw new IllegalStateException(
                    "Need to call clearChoiceSelect() before changing existing choice");
        }
    }

    /** 
     * Clear the choice selection.
     */
    public void clearChoiceSelect() {
        choiceSelect = -1;
    }

    /** 
     * Check if AirlineCode is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlineCode() {
        return choiceSelect == AIRLINE_CODE_CHOICE;
    }

    /** 
     * Get the 'AirlineCode' element value. Arline Code. 
     * 
     * @return value
     */
    public String getAirlineCode() {
        return airlineCode;
    }

    /** 
     * Set the 'AirlineCode' element value. Arline Code. 
     * 
     * @param airlineCode
     */
    public void setAirlineCode(String airlineCode) {
        setChoiceSelect(AIRLINE_CODE_CHOICE);
        this.airlineCode = airlineCode;
    }

    /** 
     * Check if AirlineNumber is current selection for choice.
     * 
     * @return <code>true</code> if selection, <code>false</code> if not
     */
    public boolean ifAirlineNumber() {
        return choiceSelect == AIRLINE_NUMBER_CHOICE;
    }

    /** 
     * Get the 'AirlineNumber' element value. Airline number
     * 
     * @return value
     */
    public String getAirlineNumber() {
        return airlineNumber;
    }

    /** 
     * Set the 'AirlineNumber' element value. Airline number
     * 
     * @param airlineNumber
     */
    public void setAirlineNumber(String airlineNumber) {
        setChoiceSelect(AIRLINE_NUMBER_CHOICE);
        this.airlineNumber = airlineNumber;
    }
}
