
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_CCFop">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="FopCode"/>
 *     &lt;xs:element type="xs:string" name="CurrencyCode"/>
 *     &lt;xs:element type="xs:string" name="CreditCardVendor"/>
 *     &lt;xs:element type="xs:string" name="MaskedCCNumber"/>
 *     &lt;xs:element type="xs:string" name="CreditCardExpDate"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="TotalAmount"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _CCFop implements Serializable
{
    private String fopCode;
    private String currencyCode;
    private String creditCardVendor;
    private String maskedCCNumber;
    private String creditCardExpDate;
    private MiscMoney totalAmount;

    /** 
     * Get the 'FopCode' element value. Form of Payment Code.
     * 
     * @return value
     */
    public String getFopCode() {
        return fopCode;
    }

    /** 
     * Set the 'FopCode' element value. Form of Payment Code.
     * 
     * @param fopCode
     */
    public void setFopCode(String fopCode) {
        this.fopCode = fopCode;
    }

    /** 
     * Get the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'CreditCardVendor' element value. Vendor code for the credit card used.
     * 
     * @return value
     */
    public String getCreditCardVendor() {
        return creditCardVendor;
    }

    /** 
     * Set the 'CreditCardVendor' element value. Vendor code for the credit card used.
     * 
     * @param creditCardVendor
     */
    public void setCreditCardVendor(String creditCardVendor) {
        this.creditCardVendor = creditCardVendor;
    }

    /** 
     * Get the 'MaskedCCNumber' element value. Credit card number in masked format showing only partial digits.
     * 
     * @return value
     */
    public String getMaskedCCNumber() {
        return maskedCCNumber;
    }

    /** 
     * Set the 'MaskedCCNumber' element value. Credit card number in masked format showing only partial digits.
     * 
     * @param maskedCCNumber
     */
    public void setMaskedCCNumber(String maskedCCNumber) {
        this.maskedCCNumber = maskedCCNumber;
    }

    /** 
     * Get the 'CreditCardExpDate' element value. Credit card expiration date.
     * 
     * @return value
     */
    public String getCreditCardExpDate() {
        return creditCardExpDate;
    }

    /** 
     * Set the 'CreditCardExpDate' element value. Credit card expiration date.
     * 
     * @param creditCardExpDate
     */
    public void setCreditCardExpDate(String creditCardExpDate) {
        this.creditCardExpDate = creditCardExpDate;
    }

    /** 
     * Get the 'TotalAmount' element value. Total amount collected for the CC.
     * 
     * @return value
     */
    public MiscMoney getTotalAmount() {
        return totalAmount;
    }

    /** 
     * Set the 'TotalAmount' element value. Total amount collected for the CC.
     * 
     * @param totalAmount
     */
    public void setTotalAmount(MiscMoney totalAmount) {
        this.totalAmount = totalAmount;
    }
}
