
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_CCTransaction">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DocumentType" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DocumentNumber"/>
 *     &lt;xs:element type="xs:string" name="LastConjunctiveDocumentNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PassengerName"/>
 *     &lt;xs:element type="ns:_CCFop" name="CCFop" minOccurs="1" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="PnrLocator" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TicketPrinterLniata"/>
 *     &lt;xs:element type="xs:string" name="TicketStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="IsElectronicTicket" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="IsManuallyAdded" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _CCTransaction implements Serializable
{
    private String documentType;
    private String documentNumber;
    private String lastConjunctiveDocumentNumber;
    private String passengerName;
    private List<_CCFop> CCFopList = new ArrayList<_CCFop>();
    private String pnrLocator;
    private String ticketPrinterLniata;
    private String ticketStatusCode;
    private Boolean isElectronicTicket;
    private Boolean isManuallyAdded;

    /** 
     * Get the 'DocumentType' element value. Type of document issued.
     * 
     * @return value
     */
    public String getDocumentType() {
        return documentType;
    }

    /** 
     * Set the 'DocumentType' element value. Type of document issued.
     * 
     * @param documentType
     */
    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    /** 
     * Get the 'DocumentNumber' element value. Unique identifier of the issued document.
     * 
     * @return value
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /** 
     * Set the 'DocumentNumber' element value. Unique identifier of the issued document.
     * 
     * @param documentNumber
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /** 
     * Get the 'LastConjunctiveDocumentNumber' element value. Last document number if the sale included multiple conjunctive documents.
     * 
     * @return value
     */
    public String getLastConjunctiveDocumentNumber() {
        return lastConjunctiveDocumentNumber;
    }

    /** 
     * Set the 'LastConjunctiveDocumentNumber' element value. Last document number if the sale included multiple conjunctive documents.
     * 
     * @param lastConjunctiveDocumentNumber
     */
    public void setLastConjunctiveDocumentNumber(
            String lastConjunctiveDocumentNumber) {
        this.lastConjunctiveDocumentNumber = lastConjunctiveDocumentNumber;
    }

    /** 
     * Get the 'PassengerName' element value. LastName/FirstName.
     * 
     * @return value
     */
    public String getPassengerName() {
        return passengerName;
    }

    /** 
     * Set the 'PassengerName' element value. LastName/FirstName.
     * 
     * @param passengerName
     */
    public void setPassengerName(String passengerName) {
        this.passengerName = passengerName;
    }

    /** 
     * Get the list of 'CCFop' element items.
     * 
     * @return list
     */
    public List<_CCFop> getCCFopList() {
        return CCFopList;
    }

    /** 
     * Set the list of 'CCFop' element items.
     * 
     * @param list
     */
    public void setCCFopList(List<_CCFop> list) {
        CCFopList = list;
    }

    /** 
     * Get the 'PnrLocator' element value. Locator code for document
     * 
     * @return value
     */
    public String getPnrLocator() {
        return pnrLocator;
    }

    /** 
     * Set the 'PnrLocator' element value. Locator code for document
     * 
     * @param pnrLocator
     */
    public void setPnrLocator(String pnrLocator) {
        this.pnrLocator = pnrLocator;
    }

    /** 
     * Get the 'TicketPrinterLniata' element value. Display transactions issued on specific printer line addresses (LNIATAs).
     * 
     * @return value
     */
    public String getTicketPrinterLniata() {
        return ticketPrinterLniata;
    }

    /** 
     * Set the 'TicketPrinterLniata' element value. Display transactions issued on specific printer line addresses (LNIATAs).
     * 
     * @param ticketPrinterLniata
     */
    public void setTicketPrinterLniata(String ticketPrinterLniata) {
        this.ticketPrinterLniata = ticketPrinterLniata;
    }

    /** 
     * Get the 'TicketStatusCode' element value. Document status code
     * 
     * @return value
     */
    public String getTicketStatusCode() {
        return ticketStatusCode;
    }

    /** 
     * Set the 'TicketStatusCode' element value. Document status code
     * 
     * @param ticketStatusCode
     */
    public void setTicketStatusCode(String ticketStatusCode) {
        this.ticketStatusCode = ticketStatusCode;
    }

    /** 
     * Get the 'IsElectronicTicket' element value. TRUE if the document being returned is an electronic document.
     * 
     * @return value
     */
    public Boolean getIsElectronicTicket() {
        return isElectronicTicket;
    }

    /** 
     * Set the 'IsElectronicTicket' element value. TRUE if the document being returned is an electronic document.
     * 
     * @param isElectronicTicket
     */
    public void setIsElectronicTicket(Boolean isElectronicTicket) {
        this.isElectronicTicket = isElectronicTicket;
    }

    /** 
     * Get the 'IsManuallyAdded' element value. TRUE if the document being returned was manually added..
     * 
     * @return value
     */
    public Boolean getIsManuallyAdded() {
        return isManuallyAdded;
    }

    /** 
     * Set the 'IsManuallyAdded' element value. TRUE if the document being returned was manually added..
     * 
     * @param isManuallyAdded
     */
    public void setIsManuallyAdded(Boolean isManuallyAdded) {
        this.isManuallyAdded = isManuallyAdded;
    }
}
