
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_CRSelectionCriteria">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="TicketingProvider"/>
 *     &lt;xs:element type="xs:integer" name="reportId"/>
 *     &lt;xs:element type="xs:integer" name="chunkNumber"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _CRSelectionCriteria implements Serializable
{
    private String ticketingProvider;
    private BigInteger reportId;
    private BigInteger chunkNumber;

    /** 
     * Get the 'TicketingProvider' element value. Carrier code indicating which airline cached report was generated for.
     * 
     * @return value
     */
    public String getTicketingProvider() {
        return ticketingProvider;
    }

    /** 
     * Set the 'TicketingProvider' element value. Carrier code indicating which airline cached report was generated for.
     * 
     * @param ticketingProvider
     */
    public void setTicketingProvider(String ticketingProvider) {
        this.ticketingProvider = ticketingProvider;
    }

    /** 
     * Get the 'reportId' element value. Unique report identifier returned in report response which was cached by the system.  This is used to identify the cached report along with the ChunkNumber.
     * 
     * @return value
     */
    public BigInteger getReportId() {
        return reportId;
    }

    /** 
     * Set the 'reportId' element value. Unique report identifier returned in report response which was cached by the system.  This is used to identify the cached report along with the ChunkNumber.
     * 
     * @param reportId
     */
    public void setReportId(BigInteger reportId) {
        this.reportId = reportId;
    }

    /** 
     * Get the 'chunkNumber' element value. If cached report was broken into pieces this is used to identify the piece.  Use 1 if the report was not broken into pieces.
     * 
     * @return value
     */
    public BigInteger getChunkNumber() {
        return chunkNumber;
    }

    /** 
     * Set the 'chunkNumber' element value. If cached report was broken into pieces this is used to identify the piece.  Use 1 if the report was not broken into pieces.
     * 
     * @param chunkNumber
     */
    public void setChunkNumber(BigInteger chunkNumber) {
        this.chunkNumber = chunkNumber;
    }
}
