
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.stl.STLHeaderRS;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Since this response can carry any report all RS responses are available as a valid response to a CachedReportRQ.  The contents of the response are exactly the same as the report which was requested except for the additional attributes associated with the CachedReportRS element.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_CachedReportRS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:STL_Header.RS" name="Header"/>
 *     &lt;xs:choice minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class Choice -->
 *     &lt;/xs:choice>
 *     &lt;xs:element type="ns1:Misc.Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="isReportFound"/>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="isQueryStillRunning"/>
 *   &lt;xs:attribute type="xs:integer" use="required" name="reportId"/>
 *   &lt;xs:attribute type="xs:integer" name="chunkNumber"/>
 *   &lt;xs:attribute type="xs:integer" name="maxChunks"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _CachedReportRS implements Serializable
{
    private STLHeaderRS header;
    private Choice choice;
    private List<MiscDiagnostic> diagnosticList = new ArrayList<MiscDiagnostic>();
    private String version;
    private boolean isReportFound;
    private boolean isQueryStillRunning;
    private BigInteger reportId;
    private BigInteger chunkNumber;
    private BigInteger maxChunks;

    /** 
     * Get the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @return value
     */
    public STLHeaderRS getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @param header
     */
    public void setHeader(STLHeaderRS header) {
        this.header = header;
    }

    /** 
     * Get the choice value.
     * 
     * @return value
     */
    public Choice getChoice() {
        return choice;
    }

    /** 
     * Set the choice value.
     * 
     * @param choice
     */
    public void setChoice(Choice choice) {
        this.choice = choice;
    }

    /** 
     * Get the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @return list
     */
    public List<MiscDiagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @param list
     */
    public void setDiagnosticList(List<MiscDiagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value. Asr Services web service version.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Asr Services web service version.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'isReportFound' attribute value. False if there was no cached report found for the specified reportId and chunkNumber.
     * 
     * @return value
     */
    public boolean isIsReportFound() {
        return isReportFound;
    }

    /** 
     * Set the 'isReportFound' attribute value. False if there was no cached report found for the specified reportId and chunkNumber.
     * 
     * @param isReportFound
     */
    public void setIsReportFound(boolean isReportFound) {
        this.isReportFound = isReportFound;
    }

    /** 
     * Get the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later..
     * 
     * @return value
     */
    public boolean isIsQueryStillRunning() {
        return isQueryStillRunning;
    }

    /** 
     * Set the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later..
     * 
     * @param isQueryStillRunning
     */
    public void setIsQueryStillRunning(boolean isQueryStillRunning) {
        this.isQueryStillRunning = isQueryStillRunning;
    }

    /** 
     * Get the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @return value
     */
    public BigInteger getReportId() {
        return reportId;
    }

    /** 
     * Set the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @param reportId
     */
    public void setReportId(BigInteger reportId) {
        this.reportId = reportId;
    }

    /** 
     * Get the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @return value
     */
    public BigInteger getChunkNumber() {
        return chunkNumber;
    }

    /** 
     * Set the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @param chunkNumber
     */
    public void setChunkNumber(BigInteger chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    /** 
     * Get the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @return value
     */
    public BigInteger getMaxChunks() {
        return maxChunks;
    }

    /** 
     * Set the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @param maxChunks
     */
    public void setMaxChunks(BigInteger maxChunks) {
        this.maxChunks = maxChunks;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:choice xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0" maxOccurs="1">
     *   &lt;xs:element type="ns:_SalesSummaryRS" name="SalesSummaryRS"/>
     *   &lt;xs:element type="ns:_DetailRS" name="DetailRS"/>
     *   &lt;xs:element type="ns:_CreditCardRS" name="CreditCardRS"/>
     *   &lt;xs:element type="ns:_AccountingRS" name="AccountingRS"/>
     *   &lt;xs:element type="ns:_StationSummaryRS" name="StationSummaryRS"/>
     *   &lt;xs:element type="ns:_AgentListRS" name="AgentListRS"/>
     *   &lt;xs:element type="ns:_StationManagerRS" name="StationManagerRS"/>
     *   &lt;xs:element type="ns:_StationActivityRS" name="StationActivityRS"/>
     *   &lt;xs:element type="ns:_TaxRS" name="TaxRS"/>
     *   &lt;xs:element type="ns:_ExceptionRS" name="ExceptionRS"/>
     *   &lt;xs:element type="ns:_DailySalesSummaryRS" name="DailySalesSummaryRS"/>
     * &lt;/xs:choice>
     * </pre>
     */
    public static class Choice implements Serializable
    {
        private int choiceSelect = -1;
        private static final int SALES_SUMMARY_RS_CHOICE = 0;
        private static final int DETAIL_RS_CHOICE = 1;
        private static final int CREDIT_CARD_RS_CHOICE = 2;
        private static final int ACCOUNTING_RS_CHOICE = 3;
        private static final int STATION_SUMMARY_RS_CHOICE = 4;
        private static final int AGENT_LIST_RS_CHOICE = 5;
        private static final int STATION_MANAGER_RS_CHOICE = 6;
        private static final int STATION_ACTIVITY_RS_CHOICE = 7;
        private static final int TAX_RS_CHOICE = 8;
        private static final int EXCEPTION_RS_CHOICE = 9;
        private static final int DAILY_SALES_SUMMARY_RS_CHOICE = 10;
        private _SalesSummaryRS salesSummaryRS;
        private _DetailRS detailRS;
        private _CreditCardRS creditCardRS;
        private _AccountingRS accountingRS;
        private _StationSummaryRS stationSummaryRS;
        private _AgentListRS agentListRS;
        private _StationManagerRS stationManagerRS;
        private _StationActivityRS stationActivityRS;
        private _TaxRS taxRS;
        private _ExceptionRS exceptionRS;
        private _DailySalesSummaryRS dailySalesSummaryRS;

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if SalesSummaryRS is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifSalesSummaryRS() {
            return choiceSelect == SALES_SUMMARY_RS_CHOICE;
        }

        /** 
         * Get the 'SalesSummaryRS' element value.
         * 
         * @return value
         */
        public _SalesSummaryRS getSalesSummaryRS() {
            return salesSummaryRS;
        }

        /** 
         * Set the 'SalesSummaryRS' element value.
         * 
         * @param salesSummaryRS
         */
        public void setSalesSummaryRS(_SalesSummaryRS salesSummaryRS) {
            setChoiceSelect(SALES_SUMMARY_RS_CHOICE);
            this.salesSummaryRS = salesSummaryRS;
        }

        /** 
         * Check if DetailRS is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDetailRS() {
            return choiceSelect == DETAIL_RS_CHOICE;
        }

        /** 
         * Get the 'DetailRS' element value.
         * 
         * @return value
         */
        public _DetailRS getDetailRS() {
            return detailRS;
        }

        /** 
         * Set the 'DetailRS' element value.
         * 
         * @param detailRS
         */
        public void setDetailRS(_DetailRS detailRS) {
            setChoiceSelect(DETAIL_RS_CHOICE);
            this.detailRS = detailRS;
        }

        /** 
         * Check if CreditCardRS is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifCreditCardRS() {
            return choiceSelect == CREDIT_CARD_RS_CHOICE;
        }

        /** 
         * Get the 'CreditCardRS' element value.
         * 
         * @return value
         */
        public _CreditCardRS getCreditCardRS() {
            return creditCardRS;
        }

        /** 
         * Set the 'CreditCardRS' element value.
         * 
         * @param creditCardRS
         */
        public void setCreditCardRS(_CreditCardRS creditCardRS) {
            setChoiceSelect(CREDIT_CARD_RS_CHOICE);
            this.creditCardRS = creditCardRS;
        }

        /** 
         * Check if AccountingRS is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAccountingRS() {
            return choiceSelect == ACCOUNTING_RS_CHOICE;
        }

        /** 
         * Get the 'AccountingRS' element value.
         * 
         * @return value
         */
        public _AccountingRS getAccountingRS() {
            return accountingRS;
        }

        /** 
         * Set the 'AccountingRS' element value.
         * 
         * @param accountingRS
         */
        public void setAccountingRS(_AccountingRS accountingRS) {
            setChoiceSelect(ACCOUNTING_RS_CHOICE);
            this.accountingRS = accountingRS;
        }

        /** 
         * Check if StationSummaryRS is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifStationSummaryRS() {
            return choiceSelect == STATION_SUMMARY_RS_CHOICE;
        }

        /** 
         * Get the 'StationSummaryRS' element value.
         * 
         * @return value
         */
        public _StationSummaryRS getStationSummaryRS() {
            return stationSummaryRS;
        }

        /** 
         * Set the 'StationSummaryRS' element value.
         * 
         * @param stationSummaryRS
         */
        public void setStationSummaryRS(_StationSummaryRS stationSummaryRS) {
            setChoiceSelect(STATION_SUMMARY_RS_CHOICE);
            this.stationSummaryRS = stationSummaryRS;
        }

        /** 
         * Check if AgentListRS is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifAgentListRS() {
            return choiceSelect == AGENT_LIST_RS_CHOICE;
        }

        /** 
         * Get the 'AgentListRS' element value.
         * 
         * @return value
         */
        public _AgentListRS getAgentListRS() {
            return agentListRS;
        }

        /** 
         * Set the 'AgentListRS' element value.
         * 
         * @param agentListRS
         */
        public void setAgentListRS(_AgentListRS agentListRS) {
            setChoiceSelect(AGENT_LIST_RS_CHOICE);
            this.agentListRS = agentListRS;
        }

        /** 
         * Check if StationManagerRS is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifStationManagerRS() {
            return choiceSelect == STATION_MANAGER_RS_CHOICE;
        }

        /** 
         * Get the 'StationManagerRS' element value.
         * 
         * @return value
         */
        public _StationManagerRS getStationManagerRS() {
            return stationManagerRS;
        }

        /** 
         * Set the 'StationManagerRS' element value.
         * 
         * @param stationManagerRS
         */
        public void setStationManagerRS(_StationManagerRS stationManagerRS) {
            setChoiceSelect(STATION_MANAGER_RS_CHOICE);
            this.stationManagerRS = stationManagerRS;
        }

        /** 
         * Check if StationActivityRS is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifStationActivityRS() {
            return choiceSelect == STATION_ACTIVITY_RS_CHOICE;
        }

        /** 
         * Get the 'StationActivityRS' element value.
         * 
         * @return value
         */
        public _StationActivityRS getStationActivityRS() {
            return stationActivityRS;
        }

        /** 
         * Set the 'StationActivityRS' element value.
         * 
         * @param stationActivityRS
         */
        public void setStationActivityRS(_StationActivityRS stationActivityRS) {
            setChoiceSelect(STATION_ACTIVITY_RS_CHOICE);
            this.stationActivityRS = stationActivityRS;
        }

        /** 
         * Check if TaxRS is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifTaxRS() {
            return choiceSelect == TAX_RS_CHOICE;
        }

        /** 
         * Get the 'TaxRS' element value.
         * 
         * @return value
         */
        public _TaxRS getTaxRS() {
            return taxRS;
        }

        /** 
         * Set the 'TaxRS' element value.
         * 
         * @param taxRS
         */
        public void setTaxRS(_TaxRS taxRS) {
            setChoiceSelect(TAX_RS_CHOICE);
            this.taxRS = taxRS;
        }

        /** 
         * Check if ExceptionRS is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifExceptionRS() {
            return choiceSelect == EXCEPTION_RS_CHOICE;
        }

        /** 
         * Get the 'ExceptionRS' element value.
         * 
         * @return value
         */
        public _ExceptionRS getExceptionRS() {
            return exceptionRS;
        }

        /** 
         * Set the 'ExceptionRS' element value.
         * 
         * @param exceptionRS
         */
        public void setExceptionRS(_ExceptionRS exceptionRS) {
            setChoiceSelect(EXCEPTION_RS_CHOICE);
            this.exceptionRS = exceptionRS;
        }

        /** 
         * Check if DailySalesSummaryRS is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDailySalesSummaryRS() {
            return choiceSelect == DAILY_SALES_SUMMARY_RS_CHOICE;
        }

        /** 
         * Get the 'DailySalesSummaryRS' element value.
         * 
         * @return value
         */
        public _DailySalesSummaryRS getDailySalesSummaryRS() {
            return dailySalesSummaryRS;
        }

        /** 
         * Set the 'DailySalesSummaryRS' element value.
         * 
         * @param dailySalesSummaryRS
         */
        public void setDailySalesSummaryRS(
                _DailySalesSummaryRS dailySalesSummaryRS) {
            setChoiceSelect(DAILY_SALES_SUMMARY_RS_CHOICE);
            this.dailySalesSummaryRS = dailySalesSummaryRS;
        }
    }
}
