
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DRCouponDetail">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CouponNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TicketingProvider" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FlightNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ClassOfService" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="DepartureDtm" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="ArrivalDtm" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DepartureCity" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ArrivalCity" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CouponStatus" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="FareBasis" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="BaggageAllowance" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DRCouponDetail implements Serializable
{
    private String couponNumber;
    private String ticketingProvider;
    private String flightNumber;
    private String classOfService;
    private Date departureDtm;
    private Date arrivalDtm;
    private String departureCity;
    private String arrivalCity;
    private String couponStatus;
    private String fareBasis;
    private String baggageAllowance;

    /** 
     * Get the 'CouponNumber' element value. Unique identifier for a coupon.
     * 
     * @return value
     */
    public String getCouponNumber() {
        return couponNumber;
    }

    /** 
     * Set the 'CouponNumber' element value. Unique identifier for a coupon.
     * 
     * @param couponNumber
     */
    public void setCouponNumber(String couponNumber) {
        this.couponNumber = couponNumber;
    }

    /** 
     * Get the 'TicketingProvider' element value. Carrier code the document was issued for.
     * 
     * @return value
     */
    public String getTicketingProvider() {
        return ticketingProvider;
    }

    /** 
     * Set the 'TicketingProvider' element value. Carrier code the document was issued for.
     * 
     * @param ticketingProvider
     */
    public void setTicketingProvider(String ticketingProvider) {
        this.ticketingProvider = ticketingProvider;
    }

    /** 
     * Get the 'FlightNumber' element value. Flight identifier.
     * 
     * @return value
     */
    public String getFlightNumber() {
        return flightNumber;
    }

    /** 
     * Set the 'FlightNumber' element value. Flight identifier.
     * 
     * @param flightNumber
     */
    public void setFlightNumber(String flightNumber) {
        this.flightNumber = flightNumber;
    }

    /** 
     * Get the 'ClassOfService' element value. Class of service.
     * 
     * @return value
     */
    public String getClassOfService() {
        return classOfService;
    }

    /** 
     * Set the 'ClassOfService' element value. Class of service.
     * 
     * @param classOfService
     */
    public void setClassOfService(String classOfService) {
        this.classOfService = classOfService;
    }

    /** 
     * Get the 'DepartureDtm' element value. Departure date/time.
     * 
     * @return value
     */
    public Date getDepartureDtm() {
        return departureDtm;
    }

    /** 
     * Set the 'DepartureDtm' element value. Departure date/time.
     * 
     * @param departureDtm
     */
    public void setDepartureDtm(Date departureDtm) {
        this.departureDtm = departureDtm;
    }

    /** 
     * Get the 'ArrivalDtm' element value. Arrival date/time.
     * 
     * @return value
     */
    public Date getArrivalDtm() {
        return arrivalDtm;
    }

    /** 
     * Set the 'ArrivalDtm' element value. Arrival date/time.
     * 
     * @param arrivalDtm
     */
    public void setArrivalDtm(Date arrivalDtm) {
        this.arrivalDtm = arrivalDtm;
    }

    /** 
     * Get the 'DepartureCity' element value. Departure 3 letter City Code
     * 
     * @return value
     */
    public String getDepartureCity() {
        return departureCity;
    }

    /** 
     * Set the 'DepartureCity' element value. Departure 3 letter City Code
     * 
     * @param departureCity
     */
    public void setDepartureCity(String departureCity) {
        this.departureCity = departureCity;
    }

    /** 
     * Get the 'ArrivalCity' element value. Arrival 3 letter City Code
     * 
     * @return value
     */
    public String getArrivalCity() {
        return arrivalCity;
    }

    /** 
     * Set the 'ArrivalCity' element value. Arrival 3 letter City Code
     * 
     * @param arrivalCity
     */
    public void setArrivalCity(String arrivalCity) {
        this.arrivalCity = arrivalCity;
    }

    /** 
     * Get the 'CouponStatus' element value. The status of the coupon
     * 
     * @return value
     */
    public String getCouponStatus() {
        return couponStatus;
    }

    /** 
     * Set the 'CouponStatus' element value. The status of the coupon
     * 
     * @param couponStatus
     */
    public void setCouponStatus(String couponStatus) {
        this.couponStatus = couponStatus;
    }

    /** 
     * Get the 'FareBasis' element value. The fare basis as noted on the coupon.
     * 
     * @return value
     */
    public String getFareBasis() {
        return fareBasis;
    }

    /** 
     * Set the 'FareBasis' element value. The fare basis as noted on the coupon.
     * 
     * @param fareBasis
     */
    public void setFareBasis(String fareBasis) {
        this.fareBasis = fareBasis;
    }

    /** 
     * Get the 'BaggageAllowance' element value. The baggage allowance as noted on the coupon.  Can be either piece or weight.
     * 
     * @return value
     */
    public String getBaggageAllowance() {
        return baggageAllowance;
    }

    /** 
     * Set the 'BaggageAllowance' element value. The baggage allowance as noted on the coupon.  Can be either piece or weight.
     * 
     * @param baggageAllowance
     */
    public void setBaggageAllowance(String baggageAllowance) {
        this.baggageAllowance = baggageAllowance;
    }
}
