
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DRExchangeInfo">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="OriginalIssueDocNumber"/>
 *     &lt;xs:element type="xs:date" name="OriginalIssueDate"/>
 *     &lt;xs:element type="xs:string" name="OriginalIssueCity"/>
 *     &lt;xs:element type="xs:string" name="FormOfPaymentCode"/>
 *     &lt;xs:element type="xs:string" name="FormOfPaymentDesc" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="CreditCardVendor" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="MaskedCCNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ExchangeDocNumber" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="xs:string" name="ExchangeDocCouponNumber" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="EvenExchangeShortAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="EvenExchangeOverAmount" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DRExchangeInfo implements Serializable
{
    private String originalIssueDocNumber;
    private Date originalIssueDate;
    private String originalIssueCity;
    private String formOfPaymentCode;
    private String formOfPaymentDesc;
    private String creditCardVendor;
    private String maskedCCNumber;
    private List<String> exchangeDocNumberList = new ArrayList<String>();
    private List<String> exchangeDocCouponNumberList = new ArrayList<String>();
    private MiscMoney evenExchangeShortAmount;
    private MiscMoney evenExchangeOverAmount;

    /** 
     * Get the 'OriginalIssueDocNumber' element value. Unique identifier of the originally issued document.
     * 
     * @return value
     */
    public String getOriginalIssueDocNumber() {
        return originalIssueDocNumber;
    }

    /** 
     * Set the 'OriginalIssueDocNumber' element value. Unique identifier of the originally issued document.
     * 
     * @param originalIssueDocNumber
     */
    public void setOriginalIssueDocNumber(String originalIssueDocNumber) {
        this.originalIssueDocNumber = originalIssueDocNumber;
    }

    /** 
     * Get the 'OriginalIssueDate' element value. Date original document was issued.
     * 
     * @return value
     */
    public Date getOriginalIssueDate() {
        return originalIssueDate;
    }

    /** 
     * Set the 'OriginalIssueDate' element value. Date original document was issued.
     * 
     * @param originalIssueDate
     */
    public void setOriginalIssueDate(Date originalIssueDate) {
        this.originalIssueDate = originalIssueDate;
    }

    /** 
     * Get the 'OriginalIssueCity' element value. City Code where the document was issued.
     * 
     * @return value
     */
    public String getOriginalIssueCity() {
        return originalIssueCity;
    }

    /** 
     * Set the 'OriginalIssueCity' element value. City Code where the document was issued.
     * 
     * @param originalIssueCity
     */
    public void setOriginalIssueCity(String originalIssueCity) {
        this.originalIssueCity = originalIssueCity;
    }

    /** 
     * Get the 'FormOfPaymentCode' element value. Form of payment used to purchase the original document.
     * 
     * @return value
     */
    public String getFormOfPaymentCode() {
        return formOfPaymentCode;
    }

    /** 
     * Set the 'FormOfPaymentCode' element value. Form of payment used to purchase the original document.
     * 
     * @param formOfPaymentCode
     */
    public void setFormOfPaymentCode(String formOfPaymentCode) {
        this.formOfPaymentCode = formOfPaymentCode;
    }

    /** 
     * Get the 'FormOfPaymentDesc' element value. Free form text description containing additional information about the FOP.
     * 
     * @return value
     */
    public String getFormOfPaymentDesc() {
        return formOfPaymentDesc;
    }

    /** 
     * Set the 'FormOfPaymentDesc' element value. Free form text description containing additional information about the FOP.
     * 
     * @param formOfPaymentDesc
     */
    public void setFormOfPaymentDesc(String formOfPaymentDesc) {
        this.formOfPaymentDesc = formOfPaymentDesc;
    }

    /** 
     * Get the 'CreditCardVendor' element value. Vendor code if document was purchased with a credit card.
     * 
     * @return value
     */
    public String getCreditCardVendor() {
        return creditCardVendor;
    }

    /** 
     * Set the 'CreditCardVendor' element value. Vendor code if document was purchased with a credit card.
     * 
     * @param creditCardVendor
     */
    public void setCreditCardVendor(String creditCardVendor) {
        this.creditCardVendor = creditCardVendor;
    }

    /** 
     * Get the 'MaskedCCNumber' element value. Credit card number in masked format showing only partial digits.
     * 
     * @return value
     */
    public String getMaskedCCNumber() {
        return maskedCCNumber;
    }

    /** 
     * Set the 'MaskedCCNumber' element value. Credit card number in masked format showing only partial digits.
     * 
     * @param maskedCCNumber
     */
    public void setMaskedCCNumber(String maskedCCNumber) {
        this.maskedCCNumber = maskedCCNumber;
    }

    /** 
     * Get the list of 'ExchangeDocNumber' element items. Document Number of the new document as a result of the exchange.
     * 
     * @return list
     */
    public List<String> getExchangeDocNumberList() {
        return exchangeDocNumberList;
    }

    /** 
     * Set the list of 'ExchangeDocNumber' element items. Document Number of the new document as a result of the exchange.
     * 
     * @param list
     */
    public void setExchangeDocNumberList(List<String> list) {
        exchangeDocNumberList = list;
    }

    /** 
     * Get the list of 'ExchangeDocCouponNumber' element items. Unique identifier for the new coupon.
     * 
     * @return list
     */
    public List<String> getExchangeDocCouponNumberList() {
        return exchangeDocCouponNumberList;
    }

    /** 
     * Set the list of 'ExchangeDocCouponNumber' element items. Unique identifier for the new coupon.
     * 
     * @param list
     */
    public void setExchangeDocCouponNumberList(List<String> list) {
        exchangeDocCouponNumberList = list;
    }

    /** 
     * Get the 'EvenExchangeShortAmount' element value. Amount of shortage from an even exchange transaction.
     * 
     * @return value
     */
    public MiscMoney getEvenExchangeShortAmount() {
        return evenExchangeShortAmount;
    }

    /** 
     * Set the 'EvenExchangeShortAmount' element value. Amount of shortage from an even exchange transaction.
     * 
     * @param evenExchangeShortAmount
     */
    public void setEvenExchangeShortAmount(MiscMoney evenExchangeShortAmount) {
        this.evenExchangeShortAmount = evenExchangeShortAmount;
    }

    /** 
     * Get the 'EvenExchangeOverAmount' element value. Amount of overage from an even exchange transactions.
     * 
     * @return value
     */
    public MiscMoney getEvenExchangeOverAmount() {
        return evenExchangeOverAmount;
    }

    /** 
     * Set the 'EvenExchangeOverAmount' element value. Amount of overage from an even exchange transactions.
     * 
     * @param evenExchangeOverAmount
     */
    public void setEvenExchangeOverAmount(MiscMoney evenExchangeOverAmount) {
        this.evenExchangeOverAmount = evenExchangeOverAmount;
    }
}
