
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.sql.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DRHeader">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DocumentType"/>
 *     &lt;xs:element type="xs:string" name="IssuingAgentEprCity"/>
 *     &lt;xs:element type="xs:string" name="IssuingAgentDieSine"/>
 *     &lt;xs:element type="xs:string" name="IssueAgentEmpNum"/>
 *     &lt;xs:element type="xs:string" name="PnrLocator" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="DocumentNumber"/>
 *     &lt;xs:element type="xs:string" name="DocumentStatus" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="LastConjunctiveDocumentNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:date" name="IssueDate"/>
 *     &lt;xs:element type="xs:string" name="IssueCity"/>
 *     &lt;xs:element type="xs:string" name="IssueStation"/>
 *     &lt;xs:element type="xs:string" name="PassengerName"/>
 *     &lt;xs:element type="xs:string" name="AgencyId" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="IsElectronicTicket" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="IsManuallyAdded" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="ChangeDtm" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ChangeAgentDieSine" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DRHeader implements Serializable
{
    private String documentType;
    private String issuingAgentEprCity;
    private String issuingAgentDieSine;
    private String issueAgentEmpNum;
    private String pnrLocator;
    private String documentNumber;
    private String documentStatus;
    private String lastConjunctiveDocumentNumber;
    private Date issueDate;
    private String issueCity;
    private String issueStation;
    private String passengerName;
    private String agencyId;
    private Boolean isElectronicTicket;
    private Boolean isManuallyAdded;
    private java.util.Date changeDtm;
    private String changeAgentDieSine;

    /** 
     * Get the 'DocumentType' element value. Type of document issued.
     * 
     * @return value
     */
    public String getDocumentType() {
        return documentType;
    }

    /** 
     * Set the 'DocumentType' element value. Type of document issued.
     * 
     * @param documentType
     */
    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    /** 
     * Get the 'IssuingAgentEprCity' element value. City Code of the agent's home city.
     * 
     * @return value
     */
    public String getIssuingAgentEprCity() {
        return issuingAgentEprCity;
    }

    /** 
     * Set the 'IssuingAgentEprCity' element value. City Code of the agent's home city.
     * 
     * @param issuingAgentEprCity
     */
    public void setIssuingAgentEprCity(String issuingAgentEprCity) {
        this.issuingAgentEprCity = issuingAgentEprCity;
    }

    /** 
     * Get the 'IssuingAgentDieSine' element value. Die Sine of the agent issuing the document.
     * 
     * @return value
     */
    public String getIssuingAgentDieSine() {
        return issuingAgentDieSine;
    }

    /** 
     * Set the 'IssuingAgentDieSine' element value. Die Sine of the agent issuing the document.
     * 
     * @param issuingAgentDieSine
     */
    public void setIssuingAgentDieSine(String issuingAgentDieSine) {
        this.issuingAgentDieSine = issuingAgentDieSine;
    }

    /** 
     * Get the 'IssueAgentEmpNum' element value. Employee number of the agent issuing the document.
     * 
     * @return value
     */
    public String getIssueAgentEmpNum() {
        return issueAgentEmpNum;
    }

    /** 
     * Set the 'IssueAgentEmpNum' element value. Employee number of the agent issuing the document.
     * 
     * @param issueAgentEmpNum
     */
    public void setIssueAgentEmpNum(String issueAgentEmpNum) {
        this.issueAgentEmpNum = issueAgentEmpNum;
    }

    /** 
     * Get the 'PnrLocator' element value. Locator code for document.
     * 
     * @return value
     */
    public String getPnrLocator() {
        return pnrLocator;
    }

    /** 
     * Set the 'PnrLocator' element value. Locator code for document.
     * 
     * @param pnrLocator
     */
    public void setPnrLocator(String pnrLocator) {
        this.pnrLocator = pnrLocator;
    }

    /** 
     * Get the 'DocumentNumber' element value. Unique identifier of the requested document.
     * 
     * @return value
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /** 
     * Set the 'DocumentNumber' element value. Unique identifier of the requested document.
     * 
     * @param documentNumber
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /** 
     * Get the 'DocumentStatus' element value. Indicates status of the document.
     * 
     * @return value
     */
    public String getDocumentStatus() {
        return documentStatus;
    }

    /** 
     * Set the 'DocumentStatus' element value. Indicates status of the document.
     * 
     * @param documentStatus
     */
    public void setDocumentStatus(String documentStatus) {
        this.documentStatus = documentStatus;
    }

    /** 
     * Get the 'LastConjunctiveDocumentNumber' element value. Last document number if the sale included multiple conjunctive documents.
     * 
     * @return value
     */
    public String getLastConjunctiveDocumentNumber() {
        return lastConjunctiveDocumentNumber;
    }

    /** 
     * Set the 'LastConjunctiveDocumentNumber' element value. Last document number if the sale included multiple conjunctive documents.
     * 
     * @param lastConjunctiveDocumentNumber
     */
    public void setLastConjunctiveDocumentNumber(
            String lastConjunctiveDocumentNumber) {
        this.lastConjunctiveDocumentNumber = lastConjunctiveDocumentNumber;
    }

    /** 
     * Get the 'IssueDate' element value. Date document was issued
     * 
     * @return value
     */
    public Date getIssueDate() {
        return issueDate;
    }

    /** 
     * Set the 'IssueDate' element value. Date document was issued
     * 
     * @param issueDate
     */
    public void setIssueDate(Date issueDate) {
        this.issueDate = issueDate;
    }

    /** 
     * Get the 'IssueCity' element value. City Code where the document was issued.
     * 
     * @return value
     */
    public String getIssueCity() {
        return issueCity;
    }

    /** 
     * Set the 'IssueCity' element value. City Code where the document was issued.
     * 
     * @param issueCity
     */
    public void setIssueCity(String issueCity) {
        this.issueCity = issueCity;
    }

    /** 
     * Get the 'IssueStation' element value. Station used to issue the documents.
     * 
     * @return value
     */
    public String getIssueStation() {
        return issueStation;
    }

    /** 
     * Set the 'IssueStation' element value. Station used to issue the documents.
     * 
     * @param issueStation
     */
    public void setIssueStation(String issueStation) {
        this.issueStation = issueStation;
    }

    /** 
     * Get the 'PassengerName' element value. LastName/FirstName.
     * 
     * @return value
     */
    public String getPassengerName() {
        return passengerName;
    }

    /** 
     * Set the 'PassengerName' element value. LastName/FirstName.
     * 
     * @param passengerName
     */
    public void setPassengerName(String passengerName) {
        this.passengerName = passengerName;
    }

    /** 
     * Get the 'AgencyId' element value. Id of the travel agency who issued the document.
     * 
     * @return value
     */
    public String getAgencyId() {
        return agencyId;
    }

    /** 
     * Set the 'AgencyId' element value. Id of the travel agency who issued the document.
     * 
     * @param agencyId
     */
    public void setAgencyId(String agencyId) {
        this.agencyId = agencyId;
    }

    /** 
     * Get the 'IsElectronicTicket' element value. TRUE if the document being returned is an electronic document.
     * 
     * @return value
     */
    public Boolean getIsElectronicTicket() {
        return isElectronicTicket;
    }

    /** 
     * Set the 'IsElectronicTicket' element value. TRUE if the document being returned is an electronic document.
     * 
     * @param isElectronicTicket
     */
    public void setIsElectronicTicket(Boolean isElectronicTicket) {
        this.isElectronicTicket = isElectronicTicket;
    }

    /** 
     * Get the 'IsManuallyAdded' element value. TRUE if the document being returned was manually added..
     * 
     * @return value
     */
    public Boolean getIsManuallyAdded() {
        return isManuallyAdded;
    }

    /** 
     * Set the 'IsManuallyAdded' element value. TRUE if the document being returned was manually added..
     * 
     * @param isManuallyAdded
     */
    public void setIsManuallyAdded(Boolean isManuallyAdded) {
        this.isManuallyAdded = isManuallyAdded;
    }

    /** 
     * Get the 'ChangeDtm' element value. Date/time when the change was completed.
     * 
     * @return value
     */
    public java.util.Date getChangeDtm() {
        return changeDtm;
    }

    /** 
     * Set the 'ChangeDtm' element value. Date/time when the change was completed.
     * 
     * @param changeDtm
     */
    public void setChangeDtm(java.util.Date changeDtm) {
        this.changeDtm = changeDtm;
    }

    /** 
     * Get the 'ChangeAgentDieSine' element value. Die Sine of the agent who changed the document.
     * 
     * @return value
     */
    public String getChangeAgentDieSine() {
        return changeAgentDieSine;
    }

    /** 
     * Set the 'ChangeAgentDieSine' element value. Die Sine of the agent who changed the document.
     * 
     * @param changeAgentDieSine
     */
    public void setChangeAgentDieSine(String changeAgentDieSine) {
        this.changeAgentDieSine = changeAgentDieSine;
    }
}
