
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DRItemDetail">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="Quantity"/>
 *     &lt;xs:element type="xs:string" name="PrasCode"/>
 *     &lt;xs:element type="xs:string" name="PrasDescription"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="ItemAmount"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="ItemTax"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="ItemTotalAmount"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DRItemDetail implements Serializable
{
    private String quantity;
    private String prasCode;
    private String prasDescription;
    private MiscMoney itemAmount;
    private MiscMoney itemTax;
    private MiscMoney itemTotalAmount;

    /** 
     * Get the 'Quantity' element value. The number of items per line associated to the document
     * 
     * @return value
     */
    public String getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'Quantity' element value. The number of items per line associated to the document
     * 
     * @param quantity
     */
    public void setQuantity(String quantity) {
        this.quantity = quantity;
    }

    /** 
     * Get the 'PrasCode' element value. Passenger Revenue Accounting Services code as defined by the carrier.
     * 
     * @return value
     */
    public String getPrasCode() {
        return prasCode;
    }

    /** 
     * Set the 'PrasCode' element value. Passenger Revenue Accounting Services code as defined by the carrier.
     * 
     * @param prasCode
     */
    public void setPrasCode(String prasCode) {
        this.prasCode = prasCode;
    }

    /** 
     * Get the 'PrasDescription' element value. Description of the Passenger Revenue Accounting Services code
     * 
     * @return value
     */
    public String getPrasDescription() {
        return prasDescription;
    }

    /** 
     * Set the 'PrasDescription' element value. Description of the Passenger Revenue Accounting Services code
     * 
     * @param prasDescription
     */
    public void setPrasDescription(String prasDescription) {
        this.prasDescription = prasDescription;
    }

    /** 
     * Get the 'ItemAmount' element value. The amount charged for the item.
     * 
     * @return value
     */
    public MiscMoney getItemAmount() {
        return itemAmount;
    }

    /** 
     * Set the 'ItemAmount' element value. The amount charged for the item.
     * 
     * @param itemAmount
     */
    public void setItemAmount(MiscMoney itemAmount) {
        this.itemAmount = itemAmount;
    }

    /** 
     * Get the 'ItemTax' element value. The amount of tax collected for the item
     * 
     * @return value
     */
    public MiscMoney getItemTax() {
        return itemTax;
    }

    /** 
     * Set the 'ItemTax' element value. The amount of tax collected for the item
     * 
     * @param itemTax
     */
    public void setItemTax(MiscMoney itemTax) {
        this.itemTax = itemTax;
    }

    /** 
     * Get the 'ItemTotalAmount' element value. Total collected for the item.  (Amount + tax)
     * 
     * @return value
     */
    public MiscMoney getItemTotalAmount() {
        return itemTotalAmount;
    }

    /** 
     * Set the 'ItemTotalAmount' element value. Total collected for the item.  (Amount + tax)
     * 
     * @param itemTotalAmount
     */
    public void setItemTotalAmount(MiscMoney itemTotalAmount) {
        this.itemTotalAmount = itemTotalAmount;
    }
}
