
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.CodeCategoryCode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

/** 
 * Information regarding a documents payments. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DSPayment">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:decimal" name="PaymentTotal" minOccurs="1" maxOccurs="1"/>
 *     &lt;xs:element name="PaymentDetail" minOccurs="1" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class PaymentDetail -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DSPayment implements Serializable
{
    private BigDecimal paymentTotal;
    private List<PaymentDetail> paymentDetailList = new ArrayList<PaymentDetail>();

    /** 
     * Get the 'PaymentTotal' element value.
     * 
     * @return value
     */
    public BigDecimal getPaymentTotal() {
        return paymentTotal;
    }

    /** 
     * Set the 'PaymentTotal' element value.
     * 
     * @param paymentTotal
     */
    public void setPaymentTotal(BigDecimal paymentTotal) {
        this.paymentTotal = paymentTotal;
    }

    /** 
     * Get the list of 'PaymentDetail' element items.
     * 
     * @return list
     */
    public List<PaymentDetail> getPaymentDetailList() {
        return paymentDetailList;
    }

    /** 
     * Set the list of 'PaymentDetail' element items.
     * 
     * @param list
     */
    public void setPaymentDetailList(List<PaymentDetail> list) {
        paymentDetailList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PaymentDetail" minOccurs="1" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:_DSPaymentDetail">
     *         &lt;xs:attribute type="xs:string" use="required" name="fop"/>
     *         &lt;xs:attribute type="ns1:Code.CategoryCode" use="optional" name="category"/>
     *         &lt;xs:attribute type="xs:string" use="optional" name="cardType"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class PaymentDetail extends _DSPaymentDetail implements
        Serializable
    {
        private String fop;
        private CodeCategoryCode category;
        private String cardType;

        /** 
         * Get the 'fop' attribute value.
         * 
         * @return value
         */
        public String getFop() {
            return fop;
        }

        /** 
         * Set the 'fop' attribute value.
         * 
         * @param fop
         */
        public void setFop(String fop) {
            this.fop = fop;
        }

        /** 
         * Get the 'category' attribute value. The payment category. Cash and Credit. 
         * 
         * @return value
         */
        public CodeCategoryCode getCategory() {
            return category;
        }

        /** 
         * Set the 'category' attribute value. The payment category. Cash and Credit. 
         * 
         * @param category
         */
        public void setCategory(CodeCategoryCode category) {
            this.category = category;
        }

        /** 
         * Get the 'cardType' attribute value. The Credit Card type that was used for the payment. This is a two digit code ex: VI 
         * 
         * @return value
         */
        public String getCardType() {
            return cardType;
        }

        /** 
         * Set the 'cardType' attribute value. The Credit Card type that was used for the payment. This is a two digit code ex: VI 
         * 
         * @param cardType
         */
        public void setCardType(String cardType) {
            this.cardType = cardType;
        }
    }
}
