
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;

/** 
 * Details pertaining to the stock type and printer information. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DSStockDetails">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="StockControlNumber" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="LastStockControlNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PrinterLniata" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="CouponType" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DSStockDetails implements Serializable
{
    private String stockControlNumber;
    private String lastStockControlNumber;
    private String printerLniata;
    private String couponType;

    /** 
     * Get the 'StockControlNumber' element value. The stock control number. This can be a 10 or 13 digit number. 
     * 
     * @return value
     */
    public String getStockControlNumber() {
        return stockControlNumber;
    }

    /** 
     * Set the 'StockControlNumber' element value. The stock control number. This can be a 10 or 13 digit number. 
     * 
     * @param stockControlNumber
     */
    public void setStockControlNumber(String stockControlNumber) {
        this.stockControlNumber = stockControlNumber;
    }

    /** 
     * Get the 'LastStockControlNumber' element value. The last conjunctive stock control number. 
     * 
     * @return value
     */
    public String getLastStockControlNumber() {
        return lastStockControlNumber;
    }

    /** 
     * Set the 'LastStockControlNumber' element value. The last conjunctive stock control number. 
     * 
     * @param lastStockControlNumber
     */
    public void setLastStockControlNumber(String lastStockControlNumber) {
        this.lastStockControlNumber = lastStockControlNumber;
    }

    /** 
     * Get the 'PrinterLniata' element value. The Line IATA console the agent was signed into when document was issued. 
     * 
     * @return value
     */
    public String getPrinterLniata() {
        return printerLniata;
    }

    /** 
     * Set the 'PrinterLniata' element value. The Line IATA console the agent was signed into when document was issued. 
     * 
     * @param printerLniata
     */
    public void setPrinterLniata(String printerLniata) {
        this.printerLniata = printerLniata;
    }

    /** 
     * Get the 'CouponType' element value. The coupon type. Ex: P (Passenger coupon), F (Flight Coupon), E (Electronic Coupon)
     * 
     * @return value
     */
    public String getCouponType() {
        return couponType;
    }

    /** 
     * Set the 'CouponType' element value. The coupon type. Ex: P (Passenger coupon), F (Flight Coupon), E (Electronic Coupon)
     * 
     * @param couponType
     */
    public void setCouponType(String couponType) {
        this.couponType = couponType;
    }
}
