
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.stl.STLHeaderRS;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * The response generated for a Daily Sales Summary Request. 
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_DailySalesSummaryRS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:STL_Header.RS" name="Header"/>
 *     &lt;xs:element type="ns1:_DSHeader" name="DSHeader" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_DSReport" name="DailySalesReport" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:Misc.Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="isQueryStillRunning"/>
 *   &lt;xs:attribute type="xs:integer" name="reportId"/>
 *   &lt;xs:attribute type="xs:integer" name="chunkNumber"/>
 *   &lt;xs:attribute type="xs:integer" name="maxChunks"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _DailySalesSummaryRS implements Serializable
{
    private STLHeaderRS header;
    private _DSHeader DSHeader;
    private List<_DSReport> dailySalesReportList = new ArrayList<_DSReport>();
    private List<MiscDiagnostic> diagnosticList = new ArrayList<MiscDiagnostic>();
    private String version;
    private boolean isQueryStillRunning;
    private BigInteger reportId;
    private BigInteger chunkNumber;
    private BigInteger maxChunks;

    /** 
     * Get the 'Header' element value. Header information indicating result of the service call, orchestration and transaction identifiers, errors and warnings
     * 
     * @return value
     */
    public STLHeaderRS getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Header information indicating result of the service call, orchestration and transaction identifiers, errors and warnings
     * 
     * @param header
     */
    public void setHeader(STLHeaderRS header) {
        this.header = header;
    }

    /** 
     * Get the 'DSHeader' element value. Daily Sales Summary Header 
     * 
     * @return value
     */
    public _DSHeader getDSHeader() {
        return DSHeader;
    }

    /** 
     * Set the 'DSHeader' element value. Daily Sales Summary Header 
     * 
     * @param DSHeader
     */
    public void setDSHeader(_DSHeader DSHeader) {
        this.DSHeader = DSHeader;
    }

    /** 
     * Get the list of 'DailySalesReport' element items. Daily Sales Report by Date
     * 
     * @return list
     */
    public List<_DSReport> getDailySalesReportList() {
        return dailySalesReportList;
    }

    /** 
     * Set the list of 'DailySalesReport' element items. Daily Sales Report by Date
     * 
     * @param list
     */
    public void setDailySalesReportList(List<_DSReport> list) {
        dailySalesReportList = list;
    }

    /** 
     * Get the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @return list
     */
    public List<MiscDiagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @param list
     */
    public void setDiagnosticList(List<MiscDiagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'isQueryStillRunning' attribute value.
     * 
     * @return value
     */
    public boolean isIsQueryStillRunning() {
        return isQueryStillRunning;
    }

    /** 
     * Set the 'isQueryStillRunning' attribute value.
     * 
     * @param isQueryStillRunning
     */
    public void setIsQueryStillRunning(boolean isQueryStillRunning) {
        this.isQueryStillRunning = isQueryStillRunning;
    }

    /** 
     * Get the 'reportId' attribute value.
     * 
     * @return value
     */
    public BigInteger getReportId() {
        return reportId;
    }

    /** 
     * Set the 'reportId' attribute value.
     * 
     * @param reportId
     */
    public void setReportId(BigInteger reportId) {
        this.reportId = reportId;
    }

    /** 
     * Get the 'chunkNumber' attribute value.
     * 
     * @return value
     */
    public BigInteger getChunkNumber() {
        return chunkNumber;
    }

    /** 
     * Set the 'chunkNumber' attribute value.
     * 
     * @param chunkNumber
     */
    public void setChunkNumber(BigInteger chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    /** 
     * Get the 'maxChunks' attribute value.
     * 
     * @return value
     */
    public BigInteger getMaxChunks() {
        return maxChunks;
    }

    /** 
     * Set the 'maxChunks' attribute value.
     * 
     * @param maxChunks
     */
    public void setMaxChunks(BigInteger maxChunks) {
        this.maxChunks = maxChunks;
    }
}
