
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_ExceptionDocument">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DocumentNumber"/>
 *     &lt;xs:element type="xs:string" name="StationNumber"/>
 *     &lt;xs:element type="xs:string" name="IssuingAgentEprCity"/>
 *     &lt;xs:element type="xs:string" name="IssuingAgentDieSine"/>
 *     &lt;xs:element type="xs:dateTime" name="StationOpenDtm"/>
 *     &lt;xs:element type="xs:dateTime" name="ReceiveSystemDtm"/>
 *     &lt;xs:element name="DocumentAmount" minOccurs="1" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class DocumentAmount -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _ExceptionDocument implements Serializable
{
    private String documentNumber;
    private String stationNumber;
    private String issuingAgentEprCity;
    private String issuingAgentDieSine;
    private Date stationOpenDtm;
    private Date receiveSystemDtm;
    private List<DocumentAmount> documentAmountList = new ArrayList<DocumentAmount>();

    /** 
     * Get the 'DocumentNumber' element value. Unique identifier of the document.
     * 
     * @return value
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /** 
     * Set the 'DocumentNumber' element value. Unique identifier of the document.
     * 
     * @param documentNumber
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /** 
     * Get the 'StationNumber' element value. Station where document was issued.
     * 
     * @return value
     */
    public String getStationNumber() {
        return stationNumber;
    }

    /** 
     * Set the 'StationNumber' element value. Station where document was issued.
     * 
     * @param stationNumber
     */
    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    /** 
     * Get the 'IssuingAgentEprCity' element value. City Code of the agent's home city.
     * 
     * @return value
     */
    public String getIssuingAgentEprCity() {
        return issuingAgentEprCity;
    }

    /** 
     * Set the 'IssuingAgentEprCity' element value. City Code of the agent's home city.
     * 
     * @param issuingAgentEprCity
     */
    public void setIssuingAgentEprCity(String issuingAgentEprCity) {
        this.issuingAgentEprCity = issuingAgentEprCity;
    }

    /** 
     * Get the 'IssuingAgentDieSine' element value. Die Sine of the agent issuing the documents.
     * 
     * @return value
     */
    public String getIssuingAgentDieSine() {
        return issuingAgentDieSine;
    }

    /** 
     * Set the 'IssuingAgentDieSine' element value. Die Sine of the agent issuing the documents.
     * 
     * @param issuingAgentDieSine
     */
    public void setIssuingAgentDieSine(String issuingAgentDieSine) {
        this.issuingAgentDieSine = issuingAgentDieSine;
    }

    /** 
     * Get the 'StationOpenDtm' element value. Date/time when station was opened.
     * 
     * @return value
     */
    public Date getStationOpenDtm() {
        return stationOpenDtm;
    }

    /** 
     * Set the 'StationOpenDtm' element value. Date/time when station was opened.
     * 
     * @param stationOpenDtm
     */
    public void setStationOpenDtm(Date stationOpenDtm) {
        this.stationOpenDtm = stationOpenDtm;
    }

    /** 
     * Get the 'ReceiveSystemDtm' element value. Date/time when system processed the document.
     * 
     * @return value
     */
    public Date getReceiveSystemDtm() {
        return receiveSystemDtm;
    }

    /** 
     * Set the 'ReceiveSystemDtm' element value. Date/time when system processed the document.
     * 
     * @param receiveSystemDtm
     */
    public void setReceiveSystemDtm(Date receiveSystemDtm) {
        this.receiveSystemDtm = receiveSystemDtm;
    }

    /** 
     * Get the list of 'DocumentAmount' element items.
     * 
     * @return list
     */
    public List<DocumentAmount> getDocumentAmountList() {
        return documentAmountList;
    }

    /** 
     * Set the list of 'DocumentAmount' element items.
     * 
     * @param list
     */
    public void setDocumentAmountList(List<DocumentAmount> list) {
        documentAmountList = list;
    }
    /** 
     * Total money collected for the document.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DocumentAmount" minOccurs="1" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="fop"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class DocumentAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String fop;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'fop' attribute value.
         * 
         * @return value
         */
        public String getFop() {
            return fop;
        }

        /** 
         * Set the 'fop' attribute value.
         * 
         * @param fop
         */
        public void setFop(String fop) {
            this.fop = fop;
        }
    }
}
