
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Totals broken up by currency.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_ExceptionDocuments">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CurrencyCode"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="CurrencyTotal"/>
 *     &lt;xs:element type="ns:_ExceptionDocument" name="Document" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _ExceptionDocuments implements Serializable
{
    private String currencyCode;
    private MiscMoney currencyTotal;
    private List<_ExceptionDocument> documentList = new ArrayList<_ExceptionDocument>();

    /** 
     * Get the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'CurrencyTotal' element value. Total money collected.
     * 
     * @return value
     */
    public MiscMoney getCurrencyTotal() {
        return currencyTotal;
    }

    /** 
     * Set the 'CurrencyTotal' element value. Total money collected.
     * 
     * @param currencyTotal
     */
    public void setCurrencyTotal(MiscMoney currencyTotal) {
        this.currencyTotal = currencyTotal;
    }

    /** 
     * Get the list of 'Document' element items. Document issued.
     * 
     * @return list
     */
    public List<_ExceptionDocument> getDocumentList() {
        return documentList;
    }

    /** 
     * Set the list of 'Document' element items. Document issued.
     * 
     * @param list
     */
    public void setDocumentList(List<_ExceptionDocument> list) {
        documentList = list;
    }
}
