
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.sql.Time;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_SSTransaction">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DocumentType"/>
 *     &lt;xs:element type="xs:string" name="DocumentNumber"/>
 *     &lt;xs:element type="xs:string" name="LastConjunctiveDocumentNumber" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="PassengerName"/>
 *     &lt;xs:element type="xs:string" name="PnrLocator" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TicketPrinterLniata"/>
 *     &lt;xs:element type="xs:time" name="TransactionTime"/>
 *     &lt;xs:element type="xs:boolean" name="ExceptionItem" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="DecoupleItem" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="TicketStatusCode" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="TotalCommissionAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="IsElectronicTicket" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="IsManuallyAdded" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="IsModified" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns:_SSFop" name="SSFop" minOccurs="1" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="OBFeesIncluded"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _SSTransaction implements Serializable
{
    private String documentType;
    private String documentNumber;
    private String lastConjunctiveDocumentNumber;
    private String passengerName;
    private String pnrLocator;
    private String ticketPrinterLniata;
    private Time transactionTime;
    private Boolean exceptionItem;
    private Boolean decoupleItem;
    private String ticketStatusCode;
    private MiscMoney totalCommissionAmount;
    private Boolean isElectronicTicket;
    private Boolean isManuallyAdded;
    private Boolean isModified;
    private List<_SSFop> SSFopList = new ArrayList<_SSFop>();
    private Boolean OBFeesIncluded;

    /** 
     * Get the 'DocumentType' element value. Type of document issued.
     * 
     * @return value
     */
    public String getDocumentType() {
        return documentType;
    }

    /** 
     * Set the 'DocumentType' element value. Type of document issued.
     * 
     * @param documentType
     */
    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    /** 
     * Get the 'DocumentNumber' element value. Unique identifier of the issued document.
     * 
     * @return value
     */
    public String getDocumentNumber() {
        return documentNumber;
    }

    /** 
     * Set the 'DocumentNumber' element value. Unique identifier of the issued document.
     * 
     * @param documentNumber
     */
    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    /** 
     * Get the 'LastConjunctiveDocumentNumber' element value. Last document number if the sale included multiple conjunctive documents.
     * 
     * @return value
     */
    public String getLastConjunctiveDocumentNumber() {
        return lastConjunctiveDocumentNumber;
    }

    /** 
     * Set the 'LastConjunctiveDocumentNumber' element value. Last document number if the sale included multiple conjunctive documents.
     * 
     * @param lastConjunctiveDocumentNumber
     */
    public void setLastConjunctiveDocumentNumber(
            String lastConjunctiveDocumentNumber) {
        this.lastConjunctiveDocumentNumber = lastConjunctiveDocumentNumber;
    }

    /** 
     * Get the 'PassengerName' element value. LastName/FirstName.
     * 
     * @return value
     */
    public String getPassengerName() {
        return passengerName;
    }

    /** 
     * Set the 'PassengerName' element value. LastName/FirstName.
     * 
     * @param passengerName
     */
    public void setPassengerName(String passengerName) {
        this.passengerName = passengerName;
    }

    /** 
     * Get the 'PnrLocator' element value. Locator code for document.
     * 
     * @return value
     */
    public String getPnrLocator() {
        return pnrLocator;
    }

    /** 
     * Set the 'PnrLocator' element value. Locator code for document.
     * 
     * @param pnrLocator
     */
    public void setPnrLocator(String pnrLocator) {
        this.pnrLocator = pnrLocator;
    }

    /** 
     * Get the 'TicketPrinterLniata' element value. Line IATA console the agent was signed into when document was issued.
     * 
     * @return value
     */
    public String getTicketPrinterLniata() {
        return ticketPrinterLniata;
    }

    /** 
     * Set the 'TicketPrinterLniata' element value. Line IATA console the agent was signed into when document was issued.
     * 
     * @param ticketPrinterLniata
     */
    public void setTicketPrinterLniata(String ticketPrinterLniata) {
        this.ticketPrinterLniata = ticketPrinterLniata;
    }

    /** 
     * Get the 'TransactionTime' element value. Time the document was issued.
     * 
     * @return value
     */
    public Time getTransactionTime() {
        return transactionTime;
    }

    /** 
     * Set the 'TransactionTime' element value. Time the document was issued.
     * 
     * @param transactionTime
     */
    public void setTransactionTime(Time transactionTime) {
        this.transactionTime = transactionTime;
    }

    /** 
     * Get the 'ExceptionItem' element value. Documents updated after the Station was closed
     * 
     * @return value
     */
    public Boolean getExceptionItem() {
        return exceptionItem;
    }

    /** 
     * Set the 'ExceptionItem' element value. Documents updated after the Station was closed
     * 
     * @param exceptionItem
     */
    public void setExceptionItem(Boolean exceptionItem) {
        this.exceptionItem = exceptionItem;
    }

    /** 
     * Get the 'DecoupleItem' element value. Document not associated with a shift when issued.
     * 
     * @return value
     */
    public Boolean getDecoupleItem() {
        return decoupleItem;
    }

    /** 
     * Set the 'DecoupleItem' element value. Document not associated with a shift when issued.
     * 
     * @param decoupleItem
     */
    public void setDecoupleItem(Boolean decoupleItem) {
        this.decoupleItem = decoupleItem;
    }

    /** 
     * Get the 'TicketStatusCode' element value. Document status code.
     * 
     * @return value
     */
    public String getTicketStatusCode() {
        return ticketStatusCode;
    }

    /** 
     * Set the 'TicketStatusCode' element value. Document status code.
     * 
     * @param ticketStatusCode
     */
    public void setTicketStatusCode(String ticketStatusCode) {
        this.ticketStatusCode = ticketStatusCode;
    }

    /** 
     * Get the 'TotalCommissionAmount' element value. The total amount of the commission.
     * 
     * @return value
     */
    public MiscMoney getTotalCommissionAmount() {
        return totalCommissionAmount;
    }

    /** 
     * Set the 'TotalCommissionAmount' element value. The total amount of the commission.
     * 
     * @param totalCommissionAmount
     */
    public void setTotalCommissionAmount(MiscMoney totalCommissionAmount) {
        this.totalCommissionAmount = totalCommissionAmount;
    }

    /** 
     * Get the 'IsElectronicTicket' element value. TRUE if an electronic document.
     * 
     * @return value
     */
    public Boolean getIsElectronicTicket() {
        return isElectronicTicket;
    }

    /** 
     * Set the 'IsElectronicTicket' element value. TRUE if an electronic document.
     * 
     * @param isElectronicTicket
     */
    public void setIsElectronicTicket(Boolean isElectronicTicket) {
        this.isElectronicTicket = isElectronicTicket;
    }

    /** 
     * Get the 'IsManuallyAdded' element value. TRUE if manually added document.
     * 
     * @return value
     */
    public Boolean getIsManuallyAdded() {
        return isManuallyAdded;
    }

    /** 
     * Set the 'IsManuallyAdded' element value. TRUE if manually added document.
     * 
     * @param isManuallyAdded
     */
    public void setIsManuallyAdded(Boolean isManuallyAdded) {
        this.isManuallyAdded = isManuallyAdded;
    }

    /** 
     * Get the 'IsModified' element value. TRUE if document has been modified.
     * 
     * @return value
     */
    public Boolean getIsModified() {
        return isModified;
    }

    /** 
     * Set the 'IsModified' element value. TRUE if document has been modified.
     * 
     * @param isModified
     */
    public void setIsModified(Boolean isModified) {
        this.isModified = isModified;
    }

    /** 
     * Get the list of 'SSFop' element items. Form of Payment information.
     * 
     * @return list
     */
    public List<_SSFop> getSSFopList() {
        return SSFopList;
    }

    /** 
     * Set the list of 'SSFop' element items. Form of Payment information.
     * 
     * @param list
     */
    public void setSSFopList(List<_SSFop> list) {
        SSFopList = list;
    }

    /** 
     * Get the 'OBFeesIncluded' attribute value. Indicates that the document has one or more OB fees
     * 
     * @return value
     */
    public Boolean getOBFeesIncluded() {
        return OBFeesIncluded;
    }

    /** 
     * Set the 'OBFeesIncluded' attribute value. Indicates that the document has one or more OB fees
     * 
     * @param OBFeesIncluded
     */
    public void setOBFeesIncluded(Boolean OBFeesIncluded) {
        this.OBFeesIncluded = OBFeesIncluded;
    }
}
