
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StaSumAdjustmentDetails">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="EmployeeName"/>
 *     &lt;xs:element type="xs:string" name="EndUserEmployeeNumber"/>
 *     &lt;xs:element name="AgentCashAmount" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class AgentCashAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AgentCheckAmount" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class AgentCheckAmount -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="xs:string" name="Remark"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StaSumAdjustmentDetails implements Serializable
{
    private String employeeName;
    private String endUserEmployeeNumber;
    private AgentCashAmount agentCashAmount;
    private AgentCheckAmount agentCheckAmount;
    private String remark;

    /** 
     * Get the 'EmployeeName' element value. Name of the employee that made the adjustmen
     * 
     * @return value
     */
    public String getEmployeeName() {
        return employeeName;
    }

    /** 
     * Set the 'EmployeeName' element value. Name of the employee that made the adjustmen
     * 
     * @param employeeName
     */
    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    /** 
     * Get the 'EndUserEmployeeNumber' element value. The six digit employee number, plus an optional three character code
     * 
     * @return value
     */
    public String getEndUserEmployeeNumber() {
        return endUserEmployeeNumber;
    }

    /** 
     * Set the 'EndUserEmployeeNumber' element value. The six digit employee number, plus an optional three character code
     * 
     * @param endUserEmployeeNumber
     */
    public void setEndUserEmployeeNumber(String endUserEmployeeNumber) {
        this.endUserEmployeeNumber = endUserEmployeeNumber;
    }

    /** 
     * Get the 'AgentCashAmount' element value.
     * 
     * @return value
     */
    public AgentCashAmount getAgentCashAmount() {
        return agentCashAmount;
    }

    /** 
     * Set the 'AgentCashAmount' element value.
     * 
     * @param agentCashAmount
     */
    public void setAgentCashAmount(AgentCashAmount agentCashAmount) {
        this.agentCashAmount = agentCashAmount;
    }

    /** 
     * Get the 'AgentCheckAmount' element value.
     * 
     * @return value
     */
    public AgentCheckAmount getAgentCheckAmount() {
        return agentCheckAmount;
    }

    /** 
     * Set the 'AgentCheckAmount' element value.
     * 
     * @param agentCheckAmount
     */
    public void setAgentCheckAmount(AgentCheckAmount agentCheckAmount) {
        this.agentCheckAmount = agentCheckAmount;
    }

    /** 
     * Get the 'Remark' element value. Explanation for the adjustment.
     * 
     * @return value
     */
    public String getRemark() {
        return remark;
    }

    /** 
     * Set the 'Remark' element value. Explanation for the adjustment.
     * 
     * @param remark
     */
    public void setRemark(String remark) {
        this.remark = remark;
    }
    /** 
     * Adjustment for cash on hand.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentCashAmount" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AgentCashAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
    /** 
     * Adjustment for checks on hand.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AgentCheckAmount" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="currencyCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AgentCheckAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String currencyCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'currencyCode' attribute value.
         * 
         * @return value
         */
        public String getCurrencyCode() {
            return currencyCode;
        }

        /** 
         * Set the 'currencyCode' attribute value.
         * 
         * @param currencyCode
         */
        public void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }
    }
}
