
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StaSumHeader">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="StationNumber"/>
 *     &lt;xs:element type="xs:string" name="StationName"/>
 *     &lt;xs:element type="xs:integer" name="NumExceptionItems" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="StationStatusCode"/>
 *     &lt;xs:element type="xs:dateTime" name="StationClosedDtm" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ClosingAgentEprCity" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:string" name="ClosingAgentDieSine" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:boolean" name="IsAutoClosed"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" name="isEtPtOptionEnabled"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StaSumHeader implements Serializable
{
    private String stationNumber;
    private String stationName;
    private BigInteger numExceptionItems;
    private String stationStatusCode;
    private Date stationClosedDtm;
    private String closingAgentEprCity;
    private String closingAgentDieSine;
    private boolean isAutoClosed;
    private Boolean isEtPtOptionEnabled;

    /** 
     * Get the 'StationNumber' element value. Only documents issued at this station will be returned.
     * 
     * @return value
     */
    public String getStationNumber() {
        return stationNumber;
    }

    /** 
     * Set the 'StationNumber' element value. Only documents issued at this station will be returned.
     * 
     * @param stationNumber
     */
    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    /** 
     * Get the 'StationName' element value. Only documents issued at this station will be returned.
     * 
     * @return value
     */
    public String getStationName() {
        return stationName;
    }

    /** 
     * Set the 'StationName' element value. Only documents issued at this station will be returned.
     * 
     * @param stationName
     */
    public void setStationName(String stationName) {
        this.stationName = stationName;
    }

    /** 
     * Get the 'NumExceptionItems' element value. Exception Item number.
     * 
     * @return value
     */
    public BigInteger getNumExceptionItems() {
        return numExceptionItems;
    }

    /** 
     * Set the 'NumExceptionItems' element value. Exception Item number.
     * 
     * @param numExceptionItems
     */
    public void setNumExceptionItems(BigInteger numExceptionItems) {
        this.numExceptionItems = numExceptionItems;
    }

    /** 
     * Get the 'StationStatusCode' element value. The status of the station at time of the report.
     * 
     * @return value
     */
    public String getStationStatusCode() {
        return stationStatusCode;
    }

    /** 
     * Set the 'StationStatusCode' element value. The status of the station at time of the report.
     * 
     * @param stationStatusCode
     */
    public void setStationStatusCode(String stationStatusCode) {
        this.stationStatusCode = stationStatusCode;
    }

    /** 
     * Get the 'StationClosedDtm' element value. Date/time station was closed, not present if still open.
     * 
     * @return value
     */
    public Date getStationClosedDtm() {
        return stationClosedDtm;
    }

    /** 
     * Set the 'StationClosedDtm' element value. Date/time station was closed, not present if still open.
     * 
     * @param stationClosedDtm
     */
    public void setStationClosedDtm(Date stationClosedDtm) {
        this.stationClosedDtm = stationClosedDtm;
    }

    /** 
     * Get the 'ClosingAgentEprCity' element value. City Code of the closing agent's home city.
     * 
     * @return value
     */
    public String getClosingAgentEprCity() {
        return closingAgentEprCity;
    }

    /** 
     * Set the 'ClosingAgentEprCity' element value. City Code of the closing agent's home city.
     * 
     * @param closingAgentEprCity
     */
    public void setClosingAgentEprCity(String closingAgentEprCity) {
        this.closingAgentEprCity = closingAgentEprCity;
    }

    /** 
     * Get the 'ClosingAgentDieSine' element value. Die Sine of the closing agent.
     * 
     * @return value
     */
    public String getClosingAgentDieSine() {
        return closingAgentDieSine;
    }

    /** 
     * Set the 'ClosingAgentDieSine' element value. Die Sine of the closing agent.
     * 
     * @param closingAgentDieSine
     */
    public void setClosingAgentDieSine(String closingAgentDieSine) {
        this.closingAgentDieSine = closingAgentDieSine;
    }

    /** 
     * Get the 'IsAutoClosed' element value. Was this report automatically closed by the system?
     * 
     * @return value
     */
    public boolean isIsAutoClosed() {
        return isAutoClosed;
    }

    /** 
     * Set the 'IsAutoClosed' element value. Was this report automatically closed by the system?
     * 
     * @param isAutoClosed
     */
    public void setIsAutoClosed(boolean isAutoClosed) {
        this.isAutoClosed = isAutoClosed;
    }

    /** 
     * Get the 'isEtPtOptionEnabled' attribute value. True means this option is enabled and the ET/PT transactions are not included in the totals.
     * 
     * @return value
     */
    public Boolean getIsEtPtOptionEnabled() {
        return isEtPtOptionEnabled;
    }

    /** 
     * Set the 'isEtPtOptionEnabled' attribute value. True means this option is enabled and the ET/PT transactions are not included in the totals.
     * 
     * @param isEtPtOptionEnabled
     */
    public void setIsEtPtOptionEnabled(Boolean isEtPtOptionEnabled) {
        this.isEtPtOptionEnabled = isEtPtOptionEnabled;
    }
}
