
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StaSumSales">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CurrencyCode"/>
 *     &lt;xs:element type="ns:_StaSumSalesFop" name="SalesTotalsFop" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="ExchangeAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="PrepaidAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="CommisionAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="IgnoredResidualAmount" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="EvenExchangeShortage" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="EvenExchangeOverage" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StaSumSales implements Serializable
{
    private String currencyCode;
    private List<_StaSumSalesFop> salesTotalsFopList = new ArrayList<_StaSumSalesFop>();
    private MiscMoney exchangeAmount;
    private MiscMoney prepaidAmount;
    private MiscMoney commisionAmount;
    private MiscMoney ignoredResidualAmount;
    private MiscMoney evenExchangeShortage;
    private MiscMoney evenExchangeOverage;

    /** 
     * Get the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Currency of the money collected.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the list of 'SalesTotalsFop' element items. Total sales by form of payment.
     * 
     * @return list
     */
    public List<_StaSumSalesFop> getSalesTotalsFopList() {
        return salesTotalsFopList;
    }

    /** 
     * Set the list of 'SalesTotalsFop' element items. Total sales by form of payment.
     * 
     * @param list
     */
    public void setSalesTotalsFopList(List<_StaSumSalesFop> list) {
        salesTotalsFopList = list;
    }

    /** 
     * Get the 'ExchangeAmount' element value. Total amount of exchange transactions.
     * 
     * @return value
     */
    public MiscMoney getExchangeAmount() {
        return exchangeAmount;
    }

    /** 
     * Set the 'ExchangeAmount' element value. Total amount of exchange transactions.
     * 
     * @param exchangeAmount
     */
    public void setExchangeAmount(MiscMoney exchangeAmount) {
        this.exchangeAmount = exchangeAmount;
    }

    /** 
     * Get the 'PrepaidAmount' element value. Total amount of Pre-Paid transactions.
     * 
     * @return value
     */
    public MiscMoney getPrepaidAmount() {
        return prepaidAmount;
    }

    /** 
     * Set the 'PrepaidAmount' element value. Total amount of Pre-Paid transactions.
     * 
     * @param prepaidAmount
     */
    public void setPrepaidAmount(MiscMoney prepaidAmount) {
        this.prepaidAmount = prepaidAmount;
    }

    /** 
     * Get the 'CommisionAmount' element value. Total amount of commission.
     * 
     * @return value
     */
    public MiscMoney getCommisionAmount() {
        return commisionAmount;
    }

    /** 
     * Set the 'CommisionAmount' element value. Total amount of commission.
     * 
     * @param commisionAmount
     */
    public void setCommisionAmount(MiscMoney commisionAmount) {
        this.commisionAmount = commisionAmount;
    }

    /** 
     * Get the 'IgnoredResidualAmount' element value. This functionality requires activation and is controlled by settings in the Ticketing Options Table (maintained by Sabre) and CAT31 fare filings. When active, the system does not include a residual value from an exchange document in the grand total of the report.
     * 
     * @return value
     */
    public MiscMoney getIgnoredResidualAmount() {
        return ignoredResidualAmount;
    }

    /** 
     * Set the 'IgnoredResidualAmount' element value. This functionality requires activation and is controlled by settings in the Ticketing Options Table (maintained by Sabre) and CAT31 fare filings. When active, the system does not include a residual value from an exchange document in the grand total of the report.
     * 
     * @param ignoredResidualAmount
     */
    public void setIgnoredResidualAmount(MiscMoney ignoredResidualAmount) {
        this.ignoredResidualAmount = ignoredResidualAmount;
    }

    /** 
     * Get the 'EvenExchangeShortage' element value. Total amount of shortage from an even exchange transactions.
     * 
     * @return value
     */
    public MiscMoney getEvenExchangeShortage() {
        return evenExchangeShortage;
    }

    /** 
     * Set the 'EvenExchangeShortage' element value. Total amount of shortage from an even exchange transactions.
     * 
     * @param evenExchangeShortage
     */
    public void setEvenExchangeShortage(MiscMoney evenExchangeShortage) {
        this.evenExchangeShortage = evenExchangeShortage;
    }

    /** 
     * Get the 'EvenExchangeOverage' element value. Total amount of overage from an even exchange transactions.
     * 
     * @return value
     */
    public MiscMoney getEvenExchangeOverage() {
        return evenExchangeOverage;
    }

    /** 
     * Set the 'EvenExchangeOverage' element value. Total amount of overage from an even exchange transactions.
     * 
     * @param evenExchangeOverage
     */
    public void setEvenExchangeOverage(MiscMoney evenExchangeOverage) {
        this.evenExchangeOverage = evenExchangeOverage;
    }
}
