
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.CodeOverShortCode;
import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;

/** 
 * List of all reconciliations and subtotals made to this station per currency.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StaSumStationReconciliation">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CurrencyCode"/>
 *     &lt;xs:element name="OverShortAmount" minOccurs="1" maxOccurs="1">
 *       &lt;xs:complexType>
 *         &lt;xs:simpleContent>
 *           &lt;xs:extension base="ns1:Misc.Money">
 *             &lt;xs:attribute type="ns1:Code.OverShortCode" use="required" name="overShortCode"/>
 *           &lt;/xs:extension>
 *         &lt;/xs:simpleContent>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns1:Misc.Money" name="BeforeAmount"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="AfterAmount"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StaSumStationReconciliation implements Serializable
{
    private String currencyCode;
    private MiscMoney overShortAmountMiscMoney;
    private CodeOverShortCode overShortAmountOverShortCode;
    private MiscMoney beforeAmount;
    private MiscMoney afterAmount;

    /** 
     * Get the 'CurrencyCode' element value. Currency of the adjustment.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Currency of the adjustment.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public MiscMoney getOverShortAmountMiscMoney() {
        return overShortAmountMiscMoney;
    }

    /** 
     * Set the extension value.
     * 
     * @param overShortAmountMiscMoney
     */
    public void setOverShortAmountMiscMoney(MiscMoney overShortAmountMiscMoney) {
        this.overShortAmountMiscMoney = overShortAmountMiscMoney;
    }

    /** 
     * Get the 'overShortCode' attribute value.
     * 
     * @return value
     */
    public CodeOverShortCode getOverShortAmountOverShortCode() {
        return overShortAmountOverShortCode;
    }

    /** 
     * Set the 'overShortCode' attribute value.
     * 
     * @param overShortAmountOverShortCode
     */
    public void setOverShortAmountOverShortCode(
            CodeOverShortCode overShortAmountOverShortCode) {
        this.overShortAmountOverShortCode = overShortAmountOverShortCode;
    }

    /** 
     * Get the 'BeforeAmount' element value. Station total cash/check before reconciliation.
     * 
     * @return value
     */
    public MiscMoney getBeforeAmount() {
        return beforeAmount;
    }

    /** 
     * Set the 'BeforeAmount' element value. Station total cash/check before reconciliation.
     * 
     * @param beforeAmount
     */
    public void setBeforeAmount(MiscMoney beforeAmount) {
        this.beforeAmount = beforeAmount;
    }

    /** 
     * Get the 'AfterAmount' element value. Station total cash/check after reconciliation.
     * 
     * @return value
     */
    public MiscMoney getAfterAmount() {
        return afterAmount;
    }

    /** 
     * Set the 'AfterAmount' element value. Station total cash/check after reconciliation.
     * 
     * @param afterAmount
     */
    public void setAfterAmount(MiscMoney afterAmount) {
        this.afterAmount = afterAmount;
    }
}
