
package com.gridnine.sabre.dqb.tktas;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Date;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StationActivity">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="StationNumber"/>
 *     &lt;xs:element type="xs:string" name="StationCode"/>
 *     &lt;xs:element type="xs:dateTime" name="StationOpenDtm"/>
 *     &lt;xs:element type="xs:string" name="StationStatusCode"/>
 *     &lt;xs:element type="xs:dateTime" name="StationCloseDtm" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:dateTime" name="OfflineFileXmitDtm" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="xs:integer" name="NumDocsXmit" minOccurs="0" maxOccurs="1"/>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StationActivity implements Serializable
{
    private String stationNumber;
    private String stationCode;
    private Date stationOpenDtm;
    private String stationStatusCode;
    private Date stationCloseDtm;
    private Date offlineFileXmitDtm;
    private BigInteger numDocsXmit;

    /** 
     * Get the 'StationNumber' element value. Only documents issued at this station will be returned.
     * 
     * @return value
     */
    public String getStationNumber() {
        return stationNumber;
    }

    /** 
     * Set the 'StationNumber' element value. Only documents issued at this station will be returned.
     * 
     * @param stationNumber
     */
    public void setStationNumber(String stationNumber) {
        this.stationNumber = stationNumber;
    }

    /** 
     * Get the 'StationCode' element value. Only documents issued at this station will be returned.
     * 
     * @return value
     */
    public String getStationCode() {
        return stationCode;
    }

    /** 
     * Set the 'StationCode' element value. Only documents issued at this station will be returned.
     * 
     * @param stationCode
     */
    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    /** 
     * Get the 'StationOpenDtm' element value. Date/time when the station was opened.
     * 
     * @return value
     */
    public Date getStationOpenDtm() {
        return stationOpenDtm;
    }

    /** 
     * Set the 'StationOpenDtm' element value. Date/time when the station was opened.
     * 
     * @param stationOpenDtm
     */
    public void setStationOpenDtm(Date stationOpenDtm) {
        this.stationOpenDtm = stationOpenDtm;
    }

    /** 
     * Get the 'StationStatusCode' element value. The status of the station at time of the report.
     * 
     * @return value
     */
    public String getStationStatusCode() {
        return stationStatusCode;
    }

    /** 
     * Set the 'StationStatusCode' element value. The status of the station at time of the report.
     * 
     * @param stationStatusCode
     */
    public void setStationStatusCode(String stationStatusCode) {
        this.stationStatusCode = stationStatusCode;
    }

    /** 
     * Get the 'StationCloseDtm' element value. Date/time station was closed, not present if still open.
     * 
     * @return value
     */
    public Date getStationCloseDtm() {
        return stationCloseDtm;
    }

    /** 
     * Set the 'StationCloseDtm' element value. Date/time station was closed, not present if still open.
     * 
     * @param stationCloseDtm
     */
    public void setStationCloseDtm(Date stationCloseDtm) {
        this.stationCloseDtm = stationCloseDtm;
    }

    /** 
     * Get the 'OfflineFileXmitDtm' element value. Date/time offline file was sent.
     * 
     * @return value
     */
    public Date getOfflineFileXmitDtm() {
        return offlineFileXmitDtm;
    }

    /** 
     * Set the 'OfflineFileXmitDtm' element value. Date/time offline file was sent.
     * 
     * @param offlineFileXmitDtm
     */
    public void setOfflineFileXmitDtm(Date offlineFileXmitDtm) {
        this.offlineFileXmitDtm = offlineFileXmitDtm;
    }

    /** 
     * Get the 'NumDocsXmit' element value. Number of documents included in offline file.
     * 
     * @return value
     */
    public BigInteger getNumDocsXmit() {
        return numDocsXmit;
    }

    /** 
     * Set the 'NumDocsXmit' element value. Number of documents included in offline file.
     * 
     * @param numDocsXmit
     */
    public void setNumDocsXmit(BigInteger numDocsXmit) {
        this.numDocsXmit = numDocsXmit;
    }
}
