
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.stl.STLHeaderRS;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StationActivityRS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:STL_Header.RS" name="Header"/>
 *     &lt;xs:element type="ns1:_StationActivityHeader" name="StationActivityHeader" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_StationActivity" name="StationActivity" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:Misc.Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="isQueryStillRunning"/>
 *   &lt;xs:attribute type="xs:integer" name="reportId"/>
 *   &lt;xs:attribute type="xs:integer" name="chunkNumber"/>
 *   &lt;xs:attribute type="xs:integer" name="maxChunks"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StationActivityRS implements Serializable
{
    private STLHeaderRS header;
    private _StationActivityHeader stationActivityHeader;
    private List<_StationActivity> stationActivityList = new ArrayList<_StationActivity>();
    private List<MiscDiagnostic> diagnosticList = new ArrayList<MiscDiagnostic>();
    private String version;
    private boolean isQueryStillRunning;
    private BigInteger reportId;
    private BigInteger chunkNumber;
    private BigInteger maxChunks;

    /** 
     * Get the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @return value
     */
    public STLHeaderRS getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @param header
     */
    public void setHeader(STLHeaderRS header) {
        this.header = header;
    }

    /** 
     * Get the 'StationActivityHeader' element value. Describes data contained within the whole Station Activity Report.
     * 
     * @return value
     */
    public _StationActivityHeader getStationActivityHeader() {
        return stationActivityHeader;
    }

    /** 
     * Set the 'StationActivityHeader' element value. Describes data contained within the whole Station Activity Report.
     * 
     * @param stationActivityHeader
     */
    public void setStationActivityHeader(
            _StationActivityHeader stationActivityHeader) {
        this.stationActivityHeader = stationActivityHeader;
    }

    /** 
     * Get the list of 'StationActivity' element items. Contains summary data for each station, one element per station.
     * 
     * @return list
     */
    public List<_StationActivity> getStationActivityList() {
        return stationActivityList;
    }

    /** 
     * Set the list of 'StationActivity' element items. Contains summary data for each station, one element per station.
     * 
     * @param list
     */
    public void setStationActivityList(List<_StationActivity> list) {
        stationActivityList = list;
    }

    /** 
     * Get the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @return list
     */
    public List<MiscDiagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @param list
     */
    public void setDiagnosticList(List<MiscDiagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value. Asr Services web service version.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Asr Services web service version.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later.
     * 
     * @return value
     */
    public boolean isIsQueryStillRunning() {
        return isQueryStillRunning;
    }

    /** 
     * Set the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later.
     * 
     * @param isQueryStillRunning
     */
    public void setIsQueryStillRunning(boolean isQueryStillRunning) {
        this.isQueryStillRunning = isQueryStillRunning;
    }

    /** 
     * Get the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @return value
     */
    public BigInteger getReportId() {
        return reportId;
    }

    /** 
     * Set the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @param reportId
     */
    public void setReportId(BigInteger reportId) {
        this.reportId = reportId;
    }

    /** 
     * Get the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @return value
     */
    public BigInteger getChunkNumber() {
        return chunkNumber;
    }

    /** 
     * Set the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @param chunkNumber
     */
    public void setChunkNumber(BigInteger chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    /** 
     * Get the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @return value
     */
    public BigInteger getMaxChunks() {
        return maxChunks;
    }

    /** 
     * Set the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @param maxChunks
     */
    public void setMaxChunks(BigInteger maxChunks) {
        this.maxChunks = maxChunks;
    }
}
