
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.stl.STLHeaderRS;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://services.sabre.com/STL/v01" xmlns:ns1="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_StationSummaryRS">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:STL_Header.RS" name="Header"/>
 *     &lt;xs:element type="ns1:_StaSumHeader" name="StaSumHeader" minOccurs="0" maxOccurs="1"/>
 *     &lt;xs:element type="ns1:_StaSumSales" name="Sales" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:_StaSumTaxes" name="Taxes" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:_StaSumAdjustments" name="Adjustments" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:_StaSumAgentReconciliation" name="AgentReconciliation" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:_StaSumStationReconciliation" name="StationReconciliation" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns1:_StaSumExpectedTotals" name="ExpectedTotals" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element name="Remark" minOccurs="0" maxOccurs="2">
 *       &lt;!-- Reference to inner class Remark -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns1:Misc.Diagnostic" name="Diagnostic" minOccurs="0" maxOccurs="unbounded"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:string" use="required" name="version"/>
 *   &lt;xs:attribute type="xs:boolean" use="required" name="isQueryStillRunning"/>
 *   &lt;xs:attribute type="xs:integer" name="reportId"/>
 *   &lt;xs:attribute type="xs:integer" name="chunkNumber"/>
 *   &lt;xs:attribute type="xs:integer" name="maxChunks"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _StationSummaryRS implements Serializable
{
    private STLHeaderRS header;
    private _StaSumHeader staSumHeader;
    private List<_StaSumSales> saleList = new ArrayList<_StaSumSales>();
    private List<_StaSumTaxes> taxeList = new ArrayList<_StaSumTaxes>();
    private List<_StaSumAdjustments> adjustmentList = new ArrayList<_StaSumAdjustments>();
    private List<_StaSumAgentReconciliation> agentReconciliationList = new ArrayList<_StaSumAgentReconciliation>();
    private List<_StaSumStationReconciliation> stationReconciliationList = new ArrayList<_StaSumStationReconciliation>();
    private List<_StaSumExpectedTotals> expectedTotalList = new ArrayList<_StaSumExpectedTotals>();
    private List<Remark> remarkList = new ArrayList<Remark>();
    private List<MiscDiagnostic> diagnosticList = new ArrayList<MiscDiagnostic>();
    private String version;
    private boolean isQueryStillRunning;
    private BigInteger reportId;
    private BigInteger chunkNumber;
    private BigInteger maxChunks;

    /** 
     * Get the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @return value
     */
    public STLHeaderRS getHeader() {
        return header;
    }

    /** 
     * Set the 'Header' element value. Header information indicating result of the service call, errors and warnings.
     * 
     * @param header
     */
    public void setHeader(STLHeaderRS header) {
        this.header = header;
    }

    /** 
     * Get the 'StaSumHeader' element value. Describes data contained within the whole Station Summary Report
     * 
     * @return value
     */
    public _StaSumHeader getStaSumHeader() {
        return staSumHeader;
    }

    /** 
     * Set the 'StaSumHeader' element value. Describes data contained within the whole Station Summary Report
     * 
     * @param staSumHeader
     */
    public void setStaSumHeader(_StaSumHeader staSumHeader) {
        this.staSumHeader = staSumHeader;
    }

    /** 
     * Get the list of 'Sales' element items. Amount of sales from closed agent reports for a specific station.
     * 
     * @return list
     */
    public List<_StaSumSales> getSaleList() {
        return saleList;
    }

    /** 
     * Set the list of 'Sales' element items. Amount of sales from closed agent reports for a specific station.
     * 
     * @param list
     */
    public void setSaleList(List<_StaSumSales> list) {
        saleList = list;
    }

    /** 
     * Get the list of 'Taxes' element items. Amount of taxes collected by a specific station.
     * 
     * @return list
     */
    public List<_StaSumTaxes> getTaxeList() {
        return taxeList;
    }

    /** 
     * Set the list of 'Taxes' element items. Amount of taxes collected by a specific station.
     * 
     * @param list
     */
    public void setTaxeList(List<_StaSumTaxes> list) {
        taxeList = list;
    }

    /** 
     * Get the list of 'Adjustments' element items. Total amount of adjustments made by the agent.
     * 
     * @return list
     */
    public List<_StaSumAdjustments> getAdjustmentList() {
        return adjustmentList;
    }

    /** 
     * Set the list of 'Adjustments' element items. Total amount of adjustments made by the agent.
     * 
     * @param list
     */
    public void setAdjustmentList(List<_StaSumAdjustments> list) {
        adjustmentList = list;
    }

    /** 
     * Get the list of 'AgentReconciliation' element items. The total amounts collected by the agent and reconciling those amounts to the expected amounts.
     * 
     * @return list
     */
    public List<_StaSumAgentReconciliation> getAgentReconciliationList() {
        return agentReconciliationList;
    }

    /** 
     * Set the list of 'AgentReconciliation' element items. The total amounts collected by the agent and reconciling those amounts to the expected amounts.
     * 
     * @param list
     */
    public void setAgentReconciliationList(List<_StaSumAgentReconciliation> list) {
        agentReconciliationList = list;
    }

    /** 
     * Get the list of 'StationReconciliation' element items. The total amounts collected for the entire station taken from the closed agent reports. 
     * 
     * @return list
     */
    public List<_StaSumStationReconciliation> getStationReconciliationList() {
        return stationReconciliationList;
    }

    /** 
     * Set the list of 'StationReconciliation' element items. The total amounts collected for the entire station taken from the closed agent reports. 
     * 
     * @param list
     */
    public void setStationReconciliationList(
            List<_StaSumStationReconciliation> list) {
        stationReconciliationList = list;
    }

    /** 
     * Get the list of 'ExpectedTotals' element items. The total amounts the system expects the agent to have in their cash/check drawer at time of closing out their report.
     * 
     * @return list
     */
    public List<_StaSumExpectedTotals> getExpectedTotalList() {
        return expectedTotalList;
    }

    /** 
     * Set the list of 'ExpectedTotals' element items. The total amounts the system expects the agent to have in their cash/check drawer at time of closing out their report.
     * 
     * @param list
     */
    public void setExpectedTotalList(List<_StaSumExpectedTotals> list) {
        expectedTotalList = list;
    }

    /** 
     * Get the list of 'Remark' element items.
     * 
     * @return list
     */
    public List<Remark> getRemarkList() {
        return remarkList;
    }

    /** 
     * Set the list of 'Remark' element items.
     * 
     * @param list
     */
    public void setRemarkList(List<Remark> list) {
        remarkList = list;
    }

    /** 
     * Get the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @return list
     */
    public List<MiscDiagnostic> getDiagnosticList() {
        return diagnosticList;
    }

    /** 
     * Set the list of 'Diagnostic' element items. Internal use ONLY
     * 
     * @param list
     */
    public void setDiagnosticList(List<MiscDiagnostic> list) {
        diagnosticList = list;
    }

    /** 
     * Get the 'version' attribute value. Asr Services web service version.
     * 
     * @return value
     */
    public String getVersion() {
        return version;
    }

    /** 
     * Set the 'version' attribute value. Asr Services web service version.
     * 
     * @param version
     */
    public void setVersion(String version) {
        this.version = version;
    }

    /** 
     * Get the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later.
     * 
     * @return value
     */
    public boolean isIsQueryStillRunning() {
        return isQueryStillRunning;
    }

    /** 
     * Set the 'isQueryStillRunning' attribute value. True if the query is still running and thus the report has not yet been cached.  Client should retry later.
     * 
     * @param isQueryStillRunning
     */
    public void setIsQueryStillRunning(boolean isQueryStillRunning) {
        this.isQueryStillRunning = isQueryStillRunning;
    }

    /** 
     * Get the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @return value
     */
    public BigInteger getReportId() {
        return reportId;
    }

    /** 
     * Set the 'reportId' attribute value. ReportId of the returned report.
     * 
     * @param reportId
     */
    public void setReportId(BigInteger reportId) {
        this.reportId = reportId;
    }

    /** 
     * Get the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @return value
     */
    public BigInteger getChunkNumber() {
        return chunkNumber;
    }

    /** 
     * Set the 'chunkNumber' attribute value. Chunk number of the returned report.
     * 
     * @param chunkNumber
     */
    public void setChunkNumber(BigInteger chunkNumber) {
        this.chunkNumber = chunkNumber;
    }

    /** 
     * Get the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @return value
     */
    public BigInteger getMaxChunks() {
        return maxChunks;
    }

    /** 
     * Set the 'maxChunks' attribute value. Total number of chunks which make up the report if the report had to be broken up into pieces.
     * 
     * @param maxChunks
     */
    public void setMaxChunks(BigInteger maxChunks) {
        this.maxChunks = maxChunks;
    }
    /** 
     * Any remark added by a Supervisor.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Remark" minOccurs="0" maxOccurs="2">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:integer" use="required" name="sequenceNumber"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Remark implements Serializable
    {
        private String string;
        private BigInteger sequenceNumber;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'sequenceNumber' attribute value.
         * 
         * @return value
         */
        public BigInteger getSequenceNumber() {
            return sequenceNumber;
        }

        /** 
         * Set the 'sequenceNumber' attribute value.
         * 
         * @param sequenceNumber
         */
        public void setSequenceNumber(BigInteger sequenceNumber) {
            this.sequenceNumber = sequenceNumber;
        }
    }
}
