
package com.gridnine.sabre.dqb.tktas;

import com.gridnine.sabre.dqb.ttl.MiscMoney;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Tax amounts by currency.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="_TaxActivity">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="CurrencyCode"/>
 *     &lt;xs:element type="ns1:Misc.Money" name="TotalTax"/>
 *     &lt;xs:element name="TaxAmount" minOccurs="1" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class TaxAmount -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class _TaxActivity implements Serializable
{
    private String currencyCode;
    private MiscMoney totalTax;
    private List<TaxAmount> taxAmountList = new ArrayList<TaxAmount>();

    /** 
     * Get the 'CurrencyCode' element value. Currency of the tax collected.
     * 
     * @return value
     */
    public String getCurrencyCode() {
        return currencyCode;
    }

    /** 
     * Set the 'CurrencyCode' element value. Currency of the tax collected.
     * 
     * @param currencyCode
     */
    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    /** 
     * Get the 'TotalTax' element value. Total amount collected for this currency.
     * 
     * @return value
     */
    public MiscMoney getTotalTax() {
        return totalTax;
    }

    /** 
     * Set the 'TotalTax' element value. Total amount collected for this currency.
     * 
     * @param totalTax
     */
    public void setTotalTax(MiscMoney totalTax) {
        this.totalTax = totalTax;
    }

    /** 
     * Get the list of 'TaxAmount' element items.
     * 
     * @return list
     */
    public List<TaxAmount> getTaxAmountList() {
        return taxAmountList;
    }

    /** 
     * Set the list of 'TaxAmount' element items.
     * 
     * @param list
     */
    public void setTaxAmountList(List<TaxAmount> list) {
        taxAmountList = list;
    }
    /** 
     * Tax collected for each type of tax.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.sabre.com/ns/Ticketing/AsrServices/1.0" xmlns:ns1="http://www.sabre.com/ns/Ticketing/TTL/1.0" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TaxAmount" minOccurs="1" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="ns1:Misc.Money">
     *         &lt;xs:attribute type="xs:string" use="required" name="taxCode"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TaxAmount implements Serializable
    {
        private MiscMoney miscMoney;
        private String taxCode;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public MiscMoney getMiscMoney() {
            return miscMoney;
        }

        /** 
         * Set the extension value.
         * 
         * @param miscMoney
         */
        public void setMiscMoney(MiscMoney miscMoney) {
            this.miscMoney = miscMoney;
        }

        /** 
         * Get the 'taxCode' attribute value.
         * 
         * @return value
         */
        public String getTaxCode() {
            return taxCode;
        }

        /** 
         * Set the 'taxCode' attribute value.
         * 
         * @param taxCode
         */
        public void setTaxCode(String taxCode) {
            this.taxCode = taxCode;
        }
    }
}
