
package com.gridnine.sabre.jaxws.ota2.message;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementRef;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;
import javax.xml.datatype.XMLGregorianCalendar;
import com.gridnine.sabre.jaxws.ota2.builtins.DataPolicy;
import com.gridnine.sabre.jaxws.ota2.builtins.DataPolicyDetail;
import com.gridnine.sabre.jaxws.ota2.builtins.Encryption;
import com.gridnine.sabre.jaxws.ota2.builtins.EncryptionDetail;
import com.gridnine.sabre.jaxws.ota2.builtins.TargetSystem;
import com.gridnine.sabre.jaxws.ota2.builtins.Transaction;


/**
 * Payload base type for declaring message elements. All messages
 * 				elements must extend this type AND must end with a Extension element.
 * 			
 * 
 * <p>Java class for OTA2_Payload complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="OTA2_Payload">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element ref="{http://opentravel.org/common/v02}DataPolicySubGrp" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element ref="{http://opentravel.org/common/v02}EncryptionSubGrp" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="TargetSystem" type="{http://opentravel.org/common/v02}TargetSystem" minOccurs="0"/>
 *         &lt;element name="Transaction" type="{http://opentravel.org/common/v02}Transaction" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="timeStamp" use="required" type="{http://opentravel.org/common/v02}Date_Timestamp" />
 *       &lt;attribute name="version" use="required" type="{http://www.w3.org/2001/XMLSchema}decimal" />
 *       &lt;attribute name="dataPolicyInd" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *       &lt;attribute name="encryptionInd" type="{http://www.w3.org/2001/XMLSchema}boolean" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "OTA2_Payload", propOrder = {
    "dataPolicySubGrp",
    "encryptionSubGrp",
    "targetSystem",
    "transaction"
})
@XmlSeeAlso({
    OTA2RequestPayload.class,
    OTA2NotifPayload.class,
    OTA2ResponsePayload.class
})
public class OTA2Payload implements Serializable
{

    @XmlElementRef(name = "DataPolicySubGrp", namespace = "http://opentravel.org/common/v02", type = JAXBElement.class, required = false)
    protected List<JAXBElement<? extends DataPolicy>> dataPolicySubGrp;
    @XmlElementRef(name = "EncryptionSubGrp", namespace = "http://opentravel.org/common/v02", type = JAXBElement.class, required = false)
    protected List<JAXBElement<? extends Encryption>> encryptionSubGrp;
    @XmlElement(name = "TargetSystem")
    protected TargetSystem targetSystem;
    @XmlElement(name = "Transaction")
    protected Transaction transaction;
    @XmlAttribute(name = "timeStamp", required = true)
    protected XMLGregorianCalendar timeStamp;
    @XmlAttribute(name = "version", required = true)
    protected BigDecimal version;
    @XmlAttribute(name = "dataPolicyInd")
    protected Boolean dataPolicyInd;
    @XmlAttribute(name = "encryptionInd")
    protected Boolean encryptionInd;

    /**
     * Details about data policy(s) that apply to all or a portion of this message.Gets the value of the dataPolicySubGrp property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the dataPolicySubGrp property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getDataPolicySubGrp().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JAXBElement }{@code <}{@link DataPolicyDetail }{@code >}
     * {@link JAXBElement }{@code <}{@link DataPolicy }{@code >}
     * {@link JAXBElement }{@code <}{@link DataPolicy }{@code >}
     * {@link JAXBElement }{@code <}{@link DataPolicy }{@code >}
     * 
     * 
     */
    public List<JAXBElement<? extends DataPolicy>> getDataPolicySubGrp() {
        if (dataPolicySubGrp == null) {
            dataPolicySubGrp = new ArrayList<JAXBElement<? extends DataPolicy>>();
        }
        return this.dataPolicySubGrp;
    }

    /**
     * Details about encrypted information within this message.Gets the value of the encryptionSubGrp property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the encryptionSubGrp property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getEncryptionSubGrp().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link JAXBElement }{@code <}{@link EncryptionDetail }{@code >}
     * {@link JAXBElement }{@code <}{@link Encryption }{@code >}
     * {@link JAXBElement }{@code <}{@link Encryption }{@code >}
     * {@link JAXBElement }{@code <}{@link Encryption }{@code >}
     * 
     * 
     */
    public List<JAXBElement<? extends Encryption>> getEncryptionSubGrp() {
        if (encryptionSubGrp == null) {
            encryptionSubGrp = new ArrayList<JAXBElement<? extends Encryption>>();
        }
        return this.encryptionSubGrp;
    }

    /**
     * Gets the value of the targetSystem property.
     * 
     * @return
     *     possible object is
     *     {@link TargetSystem }
     *     
     */
    public TargetSystem getTargetSystem() {
        return targetSystem;
    }

    /**
     * Sets the value of the targetSystem property.
     * 
     * @param value
     *     allowed object is
     *     {@link TargetSystem }
     *     
     */
    public void setTargetSystem(TargetSystem value) {
        this.targetSystem = value;
    }

    /**
     * Gets the value of the transaction property.
     * 
     * @return
     *     possible object is
     *     {@link Transaction }
     *     
     */
    public Transaction getTransaction() {
        return transaction;
    }

    /**
     * Sets the value of the transaction property.
     * 
     * @param value
     *     allowed object is
     *     {@link Transaction }
     *     
     */
    public void setTransaction(Transaction value) {
        this.transaction = value;
    }

    /**
     * Gets the value of the timeStamp property.
     * 
     * @return
     *     possible object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public XMLGregorianCalendar getTimeStamp() {
        return timeStamp;
    }

    /**
     * Sets the value of the timeStamp property.
     * 
     * @param value
     *     allowed object is
     *     {@link XMLGregorianCalendar }
     *     
     */
    public void setTimeStamp(XMLGregorianCalendar value) {
        this.timeStamp = value;
    }

    /**
     * Gets the value of the version property.
     * 
     * @return
     *     possible object is
     *     {@link BigDecimal }
     *     
     */
    public BigDecimal getVersion() {
        return version;
    }

    /**
     * Sets the value of the version property.
     * 
     * @param value
     *     allowed object is
     *     {@link BigDecimal }
     *     
     */
    public void setVersion(BigDecimal value) {
        this.version = value;
    }

    /**
     * Gets the value of the dataPolicyInd property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getDataPolicyInd() {
        return dataPolicyInd;
    }

    /**
     * Sets the value of the dataPolicyInd property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDataPolicyInd(Boolean value) {
        this.dataPolicyInd = value;
    }

    /**
     * Gets the value of the encryptionInd property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getEncryptionInd() {
        return encryptionInd;
    }

    /**
     * Sets the value of the encryptionInd property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setEncryptionInd(Boolean value) {
        this.encryptionInd = value;
    }

}
