
package com.gridnine.sabre.jaxws.stl2.buildinmodel;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for Enum_CabinType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="Enum_CabinType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="First"/>
 *     &lt;enumeration value="Business"/>
 *     &lt;enumeration value="Economy"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "Enum_CabinType")
@XmlEnum
public enum EnumCabinType {


    /**
     * First class compartment.
     * 
     */
    @XmlEnumValue("First")
    FIRST("First"),

    /**
     * Business class compartment.
     * 
     */
    @XmlEnumValue("Business")
    BUSINESS("Business"),

    /**
     * Economy (or sometimes referred to as Coach) class
     * 					compartment.
     * 
     */
    @XmlEnumValue("Economy")
    ECONOMY("Economy");
    private final String value;

    EnumCabinType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static EnumCabinType fromValue(String v) {
        for (EnumCabinType c: EnumCabinType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
