
package com.gridnine.sabre.jaxws.stl2.buildinmodel;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for Enum_MealServiceType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="Enum_MealServiceType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="Breakfast"/>
 *     &lt;enumeration value="Snack"/>
 *     &lt;enumeration value="Dinner"/>
 *     &lt;enumeration value="Hot Meal"/>
 *     &lt;enumeration value="Lunch"/>
 *     &lt;enumeration value="Refreshments"/>
 *     &lt;enumeration value="Complimentary Liquor"/>
 *     &lt;enumeration value="Meal"/>
 *     &lt;enumeration value="Liquor for Purchase"/>
 *     &lt;enumeration value="Food for Purchase"/>
 *     &lt;enumeration value="Cold Meal"/>
 *     &lt;enumeration value="No Meal Service"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "Enum_MealServiceType")
@XmlEnum
public enum EnumMealServiceType {


    /**
     * Identifies a breakfast meal service.
     * 
     */
    @XmlEnumValue("Breakfast")
    BREAKFAST("Breakfast"),

    /**
     * Identifies a snack meal service.
     * 
     */
    @XmlEnumValue("Snack")
    SNACK("Snack"),

    /**
     * Identifies a dinner meal service.
     * 
     */
    @XmlEnumValue("Dinner")
    DINNER("Dinner"),

    /**
     * Identifies a hot meal service.
     * 
     */
    @XmlEnumValue("Hot Meal")
    HOT_MEAL("Hot Meal"),

    /**
     * Identifies a lunch meal service.
     * 
     */
    @XmlEnumValue("Lunch")
    LUNCH("Lunch"),

    /**
     * Identifies a refreshments meal service.
     * 
     */
    @XmlEnumValue("Refreshments")
    REFRESHMENTS("Refreshments"),

    /**
     * Identifies a complimentary liquor meal service.
     * 
     */
    @XmlEnumValue("Complimentary Liquor")
    COMPLIMENTARY_LIQUOR("Complimentary Liquor"),

    /**
     * Identifies a meal service exists.
     * 
     */
    @XmlEnumValue("Meal")
    MEAL("Meal"),

    /**
     * Identifies that liquor is available for purchase.
     * 
     */
    @XmlEnumValue("Liquor for Purchase")
    LIQUOR_FOR_PURCHASE("Liquor for Purchase"),

    /**
     * Identifies that food is available for purchase.
     * 
     */
    @XmlEnumValue("Food for Purchase")
    FOOD_FOR_PURCHASE("Food for Purchase"),

    /**
     * Identifies a cold meal service is available.
     * 
     */
    @XmlEnumValue("Cold Meal")
    COLD_MEAL("Cold Meal"),

    /**
     * Identifies that no meal service is available.
     * 
     */
    @XmlEnumValue("No Meal Service")
    NO_MEAL_SERVICE("No Meal Service");
    private final String value;

    EnumMealServiceType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static EnumMealServiceType fromValue(String v) {
        for (EnumMealServiceType c: EnumMealServiceType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
