
package com.sabre.services.merch.ancillary.v03;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.sabre.services.merch.baggage.v03.BaggageEntitlements;
import com.sabre.services.merch.baggage.v03.EffectiveAllowance;
import com.sabre.services.merch.products.v03.AirExtraFromPNR;
import com.sabre.services.merch.products.v03.ServiceType;


/**
 * Ancillary offers per itinerary [PNR].
 * 
 * <p>Java class for AncillaryOffers complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="AncillaryOffers">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Itinerary">
 *           &lt;complexType>
 *             &lt;complexContent>
 *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                 &lt;sequence>
 *                   &lt;element name="AncillariesByServiceType" maxOccurs="unbounded">
 *                     &lt;complexType>
 *                       &lt;complexContent>
 *                         &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *                           &lt;sequence>
 *                             &lt;element name="ServiceType" type="{http://services.sabre.com/merch/products/v03}ServiceType"/>
 *                             &lt;element name="AncillaryGroups" type="{http://services.sabre.com/merch/ancillary/v03}AncillaryGrouping" maxOccurs="unbounded"/>
 *                           &lt;/sequence>
 *                         &lt;/restriction>
 *                       &lt;/complexContent>
 *                     &lt;/complexType>
 *                   &lt;/element>
 *                   &lt;element name="BaggageEntitlements" type="{http://services.sabre.com/merch/baggage/v03}BaggageEntitlements" minOccurs="0"/>
 *                   &lt;element name="EffectiveAllowance" type="{http://services.sabre.com/merch/baggage/v03}EffectiveAllowance" maxOccurs="unbounded" minOccurs="0"/>
 *                   &lt;element name="AirExtras" type="{http://services.sabre.com/merch/products/v03}AirExtraFromPNR" maxOccurs="unbounded" minOccurs="0"/>
 *                 &lt;/sequence>
 *                 &lt;attribute name="PNR_Locator" type="{http://www.w3.org/2001/XMLSchema}string" />
 *               &lt;/restriction>
 *             &lt;/complexContent>
 *           &lt;/complexType>
 *         &lt;/element>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AncillaryOffers", propOrder = {
    "itinerary"
})
public class AncillaryOffers
    implements Serializable
{

    @XmlElement(name = "Itinerary", required = true)
    protected AncillaryOffers.Itinerary itinerary;

    /**
     * Gets the value of the itinerary property.
     * 
     * @return
     *     possible object is
     *     {@link AncillaryOffers.Itinerary }
     *     
     */
    public AncillaryOffers.Itinerary getItinerary() {
        return itinerary;
    }

    /**
     * Sets the value of the itinerary property.
     * 
     * @param value
     *     allowed object is
     *     {@link AncillaryOffers.Itinerary }
     *     
     */
    public void setItinerary(AncillaryOffers.Itinerary value) {
        this.itinerary = value;
    }


    /**
     * <p>Java class for anonymous complex type.
     * 
     * <p>The following schema fragment specifies the expected content contained within this class.
     * 
     * <pre>
     * &lt;complexType>
     *   &lt;complexContent>
     *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *       &lt;sequence>
     *         &lt;element name="AncillariesByServiceType" maxOccurs="unbounded">
     *           &lt;complexType>
     *             &lt;complexContent>
     *               &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
     *                 &lt;sequence>
     *                   &lt;element name="ServiceType" type="{http://services.sabre.com/merch/products/v03}ServiceType"/>
     *                   &lt;element name="AncillaryGroups" type="{http://services.sabre.com/merch/ancillary/v03}AncillaryGrouping" maxOccurs="unbounded"/>
     *                 &lt;/sequence>
     *               &lt;/restriction>
     *             &lt;/complexContent>
     *           &lt;/complexType>
     *         &lt;/element>
     *         &lt;element name="BaggageEntitlements" type="{http://services.sabre.com/merch/baggage/v03}BaggageEntitlements" minOccurs="0"/>
     *         &lt;element name="EffectiveAllowance" type="{http://services.sabre.com/merch/baggage/v03}EffectiveAllowance" maxOccurs="unbounded" minOccurs="0"/>
     *         &lt;element name="AirExtras" type="{http://services.sabre.com/merch/products/v03}AirExtraFromPNR" maxOccurs="unbounded" minOccurs="0"/>
     *       &lt;/sequence>
     *       &lt;attribute name="PNR_Locator" type="{http://www.w3.org/2001/XMLSchema}string" />
     *     &lt;/restriction>
     *   &lt;/complexContent>
     * &lt;/complexType>
     * </pre>
     * 
     * 
     */
    @XmlAccessorType(XmlAccessType.FIELD)
    @XmlType(name = "", propOrder = {
        "ancillariesByServiceType",
        "baggageEntitlements",
        "effectiveAllowance",
        "airExtras"
    })
    public static class Itinerary
        implements Serializable
    {

        @XmlElement(name = "AncillariesByServiceType", required = true)
        protected List<AncillaryOffers.Itinerary.AncillariesByServiceType> ancillariesByServiceType;
        @XmlElement(name = "BaggageEntitlements")
        protected BaggageEntitlements baggageEntitlements;
        @XmlElement(name = "EffectiveAllowance")
        protected List<EffectiveAllowance> effectiveAllowance;
        @XmlElement(name = "AirExtras")
        protected List<AirExtraFromPNR> airExtras;
        @XmlAttribute(name = "PNR_Locator")
        protected String pnrLocator;

        /**
         * Gets the value of the ancillariesByServiceType property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the ancillariesByServiceType property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getAncillariesByServiceType().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link AncillaryOffers.Itinerary.AncillariesByServiceType }
         * 
         * 
         */
        public List<AncillaryOffers.Itinerary.AncillariesByServiceType> getAncillariesByServiceType() {
            if (ancillariesByServiceType == null) {
                ancillariesByServiceType = new ArrayList<AncillaryOffers.Itinerary.AncillariesByServiceType>();
            }
            return this.ancillariesByServiceType;
        }

        /**
         * Gets the value of the baggageEntitlements property.
         * 
         * @return
         *     possible object is
         *     {@link BaggageEntitlements }
         *     
         */
        public BaggageEntitlements getBaggageEntitlements() {
            return baggageEntitlements;
        }

        /**
         * Sets the value of the baggageEntitlements property.
         * 
         * @param value
         *     allowed object is
         *     {@link BaggageEntitlements }
         *     
         */
        public void setBaggageEntitlements(BaggageEntitlements value) {
            this.baggageEntitlements = value;
        }

        /**
         * Gets the value of the effectiveAllowance property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the effectiveAllowance property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getEffectiveAllowance().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link EffectiveAllowance }
         * 
         * 
         */
        public List<EffectiveAllowance> getEffectiveAllowance() {
            if (effectiveAllowance == null) {
                effectiveAllowance = new ArrayList<EffectiveAllowance>();
            }
            return this.effectiveAllowance;
        }

        /**
         * Gets the value of the airExtras property.
         * 
         * <p>
         * This accessor method returns a reference to the live list,
         * not a snapshot. Therefore any modification you make to the
         * returned list will be present inside the JAXB object.
         * This is why there is not a <CODE>set</CODE> method for the airExtras property.
         * 
         * <p>
         * For example, to add a new item, do as follows:
         * <pre>
         *    getAirExtras().add(newItem);
         * </pre>
         * 
         * 
         * <p>
         * Objects of the following type(s) are allowed in the list
         * {@link AirExtraFromPNR }
         * 
         * 
         */
        public List<AirExtraFromPNR> getAirExtras() {
            if (airExtras == null) {
                airExtras = new ArrayList<AirExtraFromPNR>();
            }
            return this.airExtras;
        }

        /**
         * Gets the value of the pnrLocator property.
         * 
         * @return
         *     possible object is
         *     {@link String }
         *     
         */
        public String getPNRLocator() {
            return pnrLocator;
        }

        /**
         * Sets the value of the pnrLocator property.
         * 
         * @param value
         *     allowed object is
         *     {@link String }
         *     
         */
        public void setPNRLocator(String value) {
            this.pnrLocator = value;
        }


        /**
         * <p>Java class for anonymous complex type.
         * 
         * <p>The following schema fragment specifies the expected content contained within this class.
         * 
         * <pre>
         * &lt;complexType>
         *   &lt;complexContent>
         *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
         *       &lt;sequence>
         *         &lt;element name="ServiceType" type="{http://services.sabre.com/merch/products/v03}ServiceType"/>
         *         &lt;element name="AncillaryGroups" type="{http://services.sabre.com/merch/ancillary/v03}AncillaryGrouping" maxOccurs="unbounded"/>
         *       &lt;/sequence>
         *     &lt;/restriction>
         *   &lt;/complexContent>
         * &lt;/complexType>
         * </pre>
         * 
         * 
         */
        @XmlAccessorType(XmlAccessType.FIELD)
        @XmlType(name = "", propOrder = {
            "serviceType",
            "ancillaryGroups"
        })
        public static class AncillariesByServiceType
            implements Serializable
        {

            @XmlElement(name = "ServiceType", required = true)
            protected ServiceType serviceType;
            @XmlElement(name = "AncillaryGroups", required = true)
            protected List<AncillaryGrouping> ancillaryGroups;

            /**
             * Gets the value of the serviceType property.
             * 
             * @return
             *     possible object is
             *     {@link ServiceType }
             *     
             */
            public ServiceType getServiceType() {
                return serviceType;
            }

            /**
             * Sets the value of the serviceType property.
             * 
             * @param value
             *     allowed object is
             *     {@link ServiceType }
             *     
             */
            public void setServiceType(ServiceType value) {
                this.serviceType = value;
            }

            /**
             * Gets the value of the ancillaryGroups property.
             * 
             * <p>
             * This accessor method returns a reference to the live list,
             * not a snapshot. Therefore any modification you make to the
             * returned list will be present inside the JAXB object.
             * This is why there is not a <CODE>set</CODE> method for the ancillaryGroups property.
             * 
             * <p>
             * For example, to add a new item, do as follows:
             * <pre>
             *    getAncillaryGroups().add(newItem);
             * </pre>
             * 
             * 
             * <p>
             * Objects of the following type(s) are allowed in the list
             * {@link AncillaryGrouping }
             * 
             * 
             */
            public List<AncillaryGrouping> getAncillaryGroups() {
                if (ancillaryGroups == null) {
                    ancillaryGroups = new ArrayList<AncillaryGrouping>();
                }
                return this.ancillaryGroups;
            }

        }

    }

}
