
package com.sabre.services.merch.itinerary.v03;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlType;
import com.sabre.services.merch.common.v03.SSRDetails;
import com.sabre.services.merch.fare.v03.FareBreakAssociation;
import com.sabre.services.merch.ticket.v03.Coupon;


/**
 * Passenger segment reference.
 * 
 * <p>Java class for PassengerSegment complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="PassengerSegment">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="FareBreakAssociation" type="{http://services.sabre.com/merch/fare/v03}FareBreakAssociation" maxOccurs="unbounded" minOccurs="0"/>
 *         &lt;element name="PassengerSegmentSSR" type="{http://services.sabre.com/merch/common/v03}SSR_Details" minOccurs="0"/>
 *         &lt;element name="Coupon" type="{http://services.sabre.com/merch/ticket/v03}Coupon" minOccurs="0"/>
 *       &lt;/sequence>
 *       &lt;attribute name="segmentRef" use="required" type="{http://www.w3.org/2001/XMLSchema}IDREF" />
 *       &lt;attribute name="ticketCouponNumber" type="{http://www.w3.org/2001/XMLSchema}int" />
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "PassengerSegment", propOrder = {
    "fareBreakAssociation",
    "passengerSegmentSSR",
    "coupon"
})
public class PassengerSegment
    implements Serializable
{

    @XmlElement(name = "FareBreakAssociation")
    protected List<FareBreakAssociation> fareBreakAssociation;
    @XmlElement(name = "PassengerSegmentSSR")
    protected SSRDetails passengerSegmentSSR;
    @XmlElement(name = "Coupon")
    protected Coupon coupon;
    @XmlAttribute(name = "segmentRef", required = true)
    @XmlIDREF
    @XmlSchemaType(name = "IDREF")
    protected Object segmentRef;
    @XmlAttribute(name = "ticketCouponNumber")
    protected Integer ticketCouponNumber;

    /**
     * Gets the value of the fareBreakAssociation property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the fareBreakAssociation property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getFareBreakAssociation().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link FareBreakAssociation }
     * 
     * 
     */
    public List<FareBreakAssociation> getFareBreakAssociation() {
        if (fareBreakAssociation == null) {
            fareBreakAssociation = new ArrayList<FareBreakAssociation>();
        }
        return this.fareBreakAssociation;
    }

    /**
     * Gets the value of the passengerSegmentSSR property.
     * 
     * @return
     *     possible object is
     *     {@link SSRDetails }
     *     
     */
    public SSRDetails getPassengerSegmentSSR() {
        return passengerSegmentSSR;
    }

    /**
     * Sets the value of the passengerSegmentSSR property.
     * 
     * @param value
     *     allowed object is
     *     {@link SSRDetails }
     *     
     */
    public void setPassengerSegmentSSR(SSRDetails value) {
        this.passengerSegmentSSR = value;
    }

    /**
     * Gets the value of the coupon property.
     * 
     * @return
     *     possible object is
     *     {@link Coupon }
     *     
     */
    public Coupon getCoupon() {
        return coupon;
    }

    /**
     * Sets the value of the coupon property.
     * 
     * @param value
     *     allowed object is
     *     {@link Coupon }
     *     
     */
    public void setCoupon(Coupon value) {
        this.coupon = value;
    }

    /**
     * Gets the value of the segmentRef property.
     * 
     * @return
     *     possible object is
     *     {@link Object }
     *     
     */
    public Object getSegmentRef() {
        return segmentRef;
    }

    /**
     * Sets the value of the segmentRef property.
     * 
     * @param value
     *     allowed object is
     *     {@link Object }
     *     
     */
    public void setSegmentRef(Object value) {
        this.segmentRef = value;
    }

    /**
     * Gets the value of the ticketCouponNumber property.
     * 
     * @return
     *     possible object is
     *     {@link Integer }
     *     
     */
    public Integer getTicketCouponNumber() {
        return ticketCouponNumber;
    }

    /**
     * Sets the value of the ticketCouponNumber property.
     * 
     * @param value
     *     allowed object is
     *     {@link Integer }
     *     
     */
    public void setTicketCouponNumber(Integer value) {
        this.ticketCouponNumber = value;
    }

}
