
package com.sabre.services.merch.products.v03;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import com.sabre.services.merch.common.v03.PriceElement;


/**
 * 
 *                 A single pricing option for an ancillary. An ancillary may have multiple pricing options
 *                 depending on the passenger type, loyalty, rules, occurrence.
 *             
 * 
 * <p>Java class for AncillaryFee complex type.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * 
 * <pre>
 * &lt;complexType name="AncillaryFee">
 *   &lt;complexContent>
 *     &lt;restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       &lt;sequence>
 *         &lt;element name="Unavailable" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="TaxExemptIndicator" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *         &lt;element name="TaxExempt" type="{http://services.sabre.com/merch/common/v03}PriceElement" minOccurs="0"/>
 *         &lt;element name="TaxesIncludedInBase" type="{http://www.w3.org/2001/XMLSchema}string" minOccurs="0"/>
 *         &lt;element name="Tax" type="{http://services.sabre.com/merch/common/v03}PriceElement" maxOccurs="10" minOccurs="0"/>
 *         &lt;element name="TotalTaxes" type="{http://services.sabre.com/merch/common/v03}PriceElement" minOccurs="0"/>
 *         &lt;element name="Base" type="{http://services.sabre.com/merch/common/v03}PriceElement"/>
 *         &lt;element name="TotalBaseEquiv" type="{http://services.sabre.com/merch/common/v03}PriceElement" minOccurs="0"/>
 *         &lt;element name="TTL_Price" type="{http://services.sabre.com/merch/common/v03}PriceElement" minOccurs="0"/>
 *         &lt;element name="TotalTTL_Price" type="{http://services.sabre.com/merch/common/v03}PriceElement"/>
 *         &lt;element name="DisplayOnly" type="{http://www.w3.org/2001/XMLSchema}boolean" minOccurs="0"/>
 *       &lt;/sequence>
 *     &lt;/restriction>
 *   &lt;/complexContent>
 * &lt;/complexType>
 * </pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "AncillaryFee", propOrder = {
    "unavailable",
    "taxExemptIndicator",
    "taxExempt",
    "taxesIncludedInBase",
    "tax",
    "totalTaxes",
    "base",
    "totalBaseEquiv",
    "ttlPrice",
    "totalTTLPrice",
    "displayOnly"
})
public class AncillaryFee
    implements Serializable
{

    @XmlElement(name = "Unavailable")
    protected Boolean unavailable;
    @XmlElement(name = "TaxExemptIndicator")
    protected Boolean taxExemptIndicator;
    @XmlElement(name = "TaxExempt")
    protected PriceElement taxExempt;
    @XmlElement(name = "TaxesIncludedInBase")
    protected String taxesIncludedInBase;
    @XmlElement(name = "Tax")
    protected List<PriceElement> tax;
    @XmlElement(name = "TotalTaxes")
    protected PriceElement totalTaxes;
    @XmlElement(name = "Base", required = true)
    protected PriceElement base;
    @XmlElement(name = "TotalBaseEquiv")
    protected PriceElement totalBaseEquiv;
    @XmlElement(name = "TTL_Price")
    protected PriceElement ttlPrice;
    @XmlElement(name = "TotalTTL_Price", required = true)
    protected PriceElement totalTTLPrice;
    @XmlElement(name = "DisplayOnly")
    protected Boolean displayOnly;

    /**
     * Gets the value of the unavailable property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getUnavailable() {
        return unavailable;
    }

    /**
     * Sets the value of the unavailable property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setUnavailable(Boolean value) {
        this.unavailable = value;
    }

    /**
     * Gets the value of the taxExemptIndicator property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getTaxExemptIndicator() {
        return taxExemptIndicator;
    }

    /**
     * Sets the value of the taxExemptIndicator property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setTaxExemptIndicator(Boolean value) {
        this.taxExemptIndicator = value;
    }

    /**
     * Gets the value of the taxExempt property.
     * 
     * @return
     *     possible object is
     *     {@link PriceElement }
     *     
     */
    public PriceElement getTaxExempt() {
        return taxExempt;
    }

    /**
     * Sets the value of the taxExempt property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceElement }
     *     
     */
    public void setTaxExempt(PriceElement value) {
        this.taxExempt = value;
    }

    /**
     * Gets the value of the taxesIncludedInBase property.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getTaxesIncludedInBase() {
        return taxesIncludedInBase;
    }

    /**
     * Sets the value of the taxesIncludedInBase property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     */
    public void setTaxesIncludedInBase(String value) {
        this.taxesIncludedInBase = value;
    }

    /**
     * Gets the value of the tax property.
     * 
     * <p>
     * This accessor method returns a reference to the live list,
     * not a snapshot. Therefore any modification you make to the
     * returned list will be present inside the JAXB object.
     * This is why there is not a <CODE>set</CODE> method for the tax property.
     * 
     * <p>
     * For example, to add a new item, do as follows:
     * <pre>
     *    getTax().add(newItem);
     * </pre>
     * 
     * 
     * <p>
     * Objects of the following type(s) are allowed in the list
     * {@link PriceElement }
     * 
     * 
     */
    public List<PriceElement> getTax() {
        if (tax == null) {
            tax = new ArrayList<PriceElement>();
        }
        return this.tax;
    }

    /**
     * Gets the value of the totalTaxes property.
     * 
     * @return
     *     possible object is
     *     {@link PriceElement }
     *     
     */
    public PriceElement getTotalTaxes() {
        return totalTaxes;
    }

    /**
     * Sets the value of the totalTaxes property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceElement }
     *     
     */
    public void setTotalTaxes(PriceElement value) {
        this.totalTaxes = value;
    }

    /**
     * Gets the value of the base property.
     * 
     * @return
     *     possible object is
     *     {@link PriceElement }
     *     
     */
    public PriceElement getBase() {
        return base;
    }

    /**
     * Sets the value of the base property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceElement }
     *     
     */
    public void setBase(PriceElement value) {
        this.base = value;
    }

    /**
     * Gets the value of the totalBaseEquiv property.
     * 
     * @return
     *     possible object is
     *     {@link PriceElement }
     *     
     */
    public PriceElement getTotalBaseEquiv() {
        return totalBaseEquiv;
    }

    /**
     * Sets the value of the totalBaseEquiv property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceElement }
     *     
     */
    public void setTotalBaseEquiv(PriceElement value) {
        this.totalBaseEquiv = value;
    }

    /**
     * Gets the value of the ttlPrice property.
     * 
     * @return
     *     possible object is
     *     {@link PriceElement }
     *     
     */
    public PriceElement getTTLPrice() {
        return ttlPrice;
    }

    /**
     * Sets the value of the ttlPrice property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceElement }
     *     
     */
    public void setTTLPrice(PriceElement value) {
        this.ttlPrice = value;
    }

    /**
     * Gets the value of the totalTTLPrice property.
     * 
     * @return
     *     possible object is
     *     {@link PriceElement }
     *     
     */
    public PriceElement getTotalTTLPrice() {
        return totalTTLPrice;
    }

    /**
     * Sets the value of the totalTTLPrice property.
     * 
     * @param value
     *     allowed object is
     *     {@link PriceElement }
     *     
     */
    public void setTotalTTLPrice(PriceElement value) {
        this.totalTTLPrice = value;
    }

    /**
     * Gets the value of the displayOnly property.
     * 
     * @return
     *     possible object is
     *     {@link Boolean }
     *     
     */
    public Boolean getDisplayOnly() {
        return displayOnly;
    }

    /**
     * Sets the value of the displayOnly property.
     * 
     * @param value
     *     allowed object is
     *     {@link Boolean }
     *     
     */
    public void setDisplayOnly(Boolean value) {
        this.displayOnly = value;
    }

}
