
package com.sabre.services.merch.products.v03;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>Java class for Enum_ElectronicMiscDocType.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="Enum_ElectronicMiscDocType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="STANDALONE"/>
 *     &lt;enumeration value="FLIGHT_COUPON_ASSOCIATED"/>
 *     &lt;enumeration value="STANDALONE_TICKET_ASSOCIATED"/>
 *     &lt;enumeration value="OTHER_THAN_EMD"/>
 *     &lt;enumeration value="ETICKET"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "Enum_ElectronicMiscDocType")
@XmlEnum
public enum EnumElectronicMiscDocType {


    /**
     * 
     *                         Maps to value 1 of EMD Type field in S5 record specification. Standalone.
     *                         The EMD must be a standalone EMD (not issued in conjunction with a passenger ticket).
     *                     
     * 
     */
    STANDALONE,

    /**
     * 
     *                         Maps to value 2 of EMD Type field in S5 record specification.
     *                         Associated to a flight coupon of a ticket.
     *                     
     * 
     */
    FLIGHT_COUPON_ASSOCIATED,

    /**
     * 
     *                         Maps to value 3 of EMD Type field in S5 record specification.
     *                         Standalone referenced to a ticket number but not associated to a flight coupon of a ticket.
     *                     
     * 
     */
    STANDALONE_TICKET_ASSOCIATED,

    /**
     * 
     *                         Maps to value 4 of EMD Type field in S5 record specification. Other than EMD.
     *                         The subscriber must have received instructions from the S5 record owning carrier
     *                         regarding how to document the service.
     *                     
     * 
     */
    OTHER_THAN_EMD,

    /**
     * 
     *                         Maps to value 5 of EMD Type field in S5 record specification. Electronic ticket.
     *                     
     * 
     */
    ETICKET;

    public String value() {
        return name();
    }

    public static EnumElectronicMiscDocType fromValue(String v) {
        return valueOf(v);
    }

}
