/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.core;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.bof.midoffice.ibus.MaskSensitiveTraceDataHelper;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.gds.sabre.core.SabreSession;
import com.gridnine.xtrip.common.gds.sabre.core.helper.CoreSabreHelper;
import com.gridnine.xtrip.common.gds.sabre.core.model.ISabreGdsAccount;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.gds.sabre.core.IbusGdsSabreCoreContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.jibxws.ContentEncoding;
import com.gridnine.xtrip.server.jibxws.IBusJibxWsContextKeys;
import com.gridnine.xtrip.server.jibxws.WsRequest;
import java.util.Date;
import java.util.EnumSet;
import java.util.Map;
import java.util.UUID;
import org.ebxml.namespaces.messageheader.Action;
import org.ebxml.namespaces.messageheader.CPAId;
import org.ebxml.namespaces.messageheader.ConversationId;
import org.ebxml.namespaces.messageheader.From;
import org.ebxml.namespaces.messageheader.HeaderExtensionGrp;
import org.ebxml.namespaces.messageheader.MessageData;
import org.ebxml.namespaces.messageheader.MessageHeader;
import org.ebxml.namespaces.messageheader.MessageId;
import org.ebxml.namespaces.messageheader.PartyId;
import org.ebxml.namespaces.messageheader.Service;
import org.ebxml.namespaces.messageheader.Timestamp;
import org.ebxml.namespaces.messageheader.To;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.xmlsoap.schemas.ws.secext.Security;

public class SabreWsRequestBuilder
extends BaseProcessor {
    private boolean reportOldUrlCalls;
    private static final String MESSAGE_HEADER_VERSION = "2.0";
    private static final String PARTY_ID_TYPE = "urn:x12.org:IO5:01";
    private static final String PARTY_ID_FROM = Environment.getApplicationId() + ".gridnine.com";
    private static final String PARTY_ID_TO = "webservices.sabre.com";
    private static final String SERVICE_TYPE = "sabreXML";
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");
    private static final String USERNAME_TOKEN_DOMAIN = "DEFAULT";

    public void configure(Map<String, String> parameters) {
        this.reportOldUrlCalls = Boolean.parseBoolean(System.getProperty("com.gridnine.xtrip.server.gds.sabre.core.SabreWsRequestBuilder.reportOldUrlCalls"));
    }

    public void process(MessageContext ctx) {
        EntityContainer accountCtr = (EntityContainer)ctx.getObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        if (accountCtr != null && ((ISabreGdsAccount)accountCtr.getEntity()).isDisabled()) {
            throw Xeption.forAdmin((String)"\u0410\u043a\u043a\u0430\u0443\u043d\u0442 \u0441\u0438\u0441\u0442\u0435\u043c\u044b \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f \u0437\u0430\u0431\u043b\u043e\u043a\u0438\u0440\u043e\u0432\u0430\u043d", (Object[])new Object[0]);
        }
        WsRequest request = new WsRequest();
        MessageHeader messageHeader = this.createMessageHeader(ctx);
        request.getHeaders().add(messageHeader);
        request.getHeaders().add(this.createSecurityHeader(ctx));
        request.setAcceptEncoding(EnumSet.allOf(ContentEncoding.class));
        request.setPayload(ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD));
        request.setEndpointAddress(SabreWsRequestBuilder.getEndpointAddress(ctx));
        if (this.reportOldUrlCalls && request.getEndpointAddress() != null && !request.getEndpointAddress().contains(".platform.")) {
            IncidentsLog.reportStackTrace((String)"old sabre url called: ".concat(request.getEndpointAddress()));
        }
        ctx.putObject((Enum)IBusJibxWsContextKeys.WS_REQUEST, (Object)request);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_REQUEST_PAYLOAD, null);
        CoreSabreHelper.SESSIONS_LOG.debug(String.format("%s %s", messageHeader.getConversationId().getConversationId(), MiscUtil.getSimpleClassName(request.getPayload().getClass())));
    }

    private MessageHeader createMessageHeader(MessageContext ctx) {
        String ipcc;
        String conversationId;
        SabreSession session = (SabreSession)ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
        String actionCode = (String)ctx.getMandatoryObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE);
        ctx.putObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_WS_SERVICE_ACTION_CODE, null);
        if (session != null) {
            conversationId = session.getConversationId();
            ipcc = session.getIpcc();
            session.setLastModified(new Date());
        } else {
            conversationId = String.format("%s@%s", UUID.randomUUID(), PARTY_ID_FROM);
            EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
            ipcc = ((ISabreGdsAccount)accountCtr.getEntity()).getPrimaryPCC();
        }
        MessageHeader messageHeader = new MessageHeader();
        HeaderExtensionGrp grp = new HeaderExtensionGrp();
        grp.setVersion(MESSAGE_HEADER_VERSION);
        HeaderExtensionGrp.MustUnderstand mu = new HeaderExtensionGrp.MustUnderstand();
        mu.setMustUnderstand(true);
        grp.setMustUnderstand(mu);
        messageHeader.setHeaderExtensionGrp(grp);
        ConversationId id = new ConversationId();
        id.setConversationId(conversationId);
        messageHeader.setConversationId(id);
        From from = new From();
        PartyId partyId = new PartyId();
        partyId.setType(PARTY_ID_TYPE);
        partyId.setString(PARTY_ID_FROM);
        from.getPartyIdList().add(partyId);
        messageHeader.setFrom(from);
        To to = new To();
        PartyId toPartyId = new PartyId();
        toPartyId.setType(PARTY_ID_TYPE);
        toPartyId.setString(PARTY_ID_TO);
        to.getPartyIdList().add(toPartyId);
        messageHeader.setTo(to);
        id = new CPAId();
        id.setCPAId1(ipcc);
        messageHeader.setCPAId((CPAId)id);
        Service service = new Service();
        service.setType(SERVICE_TYPE);
        if (!"PassengerDetailsRQ".equals(actionCode)) {
            service.setString(actionCode);
        } else {
            service.setString("");
        }
        messageHeader.setService(service);
        Action action = new Action();
        action.setAction(actionCode);
        messageHeader.setAction(action);
        long timestamp = MiscUtil.getTimestamp();
        String mid = String.format("mid:%s@%s", UUID.randomUUID(), PARTY_ID_FROM);
        MessageData messageData = new MessageData();
        MessageId id2 = new MessageId();
        id2.setMessageId(mid);
        messageData.setMessageId(id2);
        Timestamp ts = new Timestamp();
        ts.setTimestamp(String.format("%sZ", TIMESTAMP_FORMATTER.print(timestamp)));
        messageData.setTimestamp(ts);
        messageHeader.setMessageData(messageData);
        this.log.debug(String.format("conversationId=%s, actionCode=%s, mid=%s, tid=%s", conversationId, actionCode, mid, Thread.currentThread().getId()));
        return messageHeader;
    }

    private Security createSecurityHeader(MessageContext ctx) {
        Security securityHeader = new Security();
        SabreSession session = (SabreSession)ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
        if (session != null) {
            SabreWsRequestBuilder.fillSecurityHeader(securityHeader, session);
        } else {
            EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
            SabreWsRequestBuilder.fillSecurityHeader(ctx, securityHeader, (ISabreGdsAccount)accountCtr.getEntity());
        }
        return securityHeader;
    }

    private static void fillSecurityHeader(Security securityHeader, SabreSession session) {
        securityHeader.setBinarySecurityToken(session.getBinarySecurityToken());
    }

    private static void fillSecurityHeader(MessageContext ctx, Security securityHeader, ISabreGdsAccount account) {
        Security.UsernameToken usernameToken = new Security.UsernameToken();
        usernameToken.setUsername(account.getAccount());
        usernameToken.setPassword(account.getPassword());
        MaskSensitiveTraceDataHelper.addMaskedValue((MessageContext)ctx, (String)account.getPassword());
        usernameToken.setOrganization(account.getPrimaryPCC());
        usernameToken.setDomain(USERNAME_TOKEN_DOMAIN);
        securityHeader.setUsernameToken(usernameToken);
    }

    private static String getEndpointAddress(MessageContext ctx) {
        SabreSession session = (SabreSession)ctx.getObject((Enum)IbusGdsSabreCoreContextKeys.SABRE_SESSION);
        if (session != null) {
            return session.getEndpointUrl();
        }
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        return ((ISabreGdsAccount)accountCtr.getEntity()).getAddress();
    }
}

