/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.gds.sabre.core;

import com.gridnine.xtrip.common.gds.l10n.Messages;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import org.apache.commons.lang.StringUtils;
import org.jibx.ws.soap.SoapFaultException;

public class SoapFaultTranslatorAdvice
extends BaseAdvice {
    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        if (e instanceof SoapFaultException && !StringUtils.isBlank((String)e.getMessage())) {
            if (e.getMessage().startsWith("Unable to connect to ICE security system")) {
                throw new Xeption(L10nResourcesManager.createL10nMessage((String)"AIRLINE_DISCONNECT_NEED_NEW_BOOKING_REQUEST", (Object[])new Object[0]), null, "Unable to connect to ICE security system", e);
            }
            if (e.getMessage().equals("Service provider invocation timed out")) {
                throw new Xeption(L10nResourcesManager.createL10nMessage((String)Messages.DISCONNECTING_THE_BOOKING_SYSTEM, (Object[])new Object[0]), null, "Service provider invocation timed out", e);
            }
            if (e.getMessage().equals("Unable to internalize message")) {
                throw new Xeption(L10nResourcesManager.createL10nMessage((String)"NO_REPLY_FROM_SERVER", (Object[])new Object[0]), null, "Unable to internalize message", e);
            }
            if (e.getMessage().equals("System is currently unavailable. Please try again later.")) {
                throw new Xeption(L10nResourcesManager.createL10nMessage((String)"GDS_SABRE_EXCEPTION_THE_SYSTEM_IS_CURRENTLY_UNAVAILABLE_REPEAT_QUERY_AFTER_A_FEW_MINUTES", (Object[])new Object[0]), null, "System is currently unavailable. Please try again later.", e);
            }
            if (e.getMessage().equals("Service provider responded with invalid response")) {
                throw new Xeption(L10nResourcesManager.createL10nMessage((String)"NO_REPLY_FROM_SERVER", (Object[])new Object[0]), null, "Service provider responded with invalid response", e);
            }
            if (e.getMessage().equals("Authentication failed")) {
                throw new Xeption(L10nResourcesManager.createL10nMessage((String)"WRONG_LOGIN_PASSWORD", (Object[])new Object[0]), null, "Authentication failed", e);
            }
            if (e.getMessage().equals("Service provider invocation failure")) {
                throw new Xeption(L10nResourcesManager.createL10nMessage((String)"NO_REPLY_FROM_SERVER", (Object[])new Object[0]), null, "Service provider invocation failure", e);
            }
            if (e.getMessage().equals("System is unable to connect to messaging system")) {
                throw new Xeption(L10nResourcesManager.createL10nMessage((String)Messages.DISCONNECTING_THE_BOOKING_SYSTEM, (Object[])new Object[0]), null, "System is unable to connect to messaging system", e);
            }
            if (e.getMessage().contains("Unable to perform context change")) {
                throw Xeption.forEndUser((String)"\u0420\u0430\u0437\u0440\u044b\u0432 \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0441 \u0441\u0438\u0441\u0442\u0435\u043c\u043e\u0439 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f. \u0415\u0441\u043b\u0438 \u0412\u044b \u043f\u044b\u0442\u0430\u043b\u0438\u0441\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u0442\u044c \u0431\u0438\u043b\u0435\u0442 \u0438\u043b\u0438 \u0430\u043d\u043d\u0443\u043b\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u0437\u0430\u043a\u0430\u0437, \u0442\u043e \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u043e\u0431\u0440\u0430\u0442\u0438\u0442\u044c\u0441\u044f \u0432 \u043a\u043e\u043b\u043b-\u0446\u0435\u043d\u0442\u0440 \u0434\u043b\u044f \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 \u0431\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u044f", (Object[])new Object[0]);
            }
        }
        return super.handleException(e, ctx);
    }
}

