
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Identifies the action code for a booking - OK, Waitlist etc.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ActionCodeType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="OK"/>
 *     &lt;xs:enumeration value="Waitlist"/>
 *     &lt;xs:enumeration value="Other"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum ActionCodeType implements Serializable {
    OK("OK"), WAITLIST("Waitlist"), OTHER("Other");
    private final String value;

    private ActionCodeType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static ActionCodeType convert(String value) {
        for (ActionCodeType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
