
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AddressType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:StreetNmbrType" name="StreetNmbr" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="BldgRoom" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="AddressLine" minOccurs="0" maxOccurs="5"/>
 *     &lt;xs:element type="xs:string" name="CityName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="PostalCode" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="County" minOccurs="0"/>
 *     &lt;xs:element type="ns:StateProvType" name="StateProv" minOccurs="0"/>
 *     &lt;xs:element type="ns:CountryNameType" name="CountryName" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:FormattedInd"/>
 *   &lt;xs:attributeGroup ref="ns:PrivacyGroup"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="Type"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FormattedInd">
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="FormattedInd"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AddressType implements Serializable
{
    private StreetNmbrType streetNmbr;
    private String bldgRoom;
    private List<String> addressLineList = new ArrayList<String>();
    private String cityName;
    private String postalCode;
    private String county;
    private StateProvType stateProv;
    private CountryNameType countryName;
    private Boolean formattedInd;
    private PrivacyGroup privacyGroup;
    private String type;

    /** 
     * Get the 'StreetNmbr' element value. Street Name and Number within the address
     * 
     * @return value
     */
    public StreetNmbrType getStreetNmbr() {
        return streetNmbr;
    }

    /** 
     * Set the 'StreetNmbr' element value. Street Name and Number within the address
     * 
     * @param streetNmbr
     */
    public void setStreetNmbr(StreetNmbrType streetNmbr) {
        this.streetNmbr = streetNmbr;
    }

    /** 
     * Get the 'BldgRoom' element value. Building name, room, apartment, or suite number.
     * 
     * @return value
     */
    public String getBldgRoom() {
        return bldgRoom;
    }

    /** 
     * Set the 'BldgRoom' element value. Building name, room, apartment, or suite number.
     * 
     * @param bldgRoom
     */
    public void setBldgRoom(String bldgRoom) {
        this.bldgRoom = bldgRoom;
    }

    /** 
     * Get the list of 'AddressLine' element items.
     * 
     * @return list
     */
    public List<String> getAddressLineList() {
        return addressLineList;
    }

    /** 
     * Set the list of 'AddressLine' element items.
     * 
     * @param list
     */
    public void setAddressLineList(List<String> list) {
        addressLineList = list;
    }

    /** 
     * Get the 'CityName' element value. City name eg. Dublin
     * 
     * @return value
     */
    public String getCityName() {
        return cityName;
    }

    /** 
     * Set the 'CityName' element value. City name eg. Dublin
     * 
     * @param cityName
     */
    public void setCityName(String cityName) {
        this.cityName = cityName;
    }

    /** 
     * Get the 'PostalCode' element value. Post Office Code number.
     * 
     * @return value
     */
    public String getPostalCode() {
        return postalCode;
    }

    /** 
     * Set the 'PostalCode' element value. Post Office Code number.
     * 
     * @param postalCode
     */
    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    /** 
     * Get the 'County' element value. County Name eg. Fairfax
     * 
     * @return value
     */
    public String getCounty() {
        return county;
    }

    /** 
     * Set the 'County' element value. County Name eg. Fairfax
     * 
     * @param county
     */
    public void setCounty(String county) {
        this.county = county;
    }

    /** 
     * Get the 'StateProv' element value. State name eg. Texas
     * 
     * @return value
     */
    public StateProvType getStateProv() {
        return stateProv;
    }

    /** 
     * Set the 'StateProv' element value. State name eg. Texas
     * 
     * @param stateProv
     */
    public void setStateProv(StateProvType stateProv) {
        this.stateProv = stateProv;
    }

    /** 
     * Get the 'CountryName' element value. Country name eg. Ireland
     * 
     * @return value
     */
    public CountryNameType getCountryName() {
        return countryName;
    }

    /** 
     * Set the 'CountryName' element value. Country name eg. Ireland
     * 
     * @param countryName
     */
    public void setCountryName(CountryNameType countryName) {
        this.countryName = countryName;
    }

    /** 
     * Get the 'FormattedInd' attribute value. Specifies if the associated data is formatted or not. If true, then it is formatted, if false, then not formatted.
     * 
     * @return value
     */
    public Boolean getFormattedInd() {
        return formattedInd;
    }

    /** 
     * Set the 'FormattedInd' attribute value. Specifies if the associated data is formatted or not. If true, then it is formatted, if false, then not formatted.
     * 
     * @param formattedInd
     */
    public void setFormattedInd(Boolean formattedInd) {
        this.formattedInd = formattedInd;
    }

    /** 
     * Get the 'PrivacyGroup' attributeGroup value.
     * 
     * @return value
     */
    public PrivacyGroup getPrivacyGroup() {
        return privacyGroup;
    }

    /** 
     * Set the 'PrivacyGroup' attributeGroup value.
     * 
     * @param privacyGroup
     */
    public void setPrivacyGroup(PrivacyGroup privacyGroup) {
        this.privacyGroup = privacyGroup;
    }

    /** 
     * Get the 'Type' attribute value. Defines the type of address (e.g. home, business, other). Refer to OTA Code List Communication Location Type (CLT).
     * 
     * @return value
     */
    public String getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value. Defines the type of address (e.g. home, business, other). Refer to OTA Code List Communication Location Type (CLT).
     * 
     * @param type
     */
    public void setType(String type) {
        this.type = type;
    }
}
