
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

/** 
 * Defines user preferences to be used in conducting a search.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirSearchPrefsType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:CompanyNamePrefType" name="VendorPref" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:VendorPrefApplicabilityType" name="VendorPrefApplicability" minOccurs="0" maxOccurs="2"/>
 *     &lt;xs:element type="ns:VendorPrefPairingType" name="VendorPrefPairing" minOccurs="0" maxOccurs="unbounded"/>
 *     &lt;xs:element type="ns:FlightTypePrefType" name="FlightTypePref" minOccurs="0"/>
 *     &lt;xs:element name="FareRestrictPref" minOccurs="0" maxOccurs="4">
 *       &lt;!-- Reference to inner class FareRestrictPref -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:EquipmentTypePref" name="EquipPref" minOccurs="0" maxOccurs="9"/>
 *     &lt;xs:element type="ns:CabinPrefType" name="CabinPref" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element type="ns:TicketDistribPrefType" name="TicketDistribPref" minOccurs="0" maxOccurs="3"/>
 *     &lt;xs:element name="TPA_Extensions" minOccurs="0">
 *       &lt;!-- Reference to inner class TPAExtensions -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="AncillaryFees" minOccurs="0">
 *       &lt;!-- Reference to inner class AncillaryFees -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="FrequentFlyer" minOccurs="0" maxOccurs="unbounded">
 *       &lt;!-- Reference to inner class FrequentFlyer -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="SpanishFamilyDiscount" minOccurs="0">
 *       &lt;!-- Reference to inner class SpanishFamilyDiscount -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="Baggage" minOccurs="0">
 *       &lt;!-- Reference to inner class Baggage -->
 *     &lt;/xs:element>
 *     &lt;xs:element type="ns:InterlineBrandsType" name="InterlineBrands" minOccurs="0"/>
 *     &lt;xs:element name="CommissionCodeQualifiers" minOccurs="0">
 *       &lt;!-- Reference to inner class CommissionCodeQualifiers -->
 *     &lt;/xs:element>
 *     &lt;xs:element name="BuyerInformation" minOccurs="0" maxOccurs="1">
 *       &lt;!-- Reference to inner class BuyerInformation -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:SmokingIndicatorGroup"/>
 *   &lt;xs:attribute type="xs:decimal" use="optional" name="OnTimeRate"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="ETicketDesired"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="ValidInterlineTicket"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="MaxStopsQuantity"/>
 *   &lt;xs:attribute use="optional" default="None" name="UseAllFlights">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class UseAllFlights -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="AllFlightsData"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="true" name="Hybrid"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="true" name="LookForAlternatives"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SmokingIndicatorGroup">
 *   &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="SmokingAllowed"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class AirSearchPrefsType implements Serializable
{
    private List<CompanyNamePrefType> vendorPrefList = new ArrayList<CompanyNamePrefType>();
    private List<VendorPrefApplicabilityType> vendorPrefApplicabilityList = new ArrayList<VendorPrefApplicabilityType>();
    private List<VendorPrefPairingType> vendorPrefPairingList = new ArrayList<VendorPrefPairingType>();
    private FlightTypePrefType flightTypePref;
    private List<FareRestrictPref> fareRestrictPrefList = new ArrayList<FareRestrictPref>();
    private List<EquipmentTypePref> equipPrefList = new ArrayList<EquipmentTypePref>();
    private List<CabinPrefType> cabinPrefList = new ArrayList<CabinPrefType>();
    private List<TicketDistribPrefType> ticketDistribPrefList = new ArrayList<TicketDistribPrefType>();
    private TPAExtensions TPAExtensions1;
    private AncillaryFees ancillaryFees;
    private List<FrequentFlyer> frequentFlyerList = new ArrayList<FrequentFlyer>();
    private SpanishFamilyDiscount spanishFamilyDiscount;
    private Baggage baggage;
    private InterlineBrandsType interlineBrands;
    private CommissionCodeQualifiers commissionCodeQualifiers;
    private BuyerInformation buyerInformation;
    private Boolean smokingAllowed;
    private BigDecimal onTimeRate;
    private Boolean ETicketDesired;
    private Boolean validInterlineTicket;
    private BigInteger maxStopsQuantity;
    private UseAllFlights useAllFlights;
    private Boolean allFlightsData;
    private Boolean hybrid;
    private Boolean lookForAlternatives;

    /** 
     * Get the list of 'VendorPref' element items. Specify vendors to include and exclude from the response.
     * 
     * @return list
     */
    public List<CompanyNamePrefType> getVendorPrefList() {
        return vendorPrefList;
    }

    /** 
     * Set the list of 'VendorPref' element items. Specify vendors to include and exclude from the response.
     * 
     * @param list
     */
    public void setVendorPrefList(List<CompanyNamePrefType> list) {
        vendorPrefList = list;
    }

    /** 
     * Get the list of 'VendorPrefApplicability' element items. Specifies if online or interline carrier selection logic should be applied for provided carrier type. One instance per carrier type.
     * 
     * @return list
     */
    public List<VendorPrefApplicabilityType> getVendorPrefApplicabilityList() {
        return vendorPrefApplicabilityList;
    }

    /** 
     * Set the list of 'VendorPrefApplicability' element items. Specifies if online or interline carrier selection logic should be applied for provided carrier type. One instance per carrier type.
     * 
     * @param list
     */
    public void setVendorPrefApplicabilityList(
            List<VendorPrefApplicabilityType> list) {
        vendorPrefApplicabilityList = list;
    }

    /** 
     * Get the list of 'VendorPrefPairing' element items. Specifies which marketing and operating carrier pairs are preferred or unacceptable.
     * 
     * @return list
     */
    public List<VendorPrefPairingType> getVendorPrefPairingList() {
        return vendorPrefPairingList;
    }

    /** 
     * Set the list of 'VendorPrefPairing' element items. Specifies which marketing and operating carrier pairs are preferred or unacceptable.
     * 
     * @param list
     */
    public void setVendorPrefPairingList(List<VendorPrefPairingType> list) {
        vendorPrefPairingList = list;
    }

    /** 
     * Get the 'FlightTypePref' element value. Defines preferred flight characteristics to be used in a search.
     * 
     * @return value
     */
    public FlightTypePrefType getFlightTypePref() {
        return flightTypePref;
    }

    /** 
     * Set the 'FlightTypePref' element value. Defines preferred flight characteristics to be used in a search.
     * 
     * @param flightTypePref
     */
    public void setFlightTypePref(FlightTypePrefType flightTypePref) {
        this.flightTypePref = flightTypePref;
    }

    /** 
     * Get the list of 'FareRestrictPref' element items.
     * 
     * @return list
     */
    public List<FareRestrictPref> getFareRestrictPrefList() {
        return fareRestrictPrefList;
    }

    /** 
     * Set the list of 'FareRestrictPref' element items.
     * 
     * @param list
     */
    public void setFareRestrictPrefList(List<FareRestrictPref> list) {
        fareRestrictPrefList = list;
    }

    /** 
     * Get the list of 'EquipPref' element items. Defines preferred equipment profile(s) to be used in a search.
     * 
     * @return list
     */
    public List<EquipmentTypePref> getEquipPrefList() {
        return equipPrefList;
    }

    /** 
     * Set the list of 'EquipPref' element items. Defines preferred equipment profile(s) to be used in a search.
     * 
     * @param list
     */
    public void setEquipPrefList(List<EquipmentTypePref> list) {
        equipPrefList = list;
    }

    /** 
     * Get the list of 'CabinPref' element items. Defines preferred cabin(s) to be used in a search. The Cabin type specified in a OriginDestinationInformation/TPA_Extensions overrides this Cabin type for that specific segment/leg. If a Cabin type is not specified in a OriginDestinationInformation/TPA_Extensions the cabin type in this element will be used as default cabin type for that segment/leg.
     * 
     * @return list
     */
    public List<CabinPrefType> getCabinPrefList() {
        return cabinPrefList;
    }

    /** 
     * Set the list of 'CabinPref' element items. Defines preferred cabin(s) to be used in a search. The Cabin type specified in a OriginDestinationInformation/TPA_Extensions overrides this Cabin type for that specific segment/leg. If a Cabin type is not specified in a OriginDestinationInformation/TPA_Extensions the cabin type in this element will be used as default cabin type for that segment/leg.
     * 
     * @param list
     */
    public void setCabinPrefList(List<CabinPrefType> list) {
        cabinPrefList = list;
    }

    /** 
     * Get the list of 'TicketDistribPref' element items. Defines Distribution prefernces.
     * 
     * @return list
     */
    public List<TicketDistribPrefType> getTicketDistribPrefList() {
        return ticketDistribPrefList;
    }

    /** 
     * Set the list of 'TicketDistribPref' element items. Defines Distribution prefernces.
     * 
     * @param list
     */
    public void setTicketDistribPrefList(List<TicketDistribPrefType> list) {
        ticketDistribPrefList = list;
    }

    /** 
     * Get the 'TPA_Extensions' element value.
     * 
     * @return value
     */
    public TPAExtensions getTPAExtensions1() {
        return TPAExtensions1;
    }

    /** 
     * Set the 'TPA_Extensions' element value.
     * 
     * @param TPAExtensions1
     */
    public void setTPAExtensions1(TPAExtensions TPAExtensions1) {
        this.TPAExtensions1 = TPAExtensions1;
    }

    /** 
     * Get the 'AncillaryFees' element value.
     * 
     * @return value
     */
    public AncillaryFees getAncillaryFees() {
        return ancillaryFees;
    }

    /** 
     * Set the 'AncillaryFees' element value.
     * 
     * @param ancillaryFees
     */
    public void setAncillaryFees(AncillaryFees ancillaryFees) {
        this.ancillaryFees = ancillaryFees;
    }

    /** 
     * Get the list of 'FrequentFlyer' element items.
     * 
     * @return list
     */
    public List<FrequentFlyer> getFrequentFlyerList() {
        return frequentFlyerList;
    }

    /** 
     * Set the list of 'FrequentFlyer' element items.
     * 
     * @param list
     */
    public void setFrequentFlyerList(List<FrequentFlyer> list) {
        frequentFlyerList = list;
    }

    /** 
     * Get the 'SpanishFamilyDiscount' element value.
     * 
     * @return value
     */
    public SpanishFamilyDiscount getSpanishFamilyDiscount() {
        return spanishFamilyDiscount;
    }

    /** 
     * Set the 'SpanishFamilyDiscount' element value.
     * 
     * @param spanishFamilyDiscount
     */
    public void setSpanishFamilyDiscount(
            SpanishFamilyDiscount spanishFamilyDiscount) {
        this.spanishFamilyDiscount = spanishFamilyDiscount;
    }

    /** 
     * Get the 'Baggage' element value.
     * 
     * @return value
     */
    public Baggage getBaggage() {
        return baggage;
    }

    /** 
     * Set the 'Baggage' element value.
     * 
     * @param baggage
     */
    public void setBaggage(Baggage baggage) {
        this.baggage = baggage;
    }

    /** 
     * Get the 'InterlineBrands' element value.
     * 
     * @return value
     */
    public InterlineBrandsType getInterlineBrands() {
        return interlineBrands;
    }

    /** 
     * Set the 'InterlineBrands' element value.
     * 
     * @param interlineBrands
     */
    public void setInterlineBrands(InterlineBrandsType interlineBrands) {
        this.interlineBrands = interlineBrands;
    }

    /** 
     * Get the 'CommissionCodeQualifiers' element value.
     * 
     * @return value
     */
    public CommissionCodeQualifiers getCommissionCodeQualifiers() {
        return commissionCodeQualifiers;
    }

    /** 
     * Set the 'CommissionCodeQualifiers' element value.
     * 
     * @param commissionCodeQualifiers
     */
    public void setCommissionCodeQualifiers(
            CommissionCodeQualifiers commissionCodeQualifiers) {
        this.commissionCodeQualifiers = commissionCodeQualifiers;
    }

    /** 
     * Get the 'BuyerInformation' element value.
     * 
     * @return value
     */
    public BuyerInformation getBuyerInformation() {
        return buyerInformation;
    }

    /** 
     * Set the 'BuyerInformation' element value.
     * 
     * @param buyerInformation
     */
    public void setBuyerInformation(BuyerInformation buyerInformation) {
        this.buyerInformation = buyerInformation;
    }

    /** 
     * Get the 'SmokingAllowed' attribute value. Identifies a position with regard to the smoking of cigarettes, either Allowed or NotAllowed. This may be of use when expressing a preference (I prefer a room that allows smoking) or when stating the attributes of an item (smoking in this rental car is not allowed).
     * 
     * @return value
     */
    public Boolean getSmokingAllowed() {
        return smokingAllowed;
    }

    /** 
     * Set the 'SmokingAllowed' attribute value. Identifies a position with regard to the smoking of cigarettes, either Allowed or NotAllowed. This may be of use when expressing a preference (I prefer a room that allows smoking) or when stating the attributes of an item (smoking in this rental car is not allowed).
     * 
     * @param smokingAllowed
     */
    public void setSmokingAllowed(Boolean smokingAllowed) {
        this.smokingAllowed = smokingAllowed;
    }

    /** 
     * Get the 'OnTimeRate' attribute value. Request for flights in response that meet the given Department of Transport on-time rate. This is a number between 0 and 100.
     * 
     * @return value
     */
    public BigDecimal getOnTimeRate() {
        return onTimeRate;
    }

    /** 
     * Set the 'OnTimeRate' attribute value. Request for flights in response that meet the given Department of Transport on-time rate. This is a number between 0 and 100.
     * 
     * @param onTimeRate
     */
    public void setOnTimeRate(BigDecimal onTimeRate) {
        this.onTimeRate = onTimeRate;
    }

    /** 
     * Get the 'ETicketDesired' attribute value. Request flights that are e-ticketable in the response.
     * 
     * @return value
     */
    public Boolean getETicketDesired() {
        return ETicketDesired;
    }

    /** 
     * Set the 'ETicketDesired' attribute value. Request flights that are e-ticketable in the response.
     * 
     * @param ETicketDesired
     */
    public void setETicketDesired(Boolean ETicketDesired) {
        this.ETicketDesired = ETicketDesired;
    }

    /** 
     * Get the 'ValidInterlineTicket' attribute value. Request options that are validated on base of interline ticketing aggrement.
     * 
     * @return value
     */
    public Boolean getValidInterlineTicket() {
        return validInterlineTicket;
    }

    /** 
     * Set the 'ValidInterlineTicket' attribute value. Request options that are validated on base of interline ticketing aggrement.
     * 
     * @param validInterlineTicket
     */
    public void setValidInterlineTicket(Boolean validInterlineTicket) {
        this.validInterlineTicket = validInterlineTicket;
    }

    /** 
     * Get the 'MaxStopsQuantity' attribute value. Request flights that have no more than the requested number of stops.
     * 
     * @return value
     */
    public BigInteger getMaxStopsQuantity() {
        return maxStopsQuantity;
    }

    /** 
     * Set the 'MaxStopsQuantity' attribute value. Request flights that have no more than the requested number of stops.
     * 
     * @param maxStopsQuantity
     */
    public void setMaxStopsQuantity(BigInteger maxStopsQuantity) {
        this.maxStopsQuantity = maxStopsQuantity;
    }

    /** 
     * Get the 'UseAllFlights' attribute value. Define on which legs each flight should appear at least once.
     * 
     * @return value
     */
    public UseAllFlights getUseAllFlights() {
        return useAllFlights;
    }

    /** 
     * Set the 'UseAllFlights' attribute value. Define on which legs each flight should appear at least once.
     * 
     * @param useAllFlights
     */
    public void setUseAllFlights(UseAllFlights useAllFlights) {
        this.useAllFlights = useAllFlights;
    }

    /** 
     * Get the 'AllFlightsData' attribute value. Return flights not combinable into roundtrips as one ways is a separate section.
     * 
     * @return value
     */
    public Boolean getAllFlightsData() {
        return allFlightsData;
    }

    /** 
     * Set the 'AllFlightsData' attribute value. Return flights not combinable into roundtrips as one ways is a separate section.
     * 
     * @param allFlightsData
     */
    public void setAllFlightsData(Boolean allFlightsData) {
        this.allFlightsData = allFlightsData;
    }

    /** 
     * Get the 'Hybrid' attribute value. If false no solutions priced outside of ATSE systems will be returned in response for carriers operating in hybrid content distribution model.
     * 
     * @return value
     */
    public Boolean getHybrid() {
        return hybrid;
    }

    /** 
     * Set the 'Hybrid' attribute value. If false no solutions priced outside of ATSE systems will be returned in response for carriers operating in hybrid content distribution model.
     * 
     * @param hybrid
     */
    public void setHybrid(Boolean hybrid) {
        this.hybrid = hybrid;
    }

    /** 
     * Get the 'LookForAlternatives' attribute value. If false no alternative solutions will be returned in response
     * 
     * @return value
     */
    public Boolean getLookForAlternatives() {
        return lookForAlternatives;
    }

    /** 
     * Set the 'LookForAlternatives' attribute value. If false no alternative solutions will be returned in response
     * 
     * @param lookForAlternatives
     */
    public void setLookForAlternatives(Boolean lookForAlternatives) {
        this.lookForAlternatives = lookForAlternatives;
    }
    /** 
     * Constrains a fare search to those with restrictions that satisfy user-imposed limitations.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareRestrictPref" minOccurs="0" maxOccurs="4">
     *   &lt;xs:complexType>
     *     &lt;xs:complexContent>
     *       &lt;xs:extension base="ns:FareRestrictPrefType">
     *         &lt;xs:sequence>
     *           &lt;xs:element type="ns:AdvResTicketingType" name="AdvResTicketing" minOccurs="0"/>
     *           &lt;xs:element type="ns:StayRestrictionsType" name="StayRestrictions" minOccurs="0"/>
     *           &lt;xs:element type="ns:VoluntaryChangesType" name="VoluntaryChanges" minOccurs="0"/>
     *         &lt;/xs:sequence>
     *       &lt;/xs:extension>
     *     &lt;/xs:complexContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FareRestrictPref extends FareRestrictPrefType implements
        Serializable
    {
        private AdvResTicketingType advResTicketing;
        private StayRestrictionsType stayRestrictions;
        private VoluntaryChangesType voluntaryChanges;

        /** 
         * Get the 'AdvResTicketing' element value. Identifies whether advance reservation or ticketing restrictions are acceptable in the search results.
         * 
         * @return value
         */
        public AdvResTicketingType getAdvResTicketing() {
            return advResTicketing;
        }

        /** 
         * Set the 'AdvResTicketing' element value. Identifies whether advance reservation or ticketing restrictions are acceptable in the search results.
         * 
         * @param advResTicketing
         */
        public void setAdvResTicketing(AdvResTicketingType advResTicketing) {
            this.advResTicketing = advResTicketing;
        }

        /** 
         * Get the 'StayRestrictions' element value. Identifies whether restrictions on minimum or maximum stays should be included in the search results.
         * 
         * @return value
         */
        public StayRestrictionsType getStayRestrictions() {
            return stayRestrictions;
        }

        /** 
         * Set the 'StayRestrictions' element value. Identifies whether restrictions on minimum or maximum stays should be included in the search results.
         * 
         * @param stayRestrictions
         */
        public void setStayRestrictions(StayRestrictionsType stayRestrictions) {
            this.stayRestrictions = stayRestrictions;
        }

        /** 
         * Get the 'VoluntaryChanges' element value. Identifies whether penalties associated with voluntary changes should be included in the search results.
         * 
         * @return value
         */
        public VoluntaryChangesType getVoluntaryChanges() {
            return voluntaryChanges;
        }

        /** 
         * Set the 'VoluntaryChanges' element value. Identifies whether penalties associated with voluntary changes should be included in the search results.
         * 
         * @param voluntaryChanges
         */
        public void setVoluntaryChanges(VoluntaryChangesType voluntaryChanges) {
            this.voluntaryChanges = voluntaryChanges;
        }
    }
    /** 
     * Additional elements and attributes to be included if required, per Trading Partner Agreement (TPA).
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TPA_Extensions" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:group ref="ns:TravelPreferencesTPA_ExtensionsDepartureArrivalWindowGroup"/>
     *       &lt;xs:element type="ns:CodeShareIndicator" name="CodeShareIndicator" minOccurs="0" maxOccurs="1"/>
     *       &lt;xs:element name="ExcludeVendorPref" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class ExcludeVendorPref -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:AllianceType" name="IncludeAlliancePref" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="ns:AllianceType" name="ExcludeAlliancePref" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="ns:NumTripsType" name="NumTrips" minOccurs="0"/>
     *       &lt;xs:element type="ns:AltCitiesCombinationsType" name="AltCitiesCombinations" minOccurs="0" maxOccurs="1"/>
     *       &lt;xs:element name="NumTripsWithRouting" minOccurs="0">
     *         &lt;!-- Reference to inner class NumTripsWithRouting -->
     *       &lt;/xs:element>
     *       &lt;xs:group ref="ns:TravelPreferencesTPA_ExtensionsOnlineInterlineIndicatorGroup"/>
     *       &lt;xs:element name="TripType" minOccurs="0">
     *         &lt;xs:complexType>
     *           &lt;xs:attribute type="ns:AirTripType" name="Value"/>
     *         &lt;/xs:complexType>
     *       &lt;/xs:element>
     *       &lt;xs:element name="MaxPrice" minOccurs="0">
     *         &lt;!-- Reference to inner class MaxPrice -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ContentType" minOccurs="0">
     *         &lt;!-- Reference to inner class ContentType -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="DomesticLayoverTime" minOccurs="0">
     *         &lt;!-- Reference to inner class DomesticLayoverTime -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="LongConnectTime" minOccurs="0">
     *         &lt;!-- Reference to inner class LongConnectTime -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="LongConnectPoints" minOccurs="0">
     *         &lt;!-- Reference to inner class LongConnectPoints -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AirServiceOnly" minOccurs="0">
     *         &lt;!-- Reference to inner class AirServiceOnly -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="JetServiceOnly" minOccurs="0">
     *         &lt;!-- Reference to inner class JetServiceOnly -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SameConnectionAirportOnly" minOccurs="0">
     *         &lt;!-- Reference to inner class SameConnectionAirportOnly -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SameOriginAirportOnly" minOccurs="0">
     *         &lt;!-- Reference to inner class SameOriginAirportOnly -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SameTurnaroundAirportOnly" minOccurs="0">
     *         &lt;!-- Reference to inner class SameTurnaroundAirportOnly -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AircraftTypePenalty" minOccurs="0">
     *         &lt;!-- Reference to inner class AircraftTypePenalty -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AlternateAirportPenalty" minOccurs="0">
     *         &lt;!-- Reference to inner class AlternateAirportPenalty -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareAmountThreshold" minOccurs="0">
     *         &lt;!-- Reference to inner class FareAmountThreshold -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="numOfLowFareSol" minOccurs="0">
     *         &lt;!-- Reference to inner class NumOfLowFareSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="numOfMustPriceOnlSol" minOccurs="0">
     *         &lt;!-- Reference to inner class NumOfMustPriceOnlSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="numOfMustPriceInrlSol" minOccurs="0">
     *         &lt;!-- Reference to inner class NumOfMustPriceInrlSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="numOfMustPriceNStpOnlSol" minOccurs="0">
     *         &lt;!-- Reference to inner class NumOfMustPriceNStpOnlSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="numOfMustPriceNStpInrlSol" minOccurs="0">
     *         &lt;!-- Reference to inner class NumOfMustPriceNStpInrlSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="numOfMustPriceSStopOnlSol" minOccurs="0">
     *         &lt;!-- Reference to inner class NumOfMustPriceSStopOnlSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="stpPenaltyInUSD" minOccurs="0">
     *         &lt;!-- Reference to inner class StpPenaltyInUSD -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="durPenaltyInUSD" minOccurs="0">
     *         &lt;!-- Reference to inner class DurPenaltyInUSD -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="depPenaltyInUSD" minOccurs="0">
     *         &lt;!-- Reference to inner class DepPenaltyInUSD -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="maxAllowedMustPriceOveragePerCrr" minOccurs="0">
     *         &lt;!-- Reference to inner class MaxAllowedMustPriceOveragePerCrr -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="fltOptMustPriceReuseLimit" minOccurs="0">
     *         &lt;!-- Reference to inner class FltOptMustPriceReuseLimit -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="upperBoundMustPriceFactorForNotNonStp" minOccurs="0">
     *         &lt;!-- Reference to inner class UpperBoundMustPriceFactorForNotNonStp -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="upperBoundLFSFactor" minOccurs="0">
     *         &lt;!-- Reference to inner class UpperBoundLFSFactor -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="numOfMustPriceNStp1StpOnlSol" minOccurs="0">
     *         &lt;!-- Reference to inner class NumOfMustPriceNStp1StpOnlSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="numOfMustPriceNStp1StpInrlSol" minOccurs="0">
     *         &lt;!-- Reference to inner class NumOfMustPriceNStp1StpInrlSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="upperBoundMustPriceFactorForNonStp" minOccurs="0">
     *         &lt;!-- Reference to inner class UpperBoundMustPriceFactorForNonStp -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="maxAllowedLFSOveragePerCrrPercent" minOccurs="0">
     *         &lt;!-- Reference to inner class MaxAllowedLFSOveragePerCrrPercent -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="targetMinNumOfLFSOnlSolPerCrr" minOccurs="0">
     *         &lt;!-- Reference to inner class TargetMinNumOfLFSOnlSolPerCrr -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="targetMinNumOfLFSTotOnlSolPercent" minOccurs="0">
     *         &lt;!-- Reference to inner class TargetMinNumOfLFSTotOnlSolPercent -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="fltOptLFSReuseLimitForNonAVS" minOccurs="0">
     *         &lt;!-- Reference to inner class FltOptLFSReuseLimitForNonAVS -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="fltOptLFSReuseLimitForAVS" minOccurs="0">
     *         &lt;!-- Reference to inner class FltOptLFSReuseLimitForAVS -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="avsPenaltyCrrs" minOccurs="0">
     *         &lt;!-- Reference to inner class AvsPenaltyCrrs -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="maxNumOfNonStpOnlSol" minOccurs="0">
     *         &lt;!-- Reference to inner class MaxNumOfNonStpOnlSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="maxNumOfNonStpInrlSol" minOccurs="0">
     *         &lt;!-- Reference to inner class MaxNumOfNonStpInrlSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="maxNumOfSingleStpOnlSol" minOccurs="0">
     *         &lt;!-- Reference to inner class MaxNumOfSingleStpOnlSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="maxNumOf2PlusStpSol" minOccurs="0">
     *         &lt;!-- Reference to inner class MaxNumOf2PlusStpSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="minAllowedOveragePerCrrPercent" minOccurs="0">
     *         &lt;!-- Reference to inner class MinAllowedOveragePerCrrPercent -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="minAllowedOveragePerCrr" minOccurs="0">
     *         &lt;!-- Reference to inner class MinAllowedOveragePerCrr -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="maxRelFareLvlOfxForNonStp" minOccurs="0">
     *         &lt;!-- Reference to inner class MaxRelFareLvlOfxForNonStp -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="maxRelFareLvlOfxForCnx" minOccurs="0">
     *         &lt;!-- Reference to inner class MaxRelFareLvlOfxForCnx -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="numOfMustPrice2PlusStpSol" minOccurs="0">
     *         &lt;!-- Reference to inner class NumOfMustPrice2PlusStpSol -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="ItineraryNumberThreshold" minOccurs="0">
     *         &lt;!-- Reference to inner class ItineraryNumberThreshold -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:XOFaresType" name="XOFares" minOccurs="0"/>
     *       &lt;xs:group ref="ns:TravelPreferencesTPA_ExtensionsTaxesGroup"/>
     *       &lt;xs:element type="ns:FlightStopsAsConnectionsType" name="FlightStopsAsConnections" minOccurs="0"/>
     *       &lt;xs:element name="TicketingSumOfLocals" minOccurs="0">
     *         &lt;!-- Reference to inner class TicketingSumOfLocals -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="MultiAirportCodes" minOccurs="0">
     *         &lt;!-- Reference to inner class MultiAirportCodes -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:JumpCabinLogicType" name="JumpCabinLogic" minOccurs="0"/>
     *       &lt;xs:element type="ns:KeepSameCabinType" name="KeepSameCabin" minOccurs="0"/>
     *       &lt;xs:element type="ns:AvoidCabinDowngradeType" name="AvoidCabinDowngrade" minOccurs="0"/>
     *       &lt;xs:element type="ns:GoverningCarrierOverrideType" name="GoverningCarrierOverride" minOccurs="0"/>
     *       &lt;xs:element name="ExcludeCallDirectCarriers" minOccurs="0">
     *         &lt;!-- Reference to inner class ExcludeCallDirectCarriers -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:ValidatingCarrierType" name="ValidatingCarrier" minOccurs="0"/>
     *       &lt;xs:element name="ValidatingCarrierCheck" minOccurs="0">
     *         &lt;!-- Reference to inner class ValidatingCarrierCheck -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="xs:string" name="SettlementMethod" minOccurs="0"/>
     *       &lt;xs:element name="FlightRepeatLimit" minOccurs="0">
     *         &lt;!-- Reference to inner class FlightRepeatLimit -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:FreeSeatSelectionAndInfoType" name="SeatSelection" minOccurs="0" maxOccurs="1"/>
     *       &lt;xs:element type="ns:FreePriorityBoardingAndInfoType" name="PriorityBoarding" minOccurs="0" maxOccurs="1"/>
     *       &lt;xs:element type="ns:FlexibleFaresType" name="FlexibleFares" minOccurs="0"/>
     *       &lt;xs:element name="DiversityParameters" minOccurs="0">
     *         &lt;!-- Reference to inner class DiversityParameters -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="AdditionalFareLimit" minOccurs="0">
     *         &lt;!-- Reference to inner class AdditionalFareLimit -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FareFocusRules" minOccurs="0">
     *         &lt;!-- Reference to inner class FareFocusRules -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="SellingLevels" minOccurs="0">
     *         &lt;!-- Reference to inner class SellingLevels -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Budget" minOccurs="0">
     *         &lt;!-- Reference to inner class Budget -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="OptionsPerDatePairList" minOccurs="0">
     *         &lt;!-- Reference to inner class OptionsPerDatePairList -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="CountryPref" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class CountryPref -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:RetailerRulesType" name="RetailerRules" minOccurs="0"/>
     *       &lt;xs:element name="ForceKeywordRestrictedContent" minOccurs="0">
     *         &lt;!-- Reference to inner class ForceKeywordRestrictedContent -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="FlightRestrictions" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class FlightRestrictions -->
     *       &lt;/xs:element>
     *       &lt;xs:choice>
     *         &lt;xs:element name="LowCostCarriersProcessing" minOccurs="0" maxOccurs="1">
     *           &lt;!-- Reference to inner class LowCostCarriersProcessing -->
     *         &lt;/xs:element>
     *         &lt;xs:element name="DataSources" minOccurs="0" maxOccurs="1">
     *           &lt;!-- Reference to inner class DataSources -->
     *         &lt;/xs:element>
     *       &lt;/xs:choice>
     *       &lt;xs:element name="VerificationItinCallLogic" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class VerificationItinCallLogic -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:ClassOfServiceElemType" name="ClassOfService" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="ns:FareBasisType" name="FareBasis" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element type="ns:FareTypePrefType" name="FareType" minOccurs="0" maxOccurs="unbounded"/>
     *       &lt;xs:element name="PreferNDCSourceOnTie" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class PreferNDCSourceOnTie -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="NDCIndicators" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class NDCIndicators -->
     *       &lt;/xs:element>
     *       &lt;xs:element type="ns:SeatComfortPrefType" name="Seats" minOccurs="0"/>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TPAExtensions implements Serializable
    {
        private TravelPreferencesTPAExtensionsDepartureArrivalWindowGroup travelPreferencesTPAExtensionsDepartureArrivalWindowGroup;
        private CodeShareIndicator codeShareIndicator;
        private List<ExcludeVendorPref> excludeVendorPrefList = new ArrayList<ExcludeVendorPref>();
        private List<AllianceType> includeAlliancePrefList = new ArrayList<AllianceType>();
        private List<AllianceType> excludeAlliancePrefList = new ArrayList<AllianceType>();
        private NumTripsType numTrips;
        private AltCitiesCombinationsType altCitiesCombinations;
        private NumTripsWithRouting numTripsWithRouting;
        private TravelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup travelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup;
        private AirTripType tripType;
        private MaxPrice maxPrice;
        private ContentType contentType;
        private DomesticLayoverTime domesticLayoverTime;
        private LongConnectTime longConnectTime;
        private LongConnectPoints longConnectPoints;
        private AirServiceOnly airServiceOnly;
        private JetServiceOnly jetServiceOnly;
        private SameConnectionAirportOnly sameConnectionAirportOnly;
        private SameOriginAirportOnly sameOriginAirportOnly;
        private SameTurnaroundAirportOnly sameTurnaroundAirportOnly;
        private AircraftTypePenalty aircraftTypePenalty;
        private AlternateAirportPenalty alternateAirportPenalty;
        private FareAmountThreshold fareAmountThreshold;
        private NumOfLowFareSol numOfLowFareSol;
        private NumOfMustPriceOnlSol numOfMustPriceOnlSol;
        private NumOfMustPriceInrlSol numOfMustPriceInrlSol;
        private NumOfMustPriceNStpOnlSol numOfMustPriceNStpOnlSol;
        private NumOfMustPriceNStpInrlSol numOfMustPriceNStpInrlSol;
        private NumOfMustPriceSStopOnlSol numOfMustPriceSStopOnlSol;
        private StpPenaltyInUSD stpPenaltyInUSD;
        private DurPenaltyInUSD durPenaltyInUSD;
        private DepPenaltyInUSD depPenaltyInUSD;
        private MaxAllowedMustPriceOveragePerCrr maxAllowedMustPriceOveragePerCrr;
        private FltOptMustPriceReuseLimit fltOptMustPriceReuseLimit;
        private UpperBoundMustPriceFactorForNotNonStp upperBoundMustPriceFactorForNotNonStp;
        private UpperBoundLFSFactor upperBoundLFSFactor;
        private NumOfMustPriceNStp1StpOnlSol numOfMustPriceNStp1StpOnlSol;
        private NumOfMustPriceNStp1StpInrlSol numOfMustPriceNStp1StpInrlSol;
        private UpperBoundMustPriceFactorForNonStp upperBoundMustPriceFactorForNonStp;
        private MaxAllowedLFSOveragePerCrrPercent maxAllowedLFSOveragePerCrrPercent;
        private TargetMinNumOfLFSOnlSolPerCrr targetMinNumOfLFSOnlSolPerCrr;
        private TargetMinNumOfLFSTotOnlSolPercent targetMinNumOfLFSTotOnlSolPercent;
        private FltOptLFSReuseLimitForNonAVS fltOptLFSReuseLimitForNonAVS;
        private FltOptLFSReuseLimitForAVS fltOptLFSReuseLimitForAVS;
        private AvsPenaltyCrrs avsPenaltyCrrs;
        private MaxNumOfNonStpOnlSol maxNumOfNonStpOnlSol;
        private MaxNumOfNonStpInrlSol maxNumOfNonStpInrlSol;
        private MaxNumOfSingleStpOnlSol maxNumOfSingleStpOnlSol;
        private MaxNumOf2PlusStpSol maxNumOf2PlusStpSol;
        private MinAllowedOveragePerCrrPercent minAllowedOveragePerCrrPercent;
        private MinAllowedOveragePerCrr minAllowedOveragePerCrr;
        private MaxRelFareLvlOfxForNonStp maxRelFareLvlOfxForNonStp;
        private MaxRelFareLvlOfxForCnx maxRelFareLvlOfxForCnx;
        private NumOfMustPrice2PlusStpSol numOfMustPrice2PlusStpSol;
        private ItineraryNumberThreshold itineraryNumberThreshold;
        private XOFaresType XOFares;
        private TravelPreferencesTPAExtensionsTaxesGroup travelPreferencesTPAExtensionsTaxesGroup;
        private FlightStopsAsConnectionsType flightStopsAsConnections;
        private TicketingSumOfLocals ticketingSumOfLocals;
        private MultiAirportCodes multiAirportCodes;
        private JumpCabinLogicType jumpCabinLogic;
        private KeepSameCabinType keepSameCabin;
        private AvoidCabinDowngradeType avoidCabinDowngrade;
        private GoverningCarrierOverrideType governingCarrierOverride;
        private ExcludeCallDirectCarriers excludeCallDirectCarriers;
        private ValidatingCarrierType validatingCarrier;
        private ValidatingCarrierCheck validatingCarrierCheck;
        private String settlementMethod;
        private FlightRepeatLimit flightRepeatLimit;
        private FreeSeatSelectionAndInfoType seatSelection;
        private FreePriorityBoardingAndInfoType priorityBoarding;
        private FlexibleFaresType flexibleFares;
        private DiversityParameters diversityParameters;
        private AdditionalFareLimit additionalFareLimit;
        private FareFocusRules fareFocusRules;
        private SellingLevels sellingLevels;
        private Budget budget;
        private OptionsPerDatePairList optionsPerDatePairList;
        private List<CountryPref> countryPrefList = new ArrayList<CountryPref>();
        private RetailerRulesType retailerRules;
        private ForceKeywordRestrictedContent forceKeywordRestrictedContent;
        private FlightRestrictions flightRestrictions;
        private int choiceSelect = -1;
        private static final int LOW_COST_CARRIERS_PROCESSING_CHOICE = 0;
        private static final int DATA_SOURCES_CHOICE = 1;
        private LowCostCarriersProcessing lowCostCarriersProcessing;
        private DataSources dataSources;
        private VerificationItinCallLogic verificationItinCallLogic;
        private List<ClassOfServiceElemType> classOfServiceList = new ArrayList<ClassOfServiceElemType>();
        private List<FareBasisType> fareBasiList = new ArrayList<FareBasisType>();
        private List<FareTypePrefType> fareTypeList = new ArrayList<FareTypePrefType>();
        private PreferNDCSourceOnTie preferNDCSourceOnTie;
        private NDCIndicators NDCIndicators1;
        private SeatComfortPrefType seats;

        /** 
         * Get the 'TravelPreferencesTPA_ExtensionsDepartureArrivalWindowGroup' group value.
         * 
         * @return value
         */
        public TravelPreferencesTPAExtensionsDepartureArrivalWindowGroup getTravelPreferencesTPAExtensionsDepartureArrivalWindowGroup() {
            return travelPreferencesTPAExtensionsDepartureArrivalWindowGroup;
        }

        /** 
         * Set the 'TravelPreferencesTPA_ExtensionsDepartureArrivalWindowGroup' group value.
         * 
         * @param travelPreferencesTPAExtensionsDepartureArrivalWindowGroup
         */
        public void setTravelPreferencesTPAExtensionsDepartureArrivalWindowGroup(
                TravelPreferencesTPAExtensionsDepartureArrivalWindowGroup travelPreferencesTPAExtensionsDepartureArrivalWindowGroup) {
            this.travelPreferencesTPAExtensionsDepartureArrivalWindowGroup = travelPreferencesTPAExtensionsDepartureArrivalWindowGroup;
        }

        /** 
         * Get the 'CodeShareIndicator' element value.
         * 
         * @return value
         */
        public CodeShareIndicator getCodeShareIndicator() {
            return codeShareIndicator;
        }

        /** 
         * Set the 'CodeShareIndicator' element value.
         * 
         * @param codeShareIndicator
         */
        public void setCodeShareIndicator(CodeShareIndicator codeShareIndicator) {
            this.codeShareIndicator = codeShareIndicator;
        }

        /** 
         * Get the list of 'ExcludeVendorPref' element items.
         * 
         * @return list
         */
        public List<ExcludeVendorPref> getExcludeVendorPrefList() {
            return excludeVendorPrefList;
        }

        /** 
         * Set the list of 'ExcludeVendorPref' element items.
         * 
         * @param list
         */
        public void setExcludeVendorPrefList(List<ExcludeVendorPref> list) {
            excludeVendorPrefList = list;
        }

        /** 
         * Get the list of 'IncludeAlliancePref' element items. Consider only these alliances.
         * 
         * @return list
         */
        public List<AllianceType> getIncludeAlliancePrefList() {
            return includeAlliancePrefList;
        }

        /** 
         * Set the list of 'IncludeAlliancePref' element items. Consider only these alliances.
         * 
         * @param list
         */
        public void setIncludeAlliancePrefList(List<AllianceType> list) {
            includeAlliancePrefList = list;
        }

        /** 
         * Get the list of 'ExcludeAlliancePref' element items. Do not consider these alliances.
         * 
         * @return list
         */
        public List<AllianceType> getExcludeAlliancePrefList() {
            return excludeAlliancePrefList;
        }

        /** 
         * Set the list of 'ExcludeAlliancePref' element items. Do not consider these alliances.
         * 
         * @param list
         */
        public void setExcludeAlliancePrefList(List<AllianceType> list) {
            excludeAlliancePrefList = list;
        }

        /** 
         * Get the 'NumTrips' element value.
         * 
         * @return value
         */
        public NumTripsType getNumTrips() {
            return numTrips;
        }

        /** 
         * Set the 'NumTrips' element value.
         * 
         * @param numTrips
         */
        public void setNumTrips(NumTripsType numTrips) {
            this.numTrips = numTrips;
        }

        /** 
         * Get the 'AltCitiesCombinations' element value.
         * 
         * @return value
         */
        public AltCitiesCombinationsType getAltCitiesCombinations() {
            return altCitiesCombinations;
        }

        /** 
         * Set the 'AltCitiesCombinations' element value.
         * 
         * @param altCitiesCombinations
         */
        public void setAltCitiesCombinations(
                AltCitiesCombinationsType altCitiesCombinations) {
            this.altCitiesCombinations = altCitiesCombinations;
        }

        /** 
         * Get the 'NumTripsWithRouting' element value.
         * 
         * @return value
         */
        public NumTripsWithRouting getNumTripsWithRouting() {
            return numTripsWithRouting;
        }

        /** 
         * Set the 'NumTripsWithRouting' element value.
         * 
         * @param numTripsWithRouting
         */
        public void setNumTripsWithRouting(
                NumTripsWithRouting numTripsWithRouting) {
            this.numTripsWithRouting = numTripsWithRouting;
        }

        /** 
         * Get the 'TravelPreferencesTPA_ExtensionsOnlineInterlineIndicatorGroup' group value.
         * 
         * @return value
         */
        public TravelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup getTravelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup() {
            return travelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup;
        }

        /** 
         * Set the 'TravelPreferencesTPA_ExtensionsOnlineInterlineIndicatorGroup' group value.
         * 
         * @param travelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup
         */
        public void setTravelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup(
                TravelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup travelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup) {
            this.travelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup = travelPreferencesTPAExtensionsOnlineInterlineIndicatorGroup;
        }

        /** 
         * Get the 'Value' attribute value. Specify air trip type.
         * 
         * @return value
         */
        public AirTripType getTripType() {
            return tripType;
        }

        /** 
         * Set the 'Value' attribute value. Specify air trip type.
         * 
         * @param tripType
         */
        public void setTripType(AirTripType tripType) {
            this.tripType = tripType;
        }

        /** 
         * Get the 'MaxPrice' element value.
         * 
         * @return value
         */
        public MaxPrice getMaxPrice() {
            return maxPrice;
        }

        /** 
         * Set the 'MaxPrice' element value.
         * 
         * @param maxPrice
         */
        public void setMaxPrice(MaxPrice maxPrice) {
            this.maxPrice = maxPrice;
        }

        /** 
         * Get the 'ContentType' element value.
         * 
         * @return value
         */
        public ContentType getContentType() {
            return contentType;
        }

        /** 
         * Set the 'ContentType' element value.
         * 
         * @param contentType
         */
        public void setContentType(ContentType contentType) {
            this.contentType = contentType;
        }

        /** 
         * Get the 'DomesticLayoverTime' element value.
         * 
         * @return value
         */
        public DomesticLayoverTime getDomesticLayoverTime() {
            return domesticLayoverTime;
        }

        /** 
         * Set the 'DomesticLayoverTime' element value.
         * 
         * @param domesticLayoverTime
         */
        public void setDomesticLayoverTime(
                DomesticLayoverTime domesticLayoverTime) {
            this.domesticLayoverTime = domesticLayoverTime;
        }

        /** 
         * Get the 'LongConnectTime' element value.
         * 
         * @return value
         */
        public LongConnectTime getLongConnectTime() {
            return longConnectTime;
        }

        /** 
         * Set the 'LongConnectTime' element value.
         * 
         * @param longConnectTime
         */
        public void setLongConnectTime(LongConnectTime longConnectTime) {
            this.longConnectTime = longConnectTime;
        }

        /** 
         * Get the 'LongConnectPoints' element value.
         * 
         * @return value
         */
        public LongConnectPoints getLongConnectPoints() {
            return longConnectPoints;
        }

        /** 
         * Set the 'LongConnectPoints' element value.
         * 
         * @param longConnectPoints
         */
        public void setLongConnectPoints(LongConnectPoints longConnectPoints) {
            this.longConnectPoints = longConnectPoints;
        }

        /** 
         * Get the 'AirServiceOnly' element value.
         * 
         * @return value
         */
        public AirServiceOnly getAirServiceOnly() {
            return airServiceOnly;
        }

        /** 
         * Set the 'AirServiceOnly' element value.
         * 
         * @param airServiceOnly
         */
        public void setAirServiceOnly(AirServiceOnly airServiceOnly) {
            this.airServiceOnly = airServiceOnly;
        }

        /** 
         * Get the 'JetServiceOnly' element value.
         * 
         * @return value
         */
        public JetServiceOnly getJetServiceOnly() {
            return jetServiceOnly;
        }

        /** 
         * Set the 'JetServiceOnly' element value.
         * 
         * @param jetServiceOnly
         */
        public void setJetServiceOnly(JetServiceOnly jetServiceOnly) {
            this.jetServiceOnly = jetServiceOnly;
        }

        /** 
         * Get the 'SameConnectionAirportOnly' element value.
         * 
         * @return value
         */
        public SameConnectionAirportOnly getSameConnectionAirportOnly() {
            return sameConnectionAirportOnly;
        }

        /** 
         * Set the 'SameConnectionAirportOnly' element value.
         * 
         * @param sameConnectionAirportOnly
         */
        public void setSameConnectionAirportOnly(
                SameConnectionAirportOnly sameConnectionAirportOnly) {
            this.sameConnectionAirportOnly = sameConnectionAirportOnly;
        }

        /** 
         * Get the 'SameOriginAirportOnly' element value.
         * 
         * @return value
         */
        public SameOriginAirportOnly getSameOriginAirportOnly() {
            return sameOriginAirportOnly;
        }

        /** 
         * Set the 'SameOriginAirportOnly' element value.
         * 
         * @param sameOriginAirportOnly
         */
        public void setSameOriginAirportOnly(
                SameOriginAirportOnly sameOriginAirportOnly) {
            this.sameOriginAirportOnly = sameOriginAirportOnly;
        }

        /** 
         * Get the 'SameTurnaroundAirportOnly' element value.
         * 
         * @return value
         */
        public SameTurnaroundAirportOnly getSameTurnaroundAirportOnly() {
            return sameTurnaroundAirportOnly;
        }

        /** 
         * Set the 'SameTurnaroundAirportOnly' element value.
         * 
         * @param sameTurnaroundAirportOnly
         */
        public void setSameTurnaroundAirportOnly(
                SameTurnaroundAirportOnly sameTurnaroundAirportOnly) {
            this.sameTurnaroundAirportOnly = sameTurnaroundAirportOnly;
        }

        /** 
         * Get the 'AircraftTypePenalty' element value.
         * 
         * @return value
         */
        public AircraftTypePenalty getAircraftTypePenalty() {
            return aircraftTypePenalty;
        }

        /** 
         * Set the 'AircraftTypePenalty' element value.
         * 
         * @param aircraftTypePenalty
         */
        public void setAircraftTypePenalty(
                AircraftTypePenalty aircraftTypePenalty) {
            this.aircraftTypePenalty = aircraftTypePenalty;
        }

        /** 
         * Get the 'AlternateAirportPenalty' element value.
         * 
         * @return value
         */
        public AlternateAirportPenalty getAlternateAirportPenalty() {
            return alternateAirportPenalty;
        }

        /** 
         * Set the 'AlternateAirportPenalty' element value.
         * 
         * @param alternateAirportPenalty
         */
        public void setAlternateAirportPenalty(
                AlternateAirportPenalty alternateAirportPenalty) {
            this.alternateAirportPenalty = alternateAirportPenalty;
        }

        /** 
         * Get the 'FareAmountThreshold' element value.
         * 
         * @return value
         */
        public FareAmountThreshold getFareAmountThreshold() {
            return fareAmountThreshold;
        }

        /** 
         * Set the 'FareAmountThreshold' element value.
         * 
         * @param fareAmountThreshold
         */
        public void setFareAmountThreshold(
                FareAmountThreshold fareAmountThreshold) {
            this.fareAmountThreshold = fareAmountThreshold;
        }

        /** 
         * Get the 'numOfLowFareSol' element value.
         * 
         * @return value
         */
        public NumOfLowFareSol getNumOfLowFareSol() {
            return numOfLowFareSol;
        }

        /** 
         * Set the 'numOfLowFareSol' element value.
         * 
         * @param numOfLowFareSol
         */
        public void setNumOfLowFareSol(NumOfLowFareSol numOfLowFareSol) {
            this.numOfLowFareSol = numOfLowFareSol;
        }

        /** 
         * Get the 'numOfMustPriceOnlSol' element value.
         * 
         * @return value
         */
        public NumOfMustPriceOnlSol getNumOfMustPriceOnlSol() {
            return numOfMustPriceOnlSol;
        }

        /** 
         * Set the 'numOfMustPriceOnlSol' element value.
         * 
         * @param numOfMustPriceOnlSol
         */
        public void setNumOfMustPriceOnlSol(
                NumOfMustPriceOnlSol numOfMustPriceOnlSol) {
            this.numOfMustPriceOnlSol = numOfMustPriceOnlSol;
        }

        /** 
         * Get the 'numOfMustPriceInrlSol' element value.
         * 
         * @return value
         */
        public NumOfMustPriceInrlSol getNumOfMustPriceInrlSol() {
            return numOfMustPriceInrlSol;
        }

        /** 
         * Set the 'numOfMustPriceInrlSol' element value.
         * 
         * @param numOfMustPriceInrlSol
         */
        public void setNumOfMustPriceInrlSol(
                NumOfMustPriceInrlSol numOfMustPriceInrlSol) {
            this.numOfMustPriceInrlSol = numOfMustPriceInrlSol;
        }

        /** 
         * Get the 'numOfMustPriceNStpOnlSol' element value.
         * 
         * @return value
         */
        public NumOfMustPriceNStpOnlSol getNumOfMustPriceNStpOnlSol() {
            return numOfMustPriceNStpOnlSol;
        }

        /** 
         * Set the 'numOfMustPriceNStpOnlSol' element value.
         * 
         * @param numOfMustPriceNStpOnlSol
         */
        public void setNumOfMustPriceNStpOnlSol(
                NumOfMustPriceNStpOnlSol numOfMustPriceNStpOnlSol) {
            this.numOfMustPriceNStpOnlSol = numOfMustPriceNStpOnlSol;
        }

        /** 
         * Get the 'numOfMustPriceNStpInrlSol' element value.
         * 
         * @return value
         */
        public NumOfMustPriceNStpInrlSol getNumOfMustPriceNStpInrlSol() {
            return numOfMustPriceNStpInrlSol;
        }

        /** 
         * Set the 'numOfMustPriceNStpInrlSol' element value.
         * 
         * @param numOfMustPriceNStpInrlSol
         */
        public void setNumOfMustPriceNStpInrlSol(
                NumOfMustPriceNStpInrlSol numOfMustPriceNStpInrlSol) {
            this.numOfMustPriceNStpInrlSol = numOfMustPriceNStpInrlSol;
        }

        /** 
         * Get the 'numOfMustPriceSStopOnlSol' element value.
         * 
         * @return value
         */
        public NumOfMustPriceSStopOnlSol getNumOfMustPriceSStopOnlSol() {
            return numOfMustPriceSStopOnlSol;
        }

        /** 
         * Set the 'numOfMustPriceSStopOnlSol' element value.
         * 
         * @param numOfMustPriceSStopOnlSol
         */
        public void setNumOfMustPriceSStopOnlSol(
                NumOfMustPriceSStopOnlSol numOfMustPriceSStopOnlSol) {
            this.numOfMustPriceSStopOnlSol = numOfMustPriceSStopOnlSol;
        }

        /** 
         * Get the 'stpPenaltyInUSD' element value.
         * 
         * @return value
         */
        public StpPenaltyInUSD getStpPenaltyInUSD() {
            return stpPenaltyInUSD;
        }

        /** 
         * Set the 'stpPenaltyInUSD' element value.
         * 
         * @param stpPenaltyInUSD
         */
        public void setStpPenaltyInUSD(StpPenaltyInUSD stpPenaltyInUSD) {
            this.stpPenaltyInUSD = stpPenaltyInUSD;
        }

        /** 
         * Get the 'durPenaltyInUSD' element value.
         * 
         * @return value
         */
        public DurPenaltyInUSD getDurPenaltyInUSD() {
            return durPenaltyInUSD;
        }

        /** 
         * Set the 'durPenaltyInUSD' element value.
         * 
         * @param durPenaltyInUSD
         */
        public void setDurPenaltyInUSD(DurPenaltyInUSD durPenaltyInUSD) {
            this.durPenaltyInUSD = durPenaltyInUSD;
        }

        /** 
         * Get the 'depPenaltyInUSD' element value.
         * 
         * @return value
         */
        public DepPenaltyInUSD getDepPenaltyInUSD() {
            return depPenaltyInUSD;
        }

        /** 
         * Set the 'depPenaltyInUSD' element value.
         * 
         * @param depPenaltyInUSD
         */
        public void setDepPenaltyInUSD(DepPenaltyInUSD depPenaltyInUSD) {
            this.depPenaltyInUSD = depPenaltyInUSD;
        }

        /** 
         * Get the 'maxAllowedMustPriceOveragePerCrr' element value.
         * 
         * @return value
         */
        public MaxAllowedMustPriceOveragePerCrr getMaxAllowedMustPriceOveragePerCrr() {
            return maxAllowedMustPriceOveragePerCrr;
        }

        /** 
         * Set the 'maxAllowedMustPriceOveragePerCrr' element value.
         * 
         * @param maxAllowedMustPriceOveragePerCrr
         */
        public void setMaxAllowedMustPriceOveragePerCrr(
                MaxAllowedMustPriceOveragePerCrr maxAllowedMustPriceOveragePerCrr) {
            this.maxAllowedMustPriceOveragePerCrr = maxAllowedMustPriceOveragePerCrr;
        }

        /** 
         * Get the 'fltOptMustPriceReuseLimit' element value.
         * 
         * @return value
         */
        public FltOptMustPriceReuseLimit getFltOptMustPriceReuseLimit() {
            return fltOptMustPriceReuseLimit;
        }

        /** 
         * Set the 'fltOptMustPriceReuseLimit' element value.
         * 
         * @param fltOptMustPriceReuseLimit
         */
        public void setFltOptMustPriceReuseLimit(
                FltOptMustPriceReuseLimit fltOptMustPriceReuseLimit) {
            this.fltOptMustPriceReuseLimit = fltOptMustPriceReuseLimit;
        }

        /** 
         * Get the 'upperBoundMustPriceFactorForNotNonStp' element value.
         * 
         * @return value
         */
        public UpperBoundMustPriceFactorForNotNonStp getUpperBoundMustPriceFactorForNotNonStp() {
            return upperBoundMustPriceFactorForNotNonStp;
        }

        /** 
         * Set the 'upperBoundMustPriceFactorForNotNonStp' element value.
         * 
         * @param upperBoundMustPriceFactorForNotNonStp
         */
        public void setUpperBoundMustPriceFactorForNotNonStp(
                UpperBoundMustPriceFactorForNotNonStp upperBoundMustPriceFactorForNotNonStp) {
            this.upperBoundMustPriceFactorForNotNonStp = upperBoundMustPriceFactorForNotNonStp;
        }

        /** 
         * Get the 'upperBoundLFSFactor' element value.
         * 
         * @return value
         */
        public UpperBoundLFSFactor getUpperBoundLFSFactor() {
            return upperBoundLFSFactor;
        }

        /** 
         * Set the 'upperBoundLFSFactor' element value.
         * 
         * @param upperBoundLFSFactor
         */
        public void setUpperBoundLFSFactor(
                UpperBoundLFSFactor upperBoundLFSFactor) {
            this.upperBoundLFSFactor = upperBoundLFSFactor;
        }

        /** 
         * Get the 'numOfMustPriceNStp1StpOnlSol' element value.
         * 
         * @return value
         */
        public NumOfMustPriceNStp1StpOnlSol getNumOfMustPriceNStp1StpOnlSol() {
            return numOfMustPriceNStp1StpOnlSol;
        }

        /** 
         * Set the 'numOfMustPriceNStp1StpOnlSol' element value.
         * 
         * @param numOfMustPriceNStp1StpOnlSol
         */
        public void setNumOfMustPriceNStp1StpOnlSol(
                NumOfMustPriceNStp1StpOnlSol numOfMustPriceNStp1StpOnlSol) {
            this.numOfMustPriceNStp1StpOnlSol = numOfMustPriceNStp1StpOnlSol;
        }

        /** 
         * Get the 'numOfMustPriceNStp1StpInrlSol' element value.
         * 
         * @return value
         */
        public NumOfMustPriceNStp1StpInrlSol getNumOfMustPriceNStp1StpInrlSol() {
            return numOfMustPriceNStp1StpInrlSol;
        }

        /** 
         * Set the 'numOfMustPriceNStp1StpInrlSol' element value.
         * 
         * @param numOfMustPriceNStp1StpInrlSol
         */
        public void setNumOfMustPriceNStp1StpInrlSol(
                NumOfMustPriceNStp1StpInrlSol numOfMustPriceNStp1StpInrlSol) {
            this.numOfMustPriceNStp1StpInrlSol = numOfMustPriceNStp1StpInrlSol;
        }

        /** 
         * Get the 'upperBoundMustPriceFactorForNonStp' element value.
         * 
         * @return value
         */
        public UpperBoundMustPriceFactorForNonStp getUpperBoundMustPriceFactorForNonStp() {
            return upperBoundMustPriceFactorForNonStp;
        }

        /** 
         * Set the 'upperBoundMustPriceFactorForNonStp' element value.
         * 
         * @param upperBoundMustPriceFactorForNonStp
         */
        public void setUpperBoundMustPriceFactorForNonStp(
                UpperBoundMustPriceFactorForNonStp upperBoundMustPriceFactorForNonStp) {
            this.upperBoundMustPriceFactorForNonStp = upperBoundMustPriceFactorForNonStp;
        }

        /** 
         * Get the 'maxAllowedLFSOveragePerCrrPercent' element value.
         * 
         * @return value
         */
        public MaxAllowedLFSOveragePerCrrPercent getMaxAllowedLFSOveragePerCrrPercent() {
            return maxAllowedLFSOveragePerCrrPercent;
        }

        /** 
         * Set the 'maxAllowedLFSOveragePerCrrPercent' element value.
         * 
         * @param maxAllowedLFSOveragePerCrrPercent
         */
        public void setMaxAllowedLFSOveragePerCrrPercent(
                MaxAllowedLFSOveragePerCrrPercent maxAllowedLFSOveragePerCrrPercent) {
            this.maxAllowedLFSOveragePerCrrPercent = maxAllowedLFSOveragePerCrrPercent;
        }

        /** 
         * Get the 'targetMinNumOfLFSOnlSolPerCrr' element value.
         * 
         * @return value
         */
        public TargetMinNumOfLFSOnlSolPerCrr getTargetMinNumOfLFSOnlSolPerCrr() {
            return targetMinNumOfLFSOnlSolPerCrr;
        }

        /** 
         * Set the 'targetMinNumOfLFSOnlSolPerCrr' element value.
         * 
         * @param targetMinNumOfLFSOnlSolPerCrr
         */
        public void setTargetMinNumOfLFSOnlSolPerCrr(
                TargetMinNumOfLFSOnlSolPerCrr targetMinNumOfLFSOnlSolPerCrr) {
            this.targetMinNumOfLFSOnlSolPerCrr = targetMinNumOfLFSOnlSolPerCrr;
        }

        /** 
         * Get the 'targetMinNumOfLFSTotOnlSolPercent' element value.
         * 
         * @return value
         */
        public TargetMinNumOfLFSTotOnlSolPercent getTargetMinNumOfLFSTotOnlSolPercent() {
            return targetMinNumOfLFSTotOnlSolPercent;
        }

        /** 
         * Set the 'targetMinNumOfLFSTotOnlSolPercent' element value.
         * 
         * @param targetMinNumOfLFSTotOnlSolPercent
         */
        public void setTargetMinNumOfLFSTotOnlSolPercent(
                TargetMinNumOfLFSTotOnlSolPercent targetMinNumOfLFSTotOnlSolPercent) {
            this.targetMinNumOfLFSTotOnlSolPercent = targetMinNumOfLFSTotOnlSolPercent;
        }

        /** 
         * Get the 'fltOptLFSReuseLimitForNonAVS' element value.
         * 
         * @return value
         */
        public FltOptLFSReuseLimitForNonAVS getFltOptLFSReuseLimitForNonAVS() {
            return fltOptLFSReuseLimitForNonAVS;
        }

        /** 
         * Set the 'fltOptLFSReuseLimitForNonAVS' element value.
         * 
         * @param fltOptLFSReuseLimitForNonAVS
         */
        public void setFltOptLFSReuseLimitForNonAVS(
                FltOptLFSReuseLimitForNonAVS fltOptLFSReuseLimitForNonAVS) {
            this.fltOptLFSReuseLimitForNonAVS = fltOptLFSReuseLimitForNonAVS;
        }

        /** 
         * Get the 'fltOptLFSReuseLimitForAVS' element value.
         * 
         * @return value
         */
        public FltOptLFSReuseLimitForAVS getFltOptLFSReuseLimitForAVS() {
            return fltOptLFSReuseLimitForAVS;
        }

        /** 
         * Set the 'fltOptLFSReuseLimitForAVS' element value.
         * 
         * @param fltOptLFSReuseLimitForAVS
         */
        public void setFltOptLFSReuseLimitForAVS(
                FltOptLFSReuseLimitForAVS fltOptLFSReuseLimitForAVS) {
            this.fltOptLFSReuseLimitForAVS = fltOptLFSReuseLimitForAVS;
        }

        /** 
         * Get the 'avsPenaltyCrrs' element value.
         * 
         * @return value
         */
        public AvsPenaltyCrrs getAvsPenaltyCrrs() {
            return avsPenaltyCrrs;
        }

        /** 
         * Set the 'avsPenaltyCrrs' element value.
         * 
         * @param avsPenaltyCrrs
         */
        public void setAvsPenaltyCrrs(AvsPenaltyCrrs avsPenaltyCrrs) {
            this.avsPenaltyCrrs = avsPenaltyCrrs;
        }

        /** 
         * Get the 'maxNumOfNonStpOnlSol' element value.
         * 
         * @return value
         */
        public MaxNumOfNonStpOnlSol getMaxNumOfNonStpOnlSol() {
            return maxNumOfNonStpOnlSol;
        }

        /** 
         * Set the 'maxNumOfNonStpOnlSol' element value.
         * 
         * @param maxNumOfNonStpOnlSol
         */
        public void setMaxNumOfNonStpOnlSol(
                MaxNumOfNonStpOnlSol maxNumOfNonStpOnlSol) {
            this.maxNumOfNonStpOnlSol = maxNumOfNonStpOnlSol;
        }

        /** 
         * Get the 'maxNumOfNonStpInrlSol' element value.
         * 
         * @return value
         */
        public MaxNumOfNonStpInrlSol getMaxNumOfNonStpInrlSol() {
            return maxNumOfNonStpInrlSol;
        }

        /** 
         * Set the 'maxNumOfNonStpInrlSol' element value.
         * 
         * @param maxNumOfNonStpInrlSol
         */
        public void setMaxNumOfNonStpInrlSol(
                MaxNumOfNonStpInrlSol maxNumOfNonStpInrlSol) {
            this.maxNumOfNonStpInrlSol = maxNumOfNonStpInrlSol;
        }

        /** 
         * Get the 'maxNumOfSingleStpOnlSol' element value.
         * 
         * @return value
         */
        public MaxNumOfSingleStpOnlSol getMaxNumOfSingleStpOnlSol() {
            return maxNumOfSingleStpOnlSol;
        }

        /** 
         * Set the 'maxNumOfSingleStpOnlSol' element value.
         * 
         * @param maxNumOfSingleStpOnlSol
         */
        public void setMaxNumOfSingleStpOnlSol(
                MaxNumOfSingleStpOnlSol maxNumOfSingleStpOnlSol) {
            this.maxNumOfSingleStpOnlSol = maxNumOfSingleStpOnlSol;
        }

        /** 
         * Get the 'maxNumOf2PlusStpSol' element value.
         * 
         * @return value
         */
        public MaxNumOf2PlusStpSol getMaxNumOf2PlusStpSol() {
            return maxNumOf2PlusStpSol;
        }

        /** 
         * Set the 'maxNumOf2PlusStpSol' element value.
         * 
         * @param maxNumOf2PlusStpSol
         */
        public void setMaxNumOf2PlusStpSol(
                MaxNumOf2PlusStpSol maxNumOf2PlusStpSol) {
            this.maxNumOf2PlusStpSol = maxNumOf2PlusStpSol;
        }

        /** 
         * Get the 'minAllowedOveragePerCrrPercent' element value.
         * 
         * @return value
         */
        public MinAllowedOveragePerCrrPercent getMinAllowedOveragePerCrrPercent() {
            return minAllowedOveragePerCrrPercent;
        }

        /** 
         * Set the 'minAllowedOveragePerCrrPercent' element value.
         * 
         * @param minAllowedOveragePerCrrPercent
         */
        public void setMinAllowedOveragePerCrrPercent(
                MinAllowedOveragePerCrrPercent minAllowedOveragePerCrrPercent) {
            this.minAllowedOveragePerCrrPercent = minAllowedOveragePerCrrPercent;
        }

        /** 
         * Get the 'minAllowedOveragePerCrr' element value.
         * 
         * @return value
         */
        public MinAllowedOveragePerCrr getMinAllowedOveragePerCrr() {
            return minAllowedOveragePerCrr;
        }

        /** 
         * Set the 'minAllowedOveragePerCrr' element value.
         * 
         * @param minAllowedOveragePerCrr
         */
        public void setMinAllowedOveragePerCrr(
                MinAllowedOveragePerCrr minAllowedOveragePerCrr) {
            this.minAllowedOveragePerCrr = minAllowedOveragePerCrr;
        }

        /** 
         * Get the 'maxRelFareLvlOfxForNonStp' element value.
         * 
         * @return value
         */
        public MaxRelFareLvlOfxForNonStp getMaxRelFareLvlOfxForNonStp() {
            return maxRelFareLvlOfxForNonStp;
        }

        /** 
         * Set the 'maxRelFareLvlOfxForNonStp' element value.
         * 
         * @param maxRelFareLvlOfxForNonStp
         */
        public void setMaxRelFareLvlOfxForNonStp(
                MaxRelFareLvlOfxForNonStp maxRelFareLvlOfxForNonStp) {
            this.maxRelFareLvlOfxForNonStp = maxRelFareLvlOfxForNonStp;
        }

        /** 
         * Get the 'maxRelFareLvlOfxForCnx' element value.
         * 
         * @return value
         */
        public MaxRelFareLvlOfxForCnx getMaxRelFareLvlOfxForCnx() {
            return maxRelFareLvlOfxForCnx;
        }

        /** 
         * Set the 'maxRelFareLvlOfxForCnx' element value.
         * 
         * @param maxRelFareLvlOfxForCnx
         */
        public void setMaxRelFareLvlOfxForCnx(
                MaxRelFareLvlOfxForCnx maxRelFareLvlOfxForCnx) {
            this.maxRelFareLvlOfxForCnx = maxRelFareLvlOfxForCnx;
        }

        /** 
         * Get the 'numOfMustPrice2PlusStpSol' element value.
         * 
         * @return value
         */
        public NumOfMustPrice2PlusStpSol getNumOfMustPrice2PlusStpSol() {
            return numOfMustPrice2PlusStpSol;
        }

        /** 
         * Set the 'numOfMustPrice2PlusStpSol' element value.
         * 
         * @param numOfMustPrice2PlusStpSol
         */
        public void setNumOfMustPrice2PlusStpSol(
                NumOfMustPrice2PlusStpSol numOfMustPrice2PlusStpSol) {
            this.numOfMustPrice2PlusStpSol = numOfMustPrice2PlusStpSol;
        }

        /** 
         * Get the 'ItineraryNumberThreshold' element value.
         * 
         * @return value
         */
        public ItineraryNumberThreshold getItineraryNumberThreshold() {
            return itineraryNumberThreshold;
        }

        /** 
         * Set the 'ItineraryNumberThreshold' element value.
         * 
         * @param itineraryNumberThreshold
         */
        public void setItineraryNumberThreshold(
                ItineraryNumberThreshold itineraryNumberThreshold) {
            this.itineraryNumberThreshold = itineraryNumberThreshold;
        }

        /** 
         * Get the 'XOFares' element value.
         * 
         * @return value
         */
        public XOFaresType getXOFares() {
            return XOFares;
        }

        /** 
         * Set the 'XOFares' element value.
         * 
         * @param XOFares
         */
        public void setXOFares(XOFaresType XOFares) {
            this.XOFares = XOFares;
        }

        /** 
         * Get the 'TravelPreferencesTPA_ExtensionsTaxesGroup' group value.
         * 
         * @return value
         */
        public TravelPreferencesTPAExtensionsTaxesGroup getTravelPreferencesTPAExtensionsTaxesGroup() {
            return travelPreferencesTPAExtensionsTaxesGroup;
        }

        /** 
         * Set the 'TravelPreferencesTPA_ExtensionsTaxesGroup' group value.
         * 
         * @param travelPreferencesTPAExtensionsTaxesGroup
         */
        public void setTravelPreferencesTPAExtensionsTaxesGroup(
                TravelPreferencesTPAExtensionsTaxesGroup travelPreferencesTPAExtensionsTaxesGroup) {
            this.travelPreferencesTPAExtensionsTaxesGroup = travelPreferencesTPAExtensionsTaxesGroup;
        }

        /** 
         * Get the 'FlightStopsAsConnections' element value.
         * 
         * @return value
         */
        public FlightStopsAsConnectionsType getFlightStopsAsConnections() {
            return flightStopsAsConnections;
        }

        /** 
         * Set the 'FlightStopsAsConnections' element value.
         * 
         * @param flightStopsAsConnections
         */
        public void setFlightStopsAsConnections(
                FlightStopsAsConnectionsType flightStopsAsConnections) {
            this.flightStopsAsConnections = flightStopsAsConnections;
        }

        /** 
         * Get the 'TicketingSumOfLocals' element value.
         * 
         * @return value
         */
        public TicketingSumOfLocals getTicketingSumOfLocals() {
            return ticketingSumOfLocals;
        }

        /** 
         * Set the 'TicketingSumOfLocals' element value.
         * 
         * @param ticketingSumOfLocals
         */
        public void setTicketingSumOfLocals(
                TicketingSumOfLocals ticketingSumOfLocals) {
            this.ticketingSumOfLocals = ticketingSumOfLocals;
        }

        /** 
         * Get the 'MultiAirportCodes' element value.
         * 
         * @return value
         */
        public MultiAirportCodes getMultiAirportCodes() {
            return multiAirportCodes;
        }

        /** 
         * Set the 'MultiAirportCodes' element value.
         * 
         * @param multiAirportCodes
         */
        public void setMultiAirportCodes(MultiAirportCodes multiAirportCodes) {
            this.multiAirportCodes = multiAirportCodes;
        }

        /** 
         * Get the 'JumpCabinLogic' element value.
         * 
         * @return value
         */
        public JumpCabinLogicType getJumpCabinLogic() {
            return jumpCabinLogic;
        }

        /** 
         * Set the 'JumpCabinLogic' element value.
         * 
         * @param jumpCabinLogic
         */
        public void setJumpCabinLogic(JumpCabinLogicType jumpCabinLogic) {
            this.jumpCabinLogic = jumpCabinLogic;
        }

        /** 
         * Get the 'KeepSameCabin' element value.
         * 
         * @return value
         */
        public KeepSameCabinType getKeepSameCabin() {
            return keepSameCabin;
        }

        /** 
         * Set the 'KeepSameCabin' element value.
         * 
         * @param keepSameCabin
         */
        public void setKeepSameCabin(KeepSameCabinType keepSameCabin) {
            this.keepSameCabin = keepSameCabin;
        }

        /** 
         * Get the 'AvoidCabinDowngrade' element value.
         * 
         * @return value
         */
        public AvoidCabinDowngradeType getAvoidCabinDowngrade() {
            return avoidCabinDowngrade;
        }

        /** 
         * Set the 'AvoidCabinDowngrade' element value.
         * 
         * @param avoidCabinDowngrade
         */
        public void setAvoidCabinDowngrade(
                AvoidCabinDowngradeType avoidCabinDowngrade) {
            this.avoidCabinDowngrade = avoidCabinDowngrade;
        }

        /** 
         * Get the 'GoverningCarrierOverride' element value.
         * 
         * @return value
         */
        public GoverningCarrierOverrideType getGoverningCarrierOverride() {
            return governingCarrierOverride;
        }

        /** 
         * Set the 'GoverningCarrierOverride' element value.
         * 
         * @param governingCarrierOverride
         */
        public void setGoverningCarrierOverride(
                GoverningCarrierOverrideType governingCarrierOverride) {
            this.governingCarrierOverride = governingCarrierOverride;
        }

        /** 
         * Get the 'ExcludeCallDirectCarriers' element value.
         * 
         * @return value
         */
        public ExcludeCallDirectCarriers getExcludeCallDirectCarriers() {
            return excludeCallDirectCarriers;
        }

        /** 
         * Set the 'ExcludeCallDirectCarriers' element value.
         * 
         * @param excludeCallDirectCarriers
         */
        public void setExcludeCallDirectCarriers(
                ExcludeCallDirectCarriers excludeCallDirectCarriers) {
            this.excludeCallDirectCarriers = excludeCallDirectCarriers;
        }

        /** 
         * Get the 'ValidatingCarrier' element value.
         * 
         * @return value
         */
        public ValidatingCarrierType getValidatingCarrier() {
            return validatingCarrier;
        }

        /** 
         * Set the 'ValidatingCarrier' element value.
         * 
         * @param validatingCarrier
         */
        public void setValidatingCarrier(ValidatingCarrierType validatingCarrier) {
            this.validatingCarrier = validatingCarrier;
        }

        /** 
         * Get the 'ValidatingCarrierCheck' element value.
         * 
         * @return value
         */
        public ValidatingCarrierCheck getValidatingCarrierCheck() {
            return validatingCarrierCheck;
        }

        /** 
         * Set the 'ValidatingCarrierCheck' element value.
         * 
         * @param validatingCarrierCheck
         */
        public void setValidatingCarrierCheck(
                ValidatingCarrierCheck validatingCarrierCheck) {
            this.validatingCarrierCheck = validatingCarrierCheck;
        }

        /** 
         * Get the 'SettlementMethod' element value.
         * 
         * @return value
         */
        public String getSettlementMethod() {
            return settlementMethod;
        }

        /** 
         * Set the 'SettlementMethod' element value.
         * 
         * @param settlementMethod
         */
        public void setSettlementMethod(String settlementMethod) {
            this.settlementMethod = settlementMethod;
        }

        /** 
         * Get the 'FlightRepeatLimit' element value.
         * 
         * @return value
         */
        public FlightRepeatLimit getFlightRepeatLimit() {
            return flightRepeatLimit;
        }

        /** 
         * Set the 'FlightRepeatLimit' element value.
         * 
         * @param flightRepeatLimit
         */
        public void setFlightRepeatLimit(FlightRepeatLimit flightRepeatLimit) {
            this.flightRepeatLimit = flightRepeatLimit;
        }

        /** 
         * Get the 'SeatSelection' element value.
         * 
         * @return value
         */
        public FreeSeatSelectionAndInfoType getSeatSelection() {
            return seatSelection;
        }

        /** 
         * Set the 'SeatSelection' element value.
         * 
         * @param seatSelection
         */
        public void setSeatSelection(FreeSeatSelectionAndInfoType seatSelection) {
            this.seatSelection = seatSelection;
        }

        /** 
         * Get the 'PriorityBoarding' element value.
         * 
         * @return value
         */
        public FreePriorityBoardingAndInfoType getPriorityBoarding() {
            return priorityBoarding;
        }

        /** 
         * Set the 'PriorityBoarding' element value.
         * 
         * @param priorityBoarding
         */
        public void setPriorityBoarding(
                FreePriorityBoardingAndInfoType priorityBoarding) {
            this.priorityBoarding = priorityBoarding;
        }

        /** 
         * Get the 'FlexibleFares' element value.
         * 
         * @return value
         */
        public FlexibleFaresType getFlexibleFares() {
            return flexibleFares;
        }

        /** 
         * Set the 'FlexibleFares' element value.
         * 
         * @param flexibleFares
         */
        public void setFlexibleFares(FlexibleFaresType flexibleFares) {
            this.flexibleFares = flexibleFares;
        }

        /** 
         * Get the 'DiversityParameters' element value.
         * 
         * @return value
         */
        public DiversityParameters getDiversityParameters() {
            return diversityParameters;
        }

        /** 
         * Set the 'DiversityParameters' element value.
         * 
         * @param diversityParameters
         */
        public void setDiversityParameters(
                DiversityParameters diversityParameters) {
            this.diversityParameters = diversityParameters;
        }

        /** 
         * Get the 'AdditionalFareLimit' element value.
         * 
         * @return value
         */
        public AdditionalFareLimit getAdditionalFareLimit() {
            return additionalFareLimit;
        }

        /** 
         * Set the 'AdditionalFareLimit' element value.
         * 
         * @param additionalFareLimit
         */
        public void setAdditionalFareLimit(
                AdditionalFareLimit additionalFareLimit) {
            this.additionalFareLimit = additionalFareLimit;
        }

        /** 
         * Get the 'FareFocusRules' element value.
         * 
         * @return value
         */
        public FareFocusRules getFareFocusRules() {
            return fareFocusRules;
        }

        /** 
         * Set the 'FareFocusRules' element value.
         * 
         * @param fareFocusRules
         */
        public void setFareFocusRules(FareFocusRules fareFocusRules) {
            this.fareFocusRules = fareFocusRules;
        }

        /** 
         * Get the 'SellingLevels' element value.
         * 
         * @return value
         */
        public SellingLevels getSellingLevels() {
            return sellingLevels;
        }

        /** 
         * Set the 'SellingLevels' element value.
         * 
         * @param sellingLevels
         */
        public void setSellingLevels(SellingLevels sellingLevels) {
            this.sellingLevels = sellingLevels;
        }

        /** 
         * Get the 'Budget' element value.
         * 
         * @return value
         */
        public Budget getBudget() {
            return budget;
        }

        /** 
         * Set the 'Budget' element value.
         * 
         * @param budget
         */
        public void setBudget(Budget budget) {
            this.budget = budget;
        }

        /** 
         * Get the 'OptionsPerDatePairList' element value.
         * 
         * @return value
         */
        public OptionsPerDatePairList getOptionsPerDatePairList() {
            return optionsPerDatePairList;
        }

        /** 
         * Set the 'OptionsPerDatePairList' element value.
         * 
         * @param optionsPerDatePairList
         */
        public void setOptionsPerDatePairList(
                OptionsPerDatePairList optionsPerDatePairList) {
            this.optionsPerDatePairList = optionsPerDatePairList;
        }

        /** 
         * Get the list of 'CountryPref' element items.
         * 
         * @return list
         */
        public List<CountryPref> getCountryPrefList() {
            return countryPrefList;
        }

        /** 
         * Set the list of 'CountryPref' element items.
         * 
         * @param list
         */
        public void setCountryPrefList(List<CountryPref> list) {
            countryPrefList = list;
        }

        /** 
         * Get the 'RetailerRules' element value.
         * 
         * @return value
         */
        public RetailerRulesType getRetailerRules() {
            return retailerRules;
        }

        /** 
         * Set the 'RetailerRules' element value.
         * 
         * @param retailerRules
         */
        public void setRetailerRules(RetailerRulesType retailerRules) {
            this.retailerRules = retailerRules;
        }

        /** 
         * Get the 'ForceKeywordRestrictedContent' element value.
         * 
         * @return value
         */
        public ForceKeywordRestrictedContent getForceKeywordRestrictedContent() {
            return forceKeywordRestrictedContent;
        }

        /** 
         * Set the 'ForceKeywordRestrictedContent' element value.
         * 
         * @param forceKeywordRestrictedContent
         */
        public void setForceKeywordRestrictedContent(
                ForceKeywordRestrictedContent forceKeywordRestrictedContent) {
            this.forceKeywordRestrictedContent = forceKeywordRestrictedContent;
        }

        /** 
         * Get the 'FlightRestrictions' element value.
         * 
         * @return value
         */
        public FlightRestrictions getFlightRestrictions() {
            return flightRestrictions;
        }

        /** 
         * Set the 'FlightRestrictions' element value.
         * 
         * @param flightRestrictions
         */
        public void setFlightRestrictions(FlightRestrictions flightRestrictions) {
            this.flightRestrictions = flightRestrictions;
        }

        private void setChoiceSelect(int choice) {
            if (choiceSelect == -1) {
                choiceSelect = choice;
            } else if (choiceSelect != choice) {
                throw new IllegalStateException(
                        "Need to call clearChoiceSelect() before changing existing choice");
            }
        }

        /** 
         * Clear the choice selection.
         */
        public void clearChoiceSelect() {
            choiceSelect = -1;
        }

        /** 
         * Check if LowCostCarriersProcessing is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifLowCostCarriersProcessing() {
            return choiceSelect == LOW_COST_CARRIERS_PROCESSING_CHOICE;
        }

        /** 
         * Get the 'LowCostCarriersProcessing' element value.
         * 
         * @return value
         */
        public LowCostCarriersProcessing getLowCostCarriersProcessing() {
            return lowCostCarriersProcessing;
        }

        /** 
         * Set the 'LowCostCarriersProcessing' element value.
         * 
         * @param lowCostCarriersProcessing
         */
        public void setLowCostCarriersProcessing(
                LowCostCarriersProcessing lowCostCarriersProcessing) {
            setChoiceSelect(LOW_COST_CARRIERS_PROCESSING_CHOICE);
            this.lowCostCarriersProcessing = lowCostCarriersProcessing;
        }

        /** 
         * Check if DataSources is current selection for choice.
         * 
         * @return <code>true</code> if selection, <code>false</code> if not
         */
        public boolean ifDataSources() {
            return choiceSelect == DATA_SOURCES_CHOICE;
        }

        /** 
         * Get the 'DataSources' element value.
         * 
         * @return value
         */
        public DataSources getDataSources() {
            return dataSources;
        }

        /** 
         * Set the 'DataSources' element value.
         * 
         * @param dataSources
         */
        public void setDataSources(DataSources dataSources) {
            setChoiceSelect(DATA_SOURCES_CHOICE);
            this.dataSources = dataSources;
        }

        /** 
         * Get the 'VerificationItinCallLogic' element value.
         * 
         * @return value
         */
        public VerificationItinCallLogic getVerificationItinCallLogic() {
            return verificationItinCallLogic;
        }

        /** 
         * Set the 'VerificationItinCallLogic' element value.
         * 
         * @param verificationItinCallLogic
         */
        public void setVerificationItinCallLogic(
                VerificationItinCallLogic verificationItinCallLogic) {
            this.verificationItinCallLogic = verificationItinCallLogic;
        }

        /** 
         * Get the list of 'ClassOfService' element items. Requested booking code for whole main fare
         * 
         * @return list
         */
        public List<ClassOfServiceElemType> getClassOfServiceList() {
            return classOfServiceList;
        }

        /** 
         * Set the list of 'ClassOfService' element items. Requested booking code for whole main fare
         * 
         * @param list
         */
        public void setClassOfServiceList(List<ClassOfServiceElemType> list) {
            classOfServiceList = list;
        }

        /** 
         * Get the list of 'FareBasis' element items. Fare Basis Codes requested for whole main fare
         * 
         * @return list
         */
        public List<FareBasisType> getFareBasiList() {
            return fareBasiList;
        }

        /** 
         * Set the list of 'FareBasis' element items. Fare Basis Codes requested for whole main fare
         * 
         * @param list
         */
        public void setFareBasiList(List<FareBasisType> list) {
            fareBasiList = list;
        }

        /** 
         * Get the list of 'FareType' element items. Defines preferred or excluded fare type codes for whole main fare.
         * 
         * @return list
         */
        public List<FareTypePrefType> getFareTypeList() {
            return fareTypeList;
        }

        /** 
         * Set the list of 'FareType' element items. Defines preferred or excluded fare type codes for whole main fare.
         * 
         * @param list
         */
        public void setFareTypeList(List<FareTypePrefType> list) {
            fareTypeList = list;
        }

        /** 
         * Get the 'PreferNDCSourceOnTie' element value.
         * 
         * @return value
         */
        public PreferNDCSourceOnTie getPreferNDCSourceOnTie() {
            return preferNDCSourceOnTie;
        }

        /** 
         * Set the 'PreferNDCSourceOnTie' element value.
         * 
         * @param preferNDCSourceOnTie
         */
        public void setPreferNDCSourceOnTie(
                PreferNDCSourceOnTie preferNDCSourceOnTie) {
            this.preferNDCSourceOnTie = preferNDCSourceOnTie;
        }

        /** 
         * Get the 'NDCIndicators' element value.
         * 
         * @return value
         */
        public NDCIndicators getNDCIndicators1() {
            return NDCIndicators1;
        }

        /** 
         * Set the 'NDCIndicators' element value.
         * 
         * @param NDCIndicators1
         */
        public void setNDCIndicators1(NDCIndicators NDCIndicators1) {
            this.NDCIndicators1 = NDCIndicators1;
        }

        /** 
         * Get the 'Seats' element value. Optional seat comfort seats filter.
         * 
         * @return value
         */
        public SeatComfortPrefType getSeats() {
            return seats;
        }

        /** 
         * Set the 'Seats' element value. Optional seat comfort seats filter.
         * 
         * @param seats
         */
        public void setSeats(SeatComfortPrefType seats) {
            this.seats = seats;
        }
        /** 
         * This element allows a user to exclude certain carriers from the search.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExcludeVendorPref" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ExcludeVendorPref implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value. Identifies a company by the company code.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Identifies a company by the company code.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
        /** 
         * This element allows a user to specify the number of itineraries with special routing returned.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NumTripsWithRouting" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="optional" default="5" name="Number"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NumTripsWithRouting implements Serializable
        {
            private Short number;

            /** 
             * Get the 'Number' attribute value.
             * 
             * @return value
             */
            public Short getNumber() {
                return number;
            }

            /** 
             * Set the 'Number' attribute value.
             * 
             * @param number
             */
            public void setNumber(Short number) {
                this.number = number;
            }
        }
        /** 
         * Maximum price returned from LFE service.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaxPrice" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:decimal" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MaxPrice implements Serializable
        {
            private BigDecimal value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public BigDecimal getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(BigDecimal value) {
                this.value = value;
            }
        }
        /** 
         * Restrict content type returned by LFE service.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ContentType" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute name="Type">
         *       &lt;xs:simpleType>
         *         &lt;!-- Reference to inner class Type -->
         *       &lt;/xs:simpleType>
         *     &lt;/xs:attribute>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ContentType implements Serializable
        {
            private Type type;

            /** 
             * Get the 'Type' attribute value.
             * 
             * @return value
             */
            public Type getType() {
                return type;
            }

            /** 
             * Set the 'Type' attribute value.
             * 
             * @param type
             */
            public void setType(Type type) {
                this.type = type;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
             *   &lt;xs:restriction base="xs:string">
             *     &lt;xs:enumeration value="Air"/>
             *     &lt;xs:enumeration value="Rail"/>
             *   &lt;/xs:restriction>
             * &lt;/xs:simpleType>
             * </pre>
             */
            public static enum Type implements Serializable {
                AIR("Air"), RAIL("Rail");
                private final String value;

                private Type(String value) {
                    this.value = value;
                }

                public String xmlValue() {
                    return value;
                }

                public static Type convert(String value) {
                    for (Type inst : values()) {
                        if (inst.xmlValue().equals(value)) {
                            return inst;
                        }
                    }
                    return null;
                }
            }
        }
        /** 
         * Domestic maximum connecting hours.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DomesticLayoverTime" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Hours"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DomesticLayoverTime implements Serializable
        {
            private short hours;

            /** 
             * Get the 'Hours' attribute value.
             * 
             * @return value
             */
            public short getHours() {
                return hours;
            }

            /** 
             * Set the 'Hours' attribute value.
             * 
             * @param hours
             */
            public void setHours(short hours) {
                this.hours = hours;
            }
        }
        /** 
         * Change minimum and maximum connect time per connection in long connection schedules, specify number or percentage of requested solutions if Long Connect Time logic is enabled. Time values should be less than 1440 minutes (24 hours). If percentage is specified, % symbol should be added after the number, otherwise exact number of solutions should be provided.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LongConnectTime" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" name="Min"/>
         *     &lt;xs:attribute type="xs:short" name="Max"/>
         *     &lt;xs:attribute type="xs:boolean" name="Enable"/>
         *     &lt;xs:attribute type="xs:string" name="NumberOfSolutions"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LongConnectTime implements Serializable
        {
            private Short min;
            private Short max;
            private Boolean enable;
            private String numberOfSolutions;

            /** 
             * Get the 'Min' attribute value.
             * 
             * @return value
             */
            public Short getMin() {
                return min;
            }

            /** 
             * Set the 'Min' attribute value.
             * 
             * @param min
             */
            public void setMin(Short min) {
                this.min = min;
            }

            /** 
             * Get the 'Max' attribute value.
             * 
             * @return value
             */
            public Short getMax() {
                return max;
            }

            /** 
             * Set the 'Max' attribute value.
             * 
             * @param max
             */
            public void setMax(Short max) {
                this.max = max;
            }

            /** 
             * Get the 'Enable' attribute value.
             * 
             * @return value
             */
            public Boolean getEnable() {
                return enable;
            }

            /** 
             * Set the 'Enable' attribute value.
             * 
             * @param enable
             */
            public void setEnable(Boolean enable) {
                this.enable = enable;
            }

            /** 
             * Get the 'NumberOfSolutions' attribute value.
             * 
             * @return value
             */
            public String getNumberOfSolutions() {
                return numberOfSolutions;
            }

            /** 
             * Set the 'NumberOfSolutions' attribute value.
             * 
             * @param numberOfSolutions
             */
            public void setNumberOfSolutions(String numberOfSolutions) {
                this.numberOfSolutions = numberOfSolutions;
            }
        }
        /** 
         * Minimum and maximum number of connection points (not necessarily long) for Long Connections.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LongConnectPoints" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" name="Min"/>
         *     &lt;xs:attribute type="xs:short" name="Max"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LongConnectPoints implements Serializable
        {
            private Short min;
            private Short max;

            /** 
             * Get the 'Min' attribute value.
             * 
             * @return value
             */
            public Short getMin() {
                return min;
            }

            /** 
             * Set the 'Min' attribute value.
             * 
             * @param min
             */
            public void setMin(Short min) {
                this.min = min;
            }

            /** 
             * Get the 'Max' attribute value.
             * 
             * @return value
             */
            public Short getMax() {
                return max;
            }

            /** 
             * Set the 'Max' attribute value.
             * 
             * @param max
             */
            public void setMax(Short max) {
                this.max = max;
            }
        }
        /** 
         * Return air service only.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AirServiceOnly" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AirServiceOnly implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Return jet service only.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="JetServiceOnly" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class JetServiceOnly implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Same airport at connection point restriction
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SameConnectionAirportOnly" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SameConnectionAirportOnly implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Same airport at origin point restriction
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SameOriginAirportOnly" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SameOriginAirportOnly implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Same airport at turnaround point restriction
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SameTurnaroundAirportOnly" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SameTurnaroundAirportOnly implements Serializable
        {
            private boolean ind;

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isInd() {
                return ind;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param ind
             */
            public void setInd(boolean ind) {
                this.ind = ind;
            }
        }
        /** 
         * Aircraft type penalty (in dollars). Used to penalize propeller aircraft type in the response.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AircraftTypePenalty" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AircraftTypePenalty implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Alternate airport penalty (in dollars). Used to penalize options with alternate airports.
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AlternateAirportPenalty" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AlternateAirportPenalty implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * % ESV value above the lowest itinerary
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareAmountThreshold" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareAmountThreshold implements Serializable
        {
            private Float value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Float getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Float value) {
                this.value = value;
            }
        }
        /** 
         * Number of low fare solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="numOfLowFareSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NumOfLowFareSol implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Number of must price online solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="numOfMustPriceOnlSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NumOfMustPriceOnlSol implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Number of must price interline solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="numOfMustPriceInrlSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NumOfMustPriceInrlSol implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Number of must price non-stop online solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="numOfMustPriceNStpOnlSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NumOfMustPriceNStpOnlSol implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Number of must price non-stop interline solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="numOfMustPriceNStpInrlSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NumOfMustPriceNStpInrlSol implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Number of must price single stop online solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="numOfMustPriceSStopOnlSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NumOfMustPriceSStopOnlSol implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Stop penalty in dollars for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="stpPenaltyInUSD" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class StpPenaltyInUSD implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Duration penalty in dollars for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="durPenaltyInUSD" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DurPenaltyInUSD implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Departure penalty in dollars for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="depPenaltyInUSD" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DepPenaltyInUSD implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Max allowed must price overage per carrier for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="maxAllowedMustPriceOveragePerCrr" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MaxAllowedMustPriceOveragePerCrr implements
            Serializable
        {
            private Float value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Float getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Float value) {
                this.value = value;
            }
        }
        /** 
         * Flight option reuse limit (must price) for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="fltOptMustPriceReuseLimit" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FltOptMustPriceReuseLimit implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Upper bound factor for not non-stops (must price) for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="upperBoundMustPriceFactorForNotNonStp" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UpperBoundMustPriceFactorForNotNonStp implements
            Serializable
        {
            private Float value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Float getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Float value) {
                this.value = value;
            }
        }
        /** 
         * Low fare search upper bound factor for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="upperBoundLFSFactor" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UpperBoundLFSFactor implements Serializable
        {
            private Float value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Float getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Float value) {
                this.value = value;
            }
        }
        /** 
         * Number of must price non-stop/one-stop online solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="numOfMustPriceNStp1StpOnlSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NumOfMustPriceNStp1StpOnlSol implements
            Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Number of must price non-stop/one-stop interline solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="numOfMustPriceNStp1StpInrlSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NumOfMustPriceNStp1StpInrlSol implements
            Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Upper bound factor for non-stops (must price) for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="upperBoundMustPriceFactorForNonStp" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class UpperBoundMustPriceFactorForNonStp implements
            Serializable
        {
            private Float value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Float getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Float value) {
                this.value = value;
            }
        }
        /** 
         * Low fare search max allowed overage per carrier % for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="maxAllowedLFSOveragePerCrrPercent" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MaxAllowedLFSOveragePerCrrPercent implements
            Serializable
        {
            private Float value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Float getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Float value) {
                this.value = value;
            }
        }
        /** 
         * Low fare search target minimum number of online solutions per carrier for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="targetMinNumOfLFSOnlSolPerCrr" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TargetMinNumOfLFSOnlSolPerCrr implements
            Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Low fare search target minimum number of total online solutions % for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="targetMinNumOfLFSTotOnlSolPercent" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TargetMinNumOfLFSTotOnlSolPercent implements
            Serializable
        {
            private Float value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Float getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Float value) {
                this.value = value;
            }
        }
        /** 
         * Low fare search flight option reuse limit for non AVS for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="fltOptLFSReuseLimitForNonAVS" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FltOptLFSReuseLimitForNonAVS implements
            Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Low fare search flight option reuse limit for AVS for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="fltOptLFSReuseLimitForAVS" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FltOptLFSReuseLimitForAVS implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * AVS penalty carrier list (| delimited) for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="avsPenaltyCrrs" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AvsPenaltyCrrs implements Serializable
        {
            private String value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public String getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(String value) {
                this.value = value;
            }
        }
        /** 
         * Max number of nonstop online solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="maxNumOfNonStpOnlSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MaxNumOfNonStpOnlSol implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Max number of nonstop interline solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="maxNumOfNonStpInrlSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MaxNumOfNonStpInrlSol implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Max number of single stop online solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="maxNumOfSingleStpOnlSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MaxNumOfSingleStpOnlSol implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Max number of 2+ stops solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="maxNumOf2PlusStpSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MaxNumOf2PlusStpSol implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Min allowed overage per carrier % for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="minAllowedOveragePerCrrPercent" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MinAllowedOveragePerCrrPercent implements
            Serializable
        {
            private Float value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Float getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Float value) {
                this.value = value;
            }
        }
        /** 
         * Min allowed overage per carrier for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="minAllowedOveragePerCrr" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MinAllowedOveragePerCrr implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Max relative fare level of x for nonstops for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="maxRelFareLvlOfxForNonStp" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MaxRelFareLvlOfxForNonStp implements Serializable
        {
            private Float value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Float getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Float value) {
                this.value = value;
            }
        }
        /** 
         * Max relative fare level of x for carrier for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="maxRelFareLvlOfxForCnx" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MaxRelFareLvlOfxForCnx implements Serializable
        {
            private Float value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Float getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Float value) {
                this.value = value;
            }
        }
        /** 
         * Number of must price 2+ stops solutions for ESV2
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="numOfMustPrice2PlusStpSol" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:short" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NumOfMustPrice2PlusStpSol implements Serializable
        {
            private short value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public short getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(short value) {
                this.value = value;
            }
        }
        /** 
         * Number of preffered/good itins to price
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ItineraryNumberThreshold" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:float" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ItineraryNumberThreshold implements Serializable
        {
            private Float value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public Float getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(Float value) {
                this.value = value;
            }
        }
        /** 
         * Settings specific to Ticketing Sum of Locals processing
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TicketingSumOfLocals" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="Enable"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class TicketingSumOfLocals implements Serializable
        {
            private Boolean enable;

            /** 
             * Get the 'Enable' attribute value. Enable Ticketing Sum of Locals processing.
             * 
             * @return value
             */
            public Boolean getEnable() {
                return enable;
            }

            /** 
             * Set the 'Enable' attribute value. Enable Ticketing Sum of Locals processing.
             * 
             * @param enable
             */
            public void setEnable(Boolean enable) {
                this.enable = enable;
            }
        }
        /** 
         * Settings specific to Multi Airport Codes processing
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultiAirportCodes" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" default="false" name="EnableOpenJaw"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class MultiAirportCodes implements Serializable
        {
            private Boolean enableOpenJaw;

            /** 
             * Get the 'EnableOpenJaw' attribute value. Enable open jaw leg combinations.
             * 
             * @return value
             */
            public Boolean getEnableOpenJaw() {
                return enableOpenJaw;
            }

            /** 
             * Set the 'EnableOpenJaw' attribute value. Enable open jaw leg combinations.
             * 
             * @param enableOpenJaw
             */
            public void setEnableOpenJaw(Boolean enableOpenJaw) {
                this.enableOpenJaw = enableOpenJaw;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExcludeCallDirectCarriers" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" name="Enabled"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ExcludeCallDirectCarriers implements Serializable
        {
            private Boolean enabled;

            /** 
             * Get the 'Enabled' attribute value. Force DSF to return schedules only for carriers bookable by Sabre.
             * 
             * @return value
             */
            public Boolean getEnabled() {
                return enabled;
            }

            /** 
             * Set the 'Enabled' attribute value. Force DSF to return schedules only for carriers bookable by Sabre.
             * 
             * @param enabled
             */
            public void setEnabled(Boolean enabled) {
                this.enabled = enabled;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ValidatingCarrierCheck" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SettlementValidation">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="IETValidation">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:boolean" use="required" name="Ind"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="Carrier" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Carrier -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="Country" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class Country -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ValidatingCarrierCheck implements Serializable
        {
            private boolean settlementValidation;
            private boolean IETValidation;
            private List<Carrier> carrierList = new ArrayList<Carrier>();
            private List<Country> countryList = new ArrayList<Country>();

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isSettlementValidation() {
                return settlementValidation;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param settlementValidation
             */
            public void setSettlementValidation(boolean settlementValidation) {
                this.settlementValidation = settlementValidation;
            }

            /** 
             * Get the 'Ind' attribute value.
             * 
             * @return value
             */
            public boolean isIETValidation() {
                return IETValidation;
            }

            /** 
             * Set the 'Ind' attribute value.
             * 
             * @param IETValidation
             */
            public void setIETValidation(boolean IETValidation) {
                this.IETValidation = IETValidation;
            }

            /** 
             * Get the list of 'Carrier' element items.
             * 
             * @return list
             */
            public List<Carrier> getCarrierList() {
                return carrierList;
            }

            /** 
             * Set the list of 'Carrier' element items.
             * 
             * @param list
             */
            public void setCarrierList(List<Carrier> list) {
                carrierList = list;
            }

            /** 
             * Get the list of 'Country' element items.
             * 
             * @return list
             */
            public List<Country> getCountryList() {
                return countryList;
            }

            /** 
             * Set the list of 'Country' element items.
             * 
             * @param list
             */
            public void setCountryList(List<Country> list) {
                countryList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Carrier" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Carrier implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Country" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Country implements Serializable
            {
                private String code;

                /** 
                 * Get the 'Code' attribute value.
                 * 
                 * @return value
                 */
                public String getCode() {
                    return code;
                }

                /** 
                 * Set the 'Code' attribute value.
                 * 
                 * @param code
                 */
                public void setCode(String code) {
                    this.code = code;
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightRepeatLimit" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:unsignedShort" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightRepeatLimit implements Serializable
        {
            private String value;

            /** 
             * Get the 'Value' attribute value. Flight Repeat Limit for DSF. Expected value 1-100.
             * 
             * @return value
             */
            public String getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value. Flight Repeat Limit for DSF. Expected value 1-100.
             * 
             * @param value
             */
            public void setValue(String value) {
                this.value = value;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiversityParameters" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Weightings" minOccurs="0">
         *         &lt;!-- Reference to inner class Weightings -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="TimeOfDayDistribution" minOccurs="0">
         *         &lt;!-- Reference to inner class TimeOfDayDistribution -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="xs:unsignedShort" name="InboundOutboundPairing"/>
         *     &lt;xs:attribute type="xs:unsignedShort" name="AdditionalNonStopsNumber"/>
         *     &lt;xs:attribute type="xs:unsignedShort" name="AdditionalNonStopsPercentage"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DiversityParameters implements Serializable
        {
            private Weightings weightings;
            private TimeOfDayDistribution timeOfDayDistribution;
            private String inboundOutboundPairing;
            private String additionalNonStopsNumber;
            private String additionalNonStopsPercentage;

            /** 
             * Get the 'Weightings' element value.
             * 
             * @return value
             */
            public Weightings getWeightings() {
                return weightings;
            }

            /** 
             * Set the 'Weightings' element value.
             * 
             * @param weightings
             */
            public void setWeightings(Weightings weightings) {
                this.weightings = weightings;
            }

            /** 
             * Get the 'TimeOfDayDistribution' element value.
             * 
             * @return value
             */
            public TimeOfDayDistribution getTimeOfDayDistribution() {
                return timeOfDayDistribution;
            }

            /** 
             * Set the 'TimeOfDayDistribution' element value.
             * 
             * @param timeOfDayDistribution
             */
            public void setTimeOfDayDistribution(
                    TimeOfDayDistribution timeOfDayDistribution) {
                this.timeOfDayDistribution = timeOfDayDistribution;
            }

            /** 
             * Get the 'InboundOutboundPairing' attribute value. Defines the requested ratio of inbounds to outbounds in the response.
             * 
             * @return value
             */
            public String getInboundOutboundPairing() {
                return inboundOutboundPairing;
            }

            /** 
             * Set the 'InboundOutboundPairing' attribute value. Defines the requested ratio of inbounds to outbounds in the response.
             * 
             * @param inboundOutboundPairing
             */
            public void setInboundOutboundPairing(String inboundOutboundPairing) {
                this.inboundOutboundPairing = inboundOutboundPairing;
            }

            /** 
             * Get the 'AdditionalNonStopsNumber' attribute value. Defines how many additional non-stop options should be added to the response. Overrides @Percentage.
             * 
             * @return value
             */
            public String getAdditionalNonStopsNumber() {
                return additionalNonStopsNumber;
            }

            /** 
             * Set the 'AdditionalNonStopsNumber' attribute value. Defines how many additional non-stop options should be added to the response. Overrides @Percentage.
             * 
             * @param additionalNonStopsNumber
             */
            public void setAdditionalNonStopsNumber(
                    String additionalNonStopsNumber) {
                this.additionalNonStopsNumber = additionalNonStopsNumber;
            }

            /** 
             * Get the 'AdditionalNonStopsPercentage' attribute value. Defines how many additional non-stop options should be added to the response as a percentage of the requested number of options.
             * 
             * @return value
             */
            public String getAdditionalNonStopsPercentage() {
                return additionalNonStopsPercentage;
            }

            /** 
             * Set the 'AdditionalNonStopsPercentage' attribute value. Defines how many additional non-stop options should be added to the response as a percentage of the requested number of options.
             * 
             * @param additionalNonStopsPercentage
             */
            public void setAdditionalNonStopsPercentage(
                    String additionalNonStopsPercentage) {
                this.additionalNonStopsPercentage = additionalNonStopsPercentage;
            }
            /** 
             * Defines how important various parameter options are in the response. Sum of all weightings needs to equal 10.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Weightings" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:unsignedShort" use="required" name="PriceWeight"/>
             *     &lt;xs:attribute type="xs:unsignedShort" use="required" name="TravelTimeWeight"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Weightings implements Serializable
            {
                private String priceWeight;
                private String travelTimeWeight;

                /** 
                 * Get the 'PriceWeight' attribute value. Defines how important price options are on a scale from 0 to 10.
                 * 
                 * @return value
                 */
                public String getPriceWeight() {
                    return priceWeight;
                }

                /** 
                 * Set the 'PriceWeight' attribute value. Defines how important price options are on a scale from 0 to 10.
                 * 
                 * @param priceWeight
                 */
                public void setPriceWeight(String priceWeight) {
                    this.priceWeight = priceWeight;
                }

                /** 
                 * Get the 'TravelTimeWeight' attribute value. Defines how important travel time options are on a scale from 0 to 10.
                 * 
                 * @return value
                 */
                public String getTravelTimeWeight() {
                    return travelTimeWeight;
                }

                /** 
                 * Set the 'TravelTimeWeight' attribute value. Defines how important travel time options are on a scale from 0 to 10.
                 * 
                 * @param travelTimeWeight
                 */
                public void setTravelTimeWeight(String travelTimeWeight) {
                    this.travelTimeWeight = travelTimeWeight;
                }
            }
            /** 
             * Defines how the options in the response should be distributed between certain departure time of day ranges. All defined TimeOfDayRanges need to cover the whole day and the sum of all Percentages needs to equal 100.
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeOfDayDistribution" minOccurs="0">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence>
             *       &lt;xs:element name="TimeOfDayRange" minOccurs="2" maxOccurs="4">
             *         &lt;!-- Reference to inner class TimeOfDayRange -->
             *       &lt;/xs:element>
             *     &lt;/xs:sequence>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class TimeOfDayDistribution implements Serializable
            {
                private List<TimeOfDayRange> timeOfDayRangeList = new ArrayList<TimeOfDayRange>();

                /** 
                 * Get the list of 'TimeOfDayRange' element items.
                 * 
                 * @return list
                 */
                public List<TimeOfDayRange> getTimeOfDayRangeList() {
                    return timeOfDayRangeList;
                }

                /** 
                 * Set the list of 'TimeOfDayRange' element items.
                 * 
                 * @param list
                 */
                public void setTimeOfDayRangeList(List<TimeOfDayRange> list) {
                    timeOfDayRangeList = list;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeOfDayRange" minOccurs="2" maxOccurs="4">
                 *   &lt;xs:complexType>
                 *     &lt;xs:attribute type="xs:string" use="required" name="Begin"/>
                 *     &lt;xs:attribute type="xs:string" use="required" name="End"/>
                 *     &lt;xs:attribute type="xs:unsignedShort" use="required" name="Percentage"/>
                 *   &lt;/xs:complexType>
                 * &lt;/xs:element>
                 * </pre>
                 */
                public static class TimeOfDayRange implements Serializable
                {
                    private String begin;
                    private String end;
                    private String percentage;

                    /** 
                     * Get the 'Begin' attribute value. Beginning of the TimeOfDayRange in HHMM format.
                     * 
                     * @return value
                     */
                    public String getBegin() {
                        return begin;
                    }

                    /** 
                     * Set the 'Begin' attribute value. Beginning of the TimeOfDayRange in HHMM format.
                     * 
                     * @param begin
                     */
                    public void setBegin(String begin) {
                        this.begin = begin;
                    }

                    /** 
                     * Get the 'End' attribute value. End of the TimeOfDayRange in HHMM format.
                     * 
                     * @return value
                     */
                    public String getEnd() {
                        return end;
                    }

                    /** 
                     * Set the 'End' attribute value. End of the TimeOfDayRange in HHMM format.
                     * 
                     * @param end
                     */
                    public void setEnd(String end) {
                        this.end = end;
                    }

                    /** 
                     * Get the 'Percentage' attribute value. Defines how many percent options should be in the TimeOfDayRange.
                     * 
                     * @return value
                     */
                    public String getPercentage() {
                        return percentage;
                    }

                    /** 
                     * Set the 'Percentage' attribute value. Defines how many percent options should be in the TimeOfDayRange.
                     * 
                     * @param percentage
                     */
                    public void setPercentage(String percentage) {
                        this.percentage = percentage;
                    }
                }
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AdditionalFareLimit" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:unsignedInt" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AdditionalFareLimit implements Serializable
        {
            private String value;

            /** 
             * Get the 'Value' attribute value. Additional fare limit.
             * 
             * @return value
             */
            public String getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value. Additional fare limit.
             * 
             * @param value
             */
            public void setValue(String value) {
                this.value = value;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FareFocusRules" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Exclude"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FareFocusRules implements Serializable
        {
            private Boolean exclude;

            /** 
             * Get the 'Exclude' attribute value. Exclude fare focus rules.
             * 
             * @return value
             */
            public Boolean getExclude() {
                return exclude;
            }

            /** 
             * Set the 'Exclude' attribute value. Exclude fare focus rules.
             * 
             * @param exclude
             */
            public void setExclude(Boolean exclude) {
                this.exclude = exclude;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SellingLevels" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:choice>
         *       &lt;xs:element name="SellingLevelRules">
         *         &lt;xs:complexType>
         *           &lt;xs:attribute type="xs:boolean" use="required" name="Ignore"/>
         *         &lt;/xs:complexType>
         *       &lt;/xs:element>
         *       &lt;xs:element name="ShowFareAmounts">
         *         &lt;!-- Reference to inner class ShowFareAmounts -->
         *       &lt;/xs:element>
         *     &lt;/xs:choice>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class SellingLevels implements Serializable
        {
            private int sellingLevelsSelect = -1;
            private static final int SELLING_LEVEL_RULES_CHOICE = 0;
            private static final int SHOW_FARE_AMOUNTS_CHOICE = 1;
            private boolean sellingLevelRules;
            private ShowFareAmounts showFareAmounts;

            private void setSellingLevelsSelect(int choice) {
                if (sellingLevelsSelect == -1) {
                    sellingLevelsSelect = choice;
                } else if (sellingLevelsSelect != choice) {
                    throw new IllegalStateException(
                            "Need to call clearSellingLevelsSelect() before changing existing choice");
                }
            }

            /** 
             * Clear the choice selection.
             */
            public void clearSellingLevelsSelect() {
                sellingLevelsSelect = -1;
            }

            /** 
             * Check if SellingLevelRules is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifSellingLevelRules() {
                return sellingLevelsSelect == SELLING_LEVEL_RULES_CHOICE;
            }

            /** 
             * Get the 'Ignore' attribute value. Force ignore adjustment selling level rules
             * 
             * @return value
             */
            public boolean isSellingLevelRules() {
                return sellingLevelRules;
            }

            /** 
             * Set the 'Ignore' attribute value. Force ignore adjustment selling level rules
             * 
             * @param sellingLevelRules
             */
            public void setSellingLevelRules(boolean sellingLevelRules) {
                setSellingLevelsSelect(SELLING_LEVEL_RULES_CHOICE);
                this.sellingLevelRules = sellingLevelRules;
            }

            /** 
             * Check if ShowFareAmounts is current selection for choice.
             * 
             * @return <code>true</code> if selection, <code>false</code> if not
             */
            public boolean ifShowFareAmounts() {
                return sellingLevelsSelect == SHOW_FARE_AMOUNTS_CHOICE;
            }

            /** 
             * Get the 'ShowFareAmounts' element value.
             * 
             * @return value
             */
            public ShowFareAmounts getShowFareAmounts() {
                return showFareAmounts;
            }

            /** 
             * Set the 'ShowFareAmounts' element value.
             * 
             * @param showFareAmounts
             */
            public void setShowFareAmounts(ShowFareAmounts showFareAmounts) {
                setSellingLevelsSelect(SHOW_FARE_AMOUNTS_CHOICE);
                this.showFareAmounts = showFareAmounts;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ShowFareAmounts">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Original"/>
             *     &lt;xs:attribute type="xs:boolean" use="optional" name="Adjusted"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ShowFareAmounts implements Serializable
            {
                private Boolean original;
                private Boolean adjusted;

                /** 
                 * Get the 'Original' attribute value. Show original selling fare level amounts and total adjusted amount in Fare Calc line
                 * 
                 * @return value
                 */
                public Boolean getOriginal() {
                    return original;
                }

                /** 
                 * Set the 'Original' attribute value. Show original selling fare level amounts and total adjusted amount in Fare Calc line
                 * 
                 * @param original
                 */
                public void setOriginal(Boolean original) {
                    this.original = original;
                }

                /** 
                 * Get the 'Adjusted' attribute value. Show selling level amounts and total adjusted amount in Fare Calc line
                 * 
                 * @return value
                 */
                public Boolean getAdjusted() {
                    return adjusted;
                }

                /** 
                 * Set the 'Adjusted' attribute value. Show selling level amounts and total adjusted amount in Fare Calc line
                 * 
                 * @param adjusted
                 */
                public void setAdjusted(Boolean adjusted) {
                    this.adjusted = adjusted;
                }
            }
        }
        /** 
         * Budget Shopping settings
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Budget" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:anySimpleType" name="MinimumPrice"/>
         *     &lt;xs:attribute type="xs:anySimpleType" name="MaximumPrice"/>
         *     &lt;xs:attribute type="xs:string" name="RelativePriceThreshold"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Budget implements Serializable
        {
            private String minimumPrice;
            private String maximumPrice;
            private String relativePriceThreshold;

            /** 
             * Get the 'MinimumPrice' attribute value. Minimum price to include in response
             * 
             * @return value
             */
            public String getMinimumPrice() {
                return minimumPrice;
            }

            /** 
             * Set the 'MinimumPrice' attribute value. Minimum price to include in response
             * 
             * @param minimumPrice
             */
            public void setMinimumPrice(String minimumPrice) {
                this.minimumPrice = minimumPrice;
            }

            /** 
             * Get the 'MaximumPrice' attribute value. Maximum price to include in response
             * 
             * @return value
             */
            public String getMaximumPrice() {
                return maximumPrice;
            }

            /** 
             * Set the 'MaximumPrice' attribute value. Maximum price to include in response
             * 
             * @param maximumPrice
             */
            public void setMaximumPrice(String maximumPrice) {
                this.maximumPrice = maximumPrice;
            }

            /** 
             * Get the 'RelativePriceThreshold' attribute value. Relative price difference threshold to be respected while choosing alternative options
             * 
             * @return value
             */
            public String getRelativePriceThreshold() {
                return relativePriceThreshold;
            }

            /** 
             * Set the 'RelativePriceThreshold' attribute value. Relative price difference threshold to be respected while choosing alternative options
             * 
             * @param relativePriceThreshold
             */
            public void setRelativePriceThreshold(String relativePriceThreshold) {
                this.relativePriceThreshold = relativePriceThreshold;
            }
        }
        /** 
         * List of dates/date pairs with different requested number of options
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OptionsPerDatePairList" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element type="ns:OptionsPerDatePairType" name="OptionsPerDatePair" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class OptionsPerDatePairList implements Serializable
        {
            private List<OptionsPerDatePairType> optionsPerDatePairList = new ArrayList<OptionsPerDatePairType>();

            /** 
             * Get the list of 'OptionsPerDatePair' element items.
             * 
             * @return list
             */
            public List<OptionsPerDatePairType> getOptionsPerDatePairList() {
                return optionsPerDatePairList;
            }

            /** 
             * Set the list of 'OptionsPerDatePair' element items.
             * 
             * @param list
             */
            public void setOptionsPerDatePairList(
                    List<OptionsPerDatePairType> list) {
                optionsPerDatePairList = list;
            }
        }
        /** 
         * List of countries to be excluded from processing
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CountryPref" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="PreferLevel"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CountryPref implements Serializable
        {
            private String code;
            private String preferLevel;

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'PreferLevel' attribute value.
             * 
             * @return value
             */
            public String getPreferLevel() {
                return preferLevel;
            }

            /** 
             * Set the 'PreferLevel' attribute value.
             * 
             * @param preferLevel
             */
            public void setPreferLevel(String preferLevel) {
                this.preferLevel = preferLevel;
            }
        }
        /** 
         * Fail request if keyword validation fails
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ForceKeywordRestrictedContent" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class ForceKeywordRestrictedContent implements
            Serializable
        {
            private boolean value;

            /** 
             * Get the 'Value' attribute value.
             * 
             * @return value
             */
            public boolean isValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value.
             * 
             * @param value
             */
            public void setValue(boolean value) {
                this.value = value;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FlightRestrictions" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="AvoidLastFlight"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FlightRestrictions implements Serializable
        {
            private Boolean avoidLastFlight;

            /** 
             * Get the 'AvoidLastFlight' attribute value. Avoid last flight of the day.
             * 
             * @return value
             */
            public Boolean getAvoidLastFlight() {
                return avoidLastFlight;
            }

            /** 
             * Set the 'AvoidLastFlight' attribute value. Avoid last flight of the day.
             * 
             * @param avoidLastFlight
             */
            public void setAvoidLastFlight(Boolean avoidLastFlight) {
                this.avoidLastFlight = avoidLastFlight;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="LowCostCarriersProcessing" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="Disable"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class LowCostCarriersProcessing implements Serializable
        {
            private Boolean disable;

            /** 
             * Get the 'Disable' attribute value. Disable low cost carriers processing.
             * 
             * @return value
             */
            public Boolean getDisable() {
                return disable;
            }

            /** 
             * Set the 'Disable' attribute value. Disable low cost carriers processing.
             * 
             * @param disable
             */
            public void setDisable(Boolean disable) {
                this.disable = disable;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DataSources" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="ns:ToggleType" use="optional" name="ATPCO"/>
         *     &lt;xs:attribute type="ns:ToggleType" use="optional" name="LCC"/>
         *     &lt;xs:attribute type="ns:ToggleType" use="optional" name="NDC"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class DataSources implements Serializable
        {
            private ToggleType ATPCO;
            private ToggleType LCC;
            private ToggleType NDC;

            /** 
             * Get the 'ATPCO' attribute value. Toggle processing of ATPCO data source.
             * 
             * @return value
             */
            public ToggleType getATPCO() {
                return ATPCO;
            }

            /** 
             * Set the 'ATPCO' attribute value. Toggle processing of ATPCO data source.
             * 
             * @param ATPCO
             */
            public void setATPCO(ToggleType ATPCO) {
                this.ATPCO = ATPCO;
            }

            /** 
             * Get the 'LCC' attribute value. Toggle processing of Low Cost Carriers data source.
             * 
             * @return value
             */
            public ToggleType getLCC() {
                return LCC;
            }

            /** 
             * Set the 'LCC' attribute value. Toggle processing of Low Cost Carriers data source.
             * 
             * @param LCC
             */
            public void setLCC(ToggleType LCC) {
                this.LCC = LCC;
            }

            /** 
             * Get the 'NDC' attribute value. Toggle processing of New Distribution Capability data source.
             * 
             * @return value
             */
            public ToggleType getNDC() {
                return NDC;
            }

            /** 
             * Set the 'NDC' attribute value. Toggle processing of New Distribution Capability data source.
             * 
             * @param NDC
             */
            public void setNDC(ToggleType NDC) {
                this.NDC = NDC;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="VerificationItinCallLogic" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="ns:VerificationItinCallLogicType" name="Value"/>
         *     &lt;xs:attribute type="xs:boolean" use="optional" name="AlwaysCheckAvailability"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class VerificationItinCallLogic implements Serializable
        {
            private VerificationItinCallLogicType value;
            private Boolean alwaysCheckAvailability;

            /** 
             * Get the 'Value' attribute value. Define how the current itinerary is priced.
             * 
             * @return value
             */
            public VerificationItinCallLogicType getValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value. Define how the current itinerary is priced.
             * 
             * @param value
             */
            public void setValue(VerificationItinCallLogicType value) {
                this.value = value;
            }

            /** 
             * Get the 'AlwaysCheckAvailability' attribute value. Check availability for repriced itin.
             * 
             * @return value
             */
            public Boolean getAlwaysCheckAvailability() {
                return alwaysCheckAvailability;
            }

            /** 
             * Set the 'AlwaysCheckAvailability' attribute value. Check availability for repriced itin.
             * 
             * @param alwaysCheckAvailability
             */
            public void setAlwaysCheckAvailability(
                    Boolean alwaysCheckAvailability) {
                this.alwaysCheckAvailability = alwaysCheckAvailability;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferNDCSourceOnTie" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:boolean" use="required" name="Value"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PreferNDCSourceOnTie implements Serializable
        {
            private boolean value;

            /** 
             * Get the 'Value' attribute value. Select content from NDC Content Source in case of identical offers
             * 
             * @return value
             */
            public boolean isValue() {
                return value;
            }

            /** 
             * Set the 'Value' attribute value. Select content from NDC Content Source in case of identical offers
             * 
             * @param value
             */
            public void setValue(boolean value) {
                this.value = value;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="NDCIndicators" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="SingleBrandedFare" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class SingleBrandedFare -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MultipleBrandedFares" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class MultipleBrandedFares -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="ParityMode" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class ParityMode -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="MaxNumberOfUpsells" minOccurs="0" maxOccurs="1">
         *         &lt;!-- Reference to inner class MaxNumberOfUpsells -->
         *       &lt;/xs:element>
         *       &lt;xs:element name="CarrierSpecificQualifiers" minOccurs="0" maxOccurs="unbounded">
         *         &lt;!-- Reference to inner class CarrierSpecificQualifiers -->
         *       &lt;/xs:element>
         *       &lt;xs:element type="ns:QualifierType" name="Qualifier" minOccurs="0" maxOccurs="unbounded"/>
         *       &lt;xs:element type="ns:FrequentFlyerType" name="FrequentFlyer" minOccurs="0" maxOccurs="unbounded"/>
         *     &lt;/xs:sequence>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class NDCIndicators implements Serializable
        {
            private SingleBrandedFare singleBrandedFare;
            private MultipleBrandedFares multipleBrandedFares;
            private ParityMode parityMode;
            private MaxNumberOfUpsells maxNumberOfUpsells;
            private List<CarrierSpecificQualifiers> carrierSpecificQualifierList = new ArrayList<CarrierSpecificQualifiers>();
            private List<QualifierType> qualifierList = new ArrayList<QualifierType>();
            private List<FrequentFlyerType> frequentFlyerList = new ArrayList<FrequentFlyerType>();

            /** 
             * Get the 'SingleBrandedFare' element value.
             * 
             * @return value
             */
            public SingleBrandedFare getSingleBrandedFare() {
                return singleBrandedFare;
            }

            /** 
             * Set the 'SingleBrandedFare' element value.
             * 
             * @param singleBrandedFare
             */
            public void setSingleBrandedFare(SingleBrandedFare singleBrandedFare) {
                this.singleBrandedFare = singleBrandedFare;
            }

            /** 
             * Get the 'MultipleBrandedFares' element value.
             * 
             * @return value
             */
            public MultipleBrandedFares getMultipleBrandedFares() {
                return multipleBrandedFares;
            }

            /** 
             * Set the 'MultipleBrandedFares' element value.
             * 
             * @param multipleBrandedFares
             */
            public void setMultipleBrandedFares(
                    MultipleBrandedFares multipleBrandedFares) {
                this.multipleBrandedFares = multipleBrandedFares;
            }

            /** 
             * Get the 'ParityMode' element value.
             * 
             * @return value
             */
            public ParityMode getParityMode() {
                return parityMode;
            }

            /** 
             * Set the 'ParityMode' element value.
             * 
             * @param parityMode
             */
            public void setParityMode(ParityMode parityMode) {
                this.parityMode = parityMode;
            }

            /** 
             * Get the 'MaxNumberOfUpsells' element value.
             * 
             * @return value
             */
            public MaxNumberOfUpsells getMaxNumberOfUpsells() {
                return maxNumberOfUpsells;
            }

            /** 
             * Set the 'MaxNumberOfUpsells' element value.
             * 
             * @param maxNumberOfUpsells
             */
            public void setMaxNumberOfUpsells(
                    MaxNumberOfUpsells maxNumberOfUpsells) {
                this.maxNumberOfUpsells = maxNumberOfUpsells;
            }

            /** 
             * Get the list of 'CarrierSpecificQualifiers' element items.
             * 
             * @return list
             */
            public List<CarrierSpecificQualifiers> getCarrierSpecificQualifierList() {
                return carrierSpecificQualifierList;
            }

            /** 
             * Set the list of 'CarrierSpecificQualifiers' element items.
             * 
             * @param list
             */
            public void setCarrierSpecificQualifierList(
                    List<CarrierSpecificQualifiers> list) {
                carrierSpecificQualifierList = list;
            }

            /** 
             * Get the list of 'Qualifier' element items. General qualifiers. Each qualifier will only be used for carriers without CarrierSpecificQualifiers override provided.
             * 
             * @return list
             */
            public List<QualifierType> getQualifierList() {
                return qualifierList;
            }

            /** 
             * Set the list of 'Qualifier' element items. General qualifiers. Each qualifier will only be used for carriers without CarrierSpecificQualifiers override provided.
             * 
             * @param list
             */
            public void setQualifierList(List<QualifierType> list) {
                qualifierList = list;
            }

            /** 
             * Get the list of 'FrequentFlyer' element items. General Frequent Flyer data for the passengers. Each Frequent Flyer data will only be used for carriers without CarrierSpecificQualifiers override provided.
             * 
             * @return list
             */
            public List<FrequentFlyerType> getFrequentFlyerList() {
                return frequentFlyerList;
            }

            /** 
             * Set the list of 'FrequentFlyer' element items. General Frequent Flyer data for the passengers. Each Frequent Flyer data will only be used for carriers without CarrierSpecificQualifiers override provided.
             * 
             * @param list
             */
            public void setFrequentFlyerList(List<FrequentFlyerType> list) {
                frequentFlyerList = list;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SingleBrandedFare" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Value"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class SingleBrandedFare implements Serializable
            {
                private boolean value;

                /** 
                 * Get the 'Value' attribute value. Indicates whether price class information is displayed.
                 * 
                 * @return value
                 */
                public boolean isValue() {
                    return value;
                }

                /** 
                 * Set the 'Value' attribute value. Indicates whether price class information is displayed.
                 * 
                 * @param value
                 */
                public void setValue(boolean value) {
                    this.value = value;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MultipleBrandedFares" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:boolean" use="required" name="Value"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MultipleBrandedFares implements Serializable
            {
                private boolean value;

                /** 
                 * Get the 'Value' attribute value. Indicates whether NDC upsells are allowed.
                 * 
                 * @return value
                 */
                public boolean isValue() {
                    return value;
                }

                /** 
                 * Set the 'Value' attribute value. Indicates whether NDC upsells are allowed.
                 * 
                 * @param value
                 */
                public void setValue(boolean value) {
                    this.value = value;
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ParityMode" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute use="required" name="Mode">
             *       &lt;xs:simpleType>
             *         &lt;!-- Reference to inner class Mode -->
             *       &lt;/xs:simpleType>
             *     &lt;/xs:attribute>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class ParityMode implements Serializable
            {
                private Mode mode;

                /** 
                 * Get the 'Mode' attribute value. Parity mode for the PriceClasses
                 * 
                 * @return value
                 */
                public Mode getMode() {
                    return mode;
                }

                /** 
                 * Set the 'Mode' attribute value. Parity mode for the PriceClasses
                 * 
                 * @param mode
                 */
                public void setMode(Mode mode) {
                    this.mode = mode;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
                 *   &lt;xs:restriction base="xs:string">
                 *     &lt;xs:enumeration value="Leg"/>
                 *     &lt;xs:enumeration value="Itin"/>
                 *   &lt;/xs:restriction>
                 * &lt;/xs:simpleType>
                 * </pre>
                 */
                public static enum Mode implements Serializable {
                    LEG("Leg"), ITIN("Itin");
                    private final String value;

                    private Mode(String value) {
                        this.value = value;
                    }

                    public String xmlValue() {
                        return value;
                    }

                    public static Mode convert(String value) {
                        for (Mode inst : values()) {
                            if (inst.xmlValue().equals(value)) {
                                return inst;
                            }
                        }
                        return null;
                    }
                }
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="MaxNumberOfUpsells" minOccurs="0" maxOccurs="1">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:unsignedShort" use="required" name="Value"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class MaxNumberOfUpsells implements Serializable
            {
                private String value;

                /** 
                 * Get the 'Value' attribute value. Indicates maximum number of NDC upsells per itinerary.
                 * 
                 * @return value
                 */
                public String getValue() {
                    return value;
                }

                /** 
                 * Set the 'Value' attribute value. Indicates maximum number of NDC upsells per itinerary.
                 * 
                 * @param value
                 */
                public void setValue(String value) {
                    this.value = value;
                }
            }
            /** 
             * Carrier specific qualifiers. If an attribute is specified in both places, the general qualifier will be overwritten with the carrier specific value
             * 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CarrierSpecificQualifiers" minOccurs="0" maxOccurs="unbounded">
             *   &lt;xs:complexType>
             *     &lt;xs:sequence minOccurs="0" maxOccurs="1">
             *       &lt;!-- Reference to inner class Sequence -->
             *     &lt;/xs:sequence>
             *     &lt;xs:attribute type="xs:string" use="required" name="CarrierCode"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class CarrierSpecificQualifiers implements
                Serializable
            {
                private Sequence sequence;
                private String carrierCode;

                /** 
                 * Get the sequence value.
                 * 
                 * @return value
                 */
                public Sequence getSequence() {
                    return sequence;
                }

                /** 
                 * Set the sequence value.
                 * 
                 * @param sequence
                 */
                public void setSequence(Sequence sequence) {
                    this.sequence = sequence;
                }

                /** 
                 * Get the 'CarrierCode' attribute value.
                 * 
                 * @return value
                 */
                public String getCarrierCode() {
                    return carrierCode;
                }

                /** 
                 * Set the 'CarrierCode' attribute value.
                 * 
                 * @param carrierCode
                 */
                public void setCarrierCode(String carrierCode) {
                    this.carrierCode = carrierCode;
                }
                /** 
                 * Schema fragment(s) for this class:
                 * <pre>
                 * &lt;xs:sequence xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" minOccurs="0" maxOccurs="1">
                 *   &lt;xs:element name="AccountCode" minOccurs="0" maxOccurs="1">
                 *     &lt;!-- Reference to inner class AccountCode -->
                 *   &lt;/xs:element>
                 *   &lt;xs:element type="ns:QualifierType" name="Qualifier" minOccurs="0" maxOccurs="unbounded"/>
                 *   &lt;xs:element type="ns:FrequentFlyerType" name="FrequentFlyer" minOccurs="0" maxOccurs="unbounded"/>
                 * &lt;/xs:sequence>
                 * </pre>
                 */
                public static class Sequence implements Serializable
                {
                    private AccountCode accountCode;
                    private List<QualifierType> qualifierList = new ArrayList<QualifierType>();
                    private List<FrequentFlyerType> frequentFlyerList = new ArrayList<FrequentFlyerType>();

                    /** 
                     * Get the 'AccountCode' element value.
                     * 
                     * @return value
                     */
                    public AccountCode getAccountCode() {
                        return accountCode;
                    }

                    /** 
                     * Set the 'AccountCode' element value.
                     * 
                     * @param accountCode
                     */
                    public void setAccountCode(AccountCode accountCode) {
                        this.accountCode = accountCode;
                    }

                    /** 
                     * Get the list of 'Qualifier' element items.
                     * 
                     * @return list
                     */
                    public List<QualifierType> getQualifierList() {
                        return qualifierList;
                    }

                    /** 
                     * Set the list of 'Qualifier' element items.
                     * 
                     * @param list
                     */
                    public void setQualifierList(List<QualifierType> list) {
                        qualifierList = list;
                    }

                    /** 
                     * Get the list of 'FrequentFlyer' element items. Frequent Flyer data for the passengers.
                     * 
                     * @return list
                     */
                    public List<FrequentFlyerType> getFrequentFlyerList() {
                        return frequentFlyerList;
                    }

                    /** 
                     * Set the list of 'FrequentFlyer' element items. Frequent Flyer data for the passengers.
                     * 
                     * @param list
                     */
                    public void setFrequentFlyerList(
                            List<FrequentFlyerType> list) {
                        frequentFlyerList = list;
                    }
                    /** 
                     * Schema fragment(s) for this class:
                     * <pre>
                     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AccountCode" minOccurs="0" maxOccurs="1">
                     *   &lt;xs:complexType>
                     *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
                     *   &lt;/xs:complexType>
                     * &lt;/xs:element>
                     * </pre>
                     */
                    public static class AccountCode implements Serializable
                    {
                        private String code;

                        /** 
                         * Get the 'Code' attribute value.
                         * 
                         * @return value
                         */
                        public String getCode() {
                            return code;
                        }

                        /** 
                         * Set the 'Code' attribute value.
                         * 
                         * @param code
                         */
                        public void setCode(String code) {
                            this.code = code;
                        }
                    }
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryFees" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="AncillaryFeeGroup" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class AncillaryFeeGroup -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:boolean" use="required" name="Enable"/>
     *     &lt;xs:attribute type="xs:boolean" name="Summary"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class AncillaryFees implements Serializable
    {
        private List<AncillaryFeeGroup> ancillaryFeeGroupList = new ArrayList<AncillaryFeeGroup>();
        private boolean enable;
        private Boolean summary;

        /** 
         * Get the list of 'AncillaryFeeGroup' element items.
         * 
         * @return list
         */
        public List<AncillaryFeeGroup> getAncillaryFeeGroupList() {
            return ancillaryFeeGroupList;
        }

        /** 
         * Set the list of 'AncillaryFeeGroup' element items.
         * 
         * @param list
         */
        public void setAncillaryFeeGroupList(List<AncillaryFeeGroup> list) {
            ancillaryFeeGroupList = list;
        }

        /** 
         * Get the 'Enable' attribute value. Enable Ancillary Fees processing path.
         * 
         * @return value
         */
        public boolean isEnable() {
            return enable;
        }

        /** 
         * Set the 'Enable' attribute value. Enable Ancillary Fees processing path.
         * 
         * @param enable
         */
        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        /** 
         * Get the 'Summary' attribute value. Flag whether this is a summary request.
         * 
         * @return value
         */
        public Boolean getSummary() {
            return summary;
        }

        /** 
         * Set the 'Summary' attribute value. Flag whether this is a summary request.
         * 
         * @param summary
         */
        public void setSummary(Boolean summary) {
            this.summary = summary;
        }
        /** 
         * List of requested groups
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AncillaryFeeGroup" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:anySimpleType" use="required" name="Code"/>
         *     &lt;xs:attribute type="xs:anySimpleType" name="Count"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class AncillaryFeeGroup implements Serializable
        {
            private String code;
            private String count;

            /** 
             * Get the 'Code' attribute value. Group code
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value. Group code
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'Count' attribute value. Number of items
             * 
             * @return value
             */
            public String getCount() {
                return count;
            }

            /** 
             * Set the 'Count' attribute value. Number of items
             * 
             * @param count
             */
            public void setCount(String count) {
                this.count = count;
            }
        }
    }
    /** 
     * Frequent Flyer Status Information
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FrequentFlyer" minOccurs="0" maxOccurs="unbounded">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:short" use="required" name="Status"/>
     *     &lt;xs:attribute type="xs:string" name="AirlineCode"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class FrequentFlyer implements Serializable
    {
        private Short status;
        private String airlineCode;

        /** 
         * Get the 'Status' attribute value. Frequent Flyer Status
         * 
         * @return value
         */
        public Short getStatus() {
            return status;
        }

        /** 
         * Set the 'Status' attribute value. Frequent Flyer Status
         * 
         * @param status
         */
        public void setStatus(Short status) {
            this.status = status;
        }

        /** 
         * Get the 'AirlineCode' attribute value. Airline Carrier Code
         * 
         * @return value
         */
        public String getAirlineCode() {
            return airlineCode;
        }

        /** 
         * Set the 'AirlineCode' attribute value. Airline Carrier Code
         * 
         * @param airlineCode
         */
        public void setAirlineCode(String airlineCode) {
            this.airlineCode = airlineCode;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="SpanishFamilyDiscount" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute use="required" name="Level">
     *       &lt;xs:simpleType>
     *         &lt;!-- Reference to inner class Level -->
     *       &lt;/xs:simpleType>
     *     &lt;/xs:attribute>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class SpanishFamilyDiscount implements Serializable
    {
        private Level level;

        /** 
         * Get the 'Level' attribute value. Spanish Large Family Discount Level. Valid values are 1 or 2.
         * 
         * @return value
         */
        public Level getLevel() {
            return level;
        }

        /** 
         * Set the 'Level' attribute value. Spanish Large Family Discount Level. Valid values are 1 or 2.
         * 
         * @param level
         */
        public void setLevel(Level level) {
            this.level = level;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
         *   &lt;xs:restriction base="xs:short">
         *     &lt;xs:enumeration value="1"/>
         *     &lt;xs:enumeration value="2"/>
         *   &lt;/xs:restriction>
         * &lt;/xs:simpleType>
         * </pre>
         */
        public static enum Level implements Serializable {
            _1("1"), _2("2");
            private final String value;

            private Level(String value) {
                this.value = value;
            }

            public String xmlValue() {
                return value;
            }

            public static Level convert(String value) {
                for (Level inst : values()) {
                    if (inst.xmlValue().equals(value)) {
                        return inst;
                    }
                }
                return null;
            }
        }
    }
    /** 
     * This element allows user to get baggage information
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Baggage" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="ns:BaggageRequestType" use="optional" name="RequestType"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" default="false" name="Description"/>
     *     &lt;xs:attribute type="xs:unsignedShort" use="optional" name="RequestedPieces"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="FreePieceRequired"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="FreeCarryOn"/>
     *     &lt;xs:attribute type="xs:boolean" use="optional" name="CarryOnInfo"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Baggage implements Serializable
    {
        private BaggageRequestType requestType;
        private Boolean description;
        private String requestedPieces;
        private Boolean freePieceRequired;
        private Boolean freeCarryOn;
        private Boolean carryOnInfo;

        /** 
         * Get the 'RequestType' attribute value. Determines type of baggage processing result.
         * 
         * @return value
         */
        public BaggageRequestType getRequestType() {
            return requestType;
        }

        /** 
         * Set the 'RequestType' attribute value. Determines type of baggage processing result.
         * 
         * @param requestType
         */
        public void setRequestType(BaggageRequestType requestType) {
            this.requestType = requestType;
        }

        /** 
         * Get the 'Description' attribute value. Turns on additional text output in response, see Description1 (D01) and Description2 (D02) in response.
         * 
         * @return value
         */
        public Boolean getDescription() {
            return description;
        }

        /** 
         * Set the 'Description' attribute value. Turns on additional text output in response, see Description1 (D01) and Description2 (D02) in response.
         * 
         * @param description
         */
        public void setDescription(Boolean description) {
            this.description = description;
        }

        /** 
         * Get the 'RequestedPieces' attribute value. Number of baggage pieces requested
         * 
         * @return value
         */
        public String getRequestedPieces() {
            return requestedPieces;
        }

        /** 
         * Set the 'RequestedPieces' attribute value. Number of baggage pieces requested
         * 
         * @param requestedPieces
         */
        public void setRequestedPieces(String requestedPieces) {
            this.requestedPieces = requestedPieces;
        }

        /** 
         * Get the 'FreePieceRequired' attribute value. Free baggage piece is required on the whole journey.
         * 
         * @return value
         */
        public Boolean getFreePieceRequired() {
            return freePieceRequired;
        }

        /** 
         * Set the 'FreePieceRequired' attribute value. Free baggage piece is required on the whole journey.
         * 
         * @param freePieceRequired
         */
        public void setFreePieceRequired(Boolean freePieceRequired) {
            this.freePieceRequired = freePieceRequired;
        }

        /** 
         * Get the 'FreeCarryOn' attribute value. Free carry-on baggage piece is required on the whole journey.
         * 
         * @return value
         */
        public Boolean getFreeCarryOn() {
            return freeCarryOn;
        }

        /** 
         * Set the 'FreeCarryOn' attribute value. Free carry-on baggage piece is required on the whole journey.
         * 
         * @param freeCarryOn
         */
        public void setFreeCarryOn(Boolean freeCarryOn) {
            this.freeCarryOn = freeCarryOn;
        }

        /** 
         * Get the 'CarryOnInfo' attribute value. Include carry-on information in the response.
         * 
         * @return value
         */
        public Boolean getCarryOnInfo() {
            return carryOnInfo;
        }

        /** 
         * Set the 'CarryOnInfo' attribute value. Include carry-on information in the response.
         * 
         * @param carryOnInfo
         */
        public void setCarryOnInfo(Boolean carryOnInfo) {
            this.carryOnInfo = carryOnInfo;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionCodeQualifiers" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="CommissionCodeQualifier" maxOccurs="4">
     *         &lt;!-- Reference to inner class CommissionCodeQualifier -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class CommissionCodeQualifiers implements Serializable
    {
        private List<CommissionCodeQualifier> commissionCodeQualifierList = new ArrayList<CommissionCodeQualifier>();

        /** 
         * Get the list of 'CommissionCodeQualifier' element items.
         * 
         * @return list
         */
        public List<CommissionCodeQualifier> getCommissionCodeQualifierList() {
            return commissionCodeQualifierList;
        }

        /** 
         * Set the list of 'CommissionCodeQualifier' element items.
         * 
         * @param list
         */
        public void setCommissionCodeQualifierList(
                List<CommissionCodeQualifier> list) {
            commissionCodeQualifierList = list;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CommissionCodeQualifier" maxOccurs="4">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class CommissionCodeQualifier implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
    }
    /** 
     * Information about the person that is searching for flights and may be buying the tickets. For example, it might be used to determine a special promotion.
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BuyerInformation" minOccurs="0" maxOccurs="1">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="FrequentFlyer" minOccurs="0" maxOccurs="1">
     *         &lt;!-- Reference to inner class FrequentFlyer -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class BuyerInformation implements Serializable
    {
        private FrequentFlyer frequentFlyer;

        /** 
         * Get the 'FrequentFlyer' element value.
         * 
         * @return value
         */
        public FrequentFlyer getFrequentFlyer() {
            return frequentFlyer;
        }

        /** 
         * Set the 'FrequentFlyer' element value.
         * 
         * @param frequentFlyer
         */
        public void setFrequentFlyer(FrequentFlyer frequentFlyer) {
            this.frequentFlyer = frequentFlyer;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="FrequentFlyer" minOccurs="0" maxOccurs="1">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:integer" use="required" name="Tier"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Carrier"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class FrequentFlyer implements Serializable
        {
            private BigInteger tier;
            private String carrier;

            /** 
             * Get the 'Tier' attribute value.
             * 
             * @return value
             */
            public BigInteger getTier() {
                return tier;
            }

            /** 
             * Set the 'Tier' attribute value.
             * 
             * @param tier
             */
            public void setTier(BigInteger tier) {
                this.tier = tier;
            }

            /** 
             * Get the 'Carrier' attribute value.
             * 
             * @return value
             */
            public String getCarrier() {
                return carrier;
            }

            /** 
             * Set the 'Carrier' attribute value.
             * 
             * @param carrier
             */
            public void setCarrier(String carrier) {
                this.carrier = carrier;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="AllLegs"/>
     *     &lt;xs:enumeration value="FirstShoppedLeg"/>
     *     &lt;xs:enumeration value="None"/>
     *     &lt;xs:enumeration value="true"/>
     *     &lt;xs:enumeration value="1"/>
     *     &lt;xs:enumeration value="false"/>
     *     &lt;xs:enumeration value="0"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum UseAllFlights implements Serializable {
        /** 
         * Use all flights on all legs
         */
        ALL_LEGS("AllLegs"), /** 
                              * Use all flights on first shopped leg
                              */
        FIRST_SHOPPED_LEG("FirstShoppedLeg"), /** 
                                               * Do not use all flights on any leg
                                               */
        NONE("None"), /** 
                       * DEPRECATED. Same as "AllLegs"
                       */
        TRUE("true"), /** 
                       * DEPRECATED. Same as "AllLegs"
                       */
        _1("1"), /** 
                  * DEPRECATED. Same as "None"
                  */
        FALSE("false"), /** 
                         * DEPRECATED. Same as "None"
                         */
        _0("0");
        private final String value;

        private UseAllFlights(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static UseAllFlights convert(String value) {
            for (UseAllFlights inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
