
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:simpleType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="AmenityCostType">
 *   &lt;xs:restriction base="xs:string">
 *     &lt;xs:enumeration value="free"/>
 *     &lt;xs:enumeration value="paid"/>
 *   &lt;/xs:restriction>
 * &lt;/xs:simpleType>
 * </pre>
 */
public enum AmenityCostType implements Serializable {
    FREE("free"), PAID("paid");
    private final String value;

    private AmenityCostType(String value) {
        this.value = value;
    }

    public String xmlValue() {
        return value;
    }

    public static AmenityCostType convert(String value) {
        for (AmenityCostType inst : values()) {
            if (inst.xmlValue().equals(value)) {
                return inst;
            }
        }
        return null;
    }
}
