
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Indicates brand code preferences.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandCodePrefType">
 *   &lt;xs:attributeGroup ref="ns:IncludeExcludePreferLevelGroup"/>
 *   &lt;xs:attribute type="xs:string" use="required" name="Code"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="IncludeExcludePreferLevelGroup">
 *   &lt;xs:attribute type="ns:IncludeExcludePreferLevelType" use="required" name="PreferLevel"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class BrandCodePrefType implements Serializable
{
    private IncludeExcludePreferLevelType preferLevel;
    private String code;

    /** 
     * Get the 'PreferLevel' attribute value. Used to indicate a level of preference for an assosiate item: unacceptable or preferred.
     * 
     * @return value
     */
    public IncludeExcludePreferLevelType getPreferLevel() {
        return preferLevel;
    }

    /** 
     * Set the 'PreferLevel' attribute value. Used to indicate a level of preference for an assosiate item: unacceptable or preferred.
     * 
     * @param preferLevel
     */
    public void setPreferLevel(IncludeExcludePreferLevelType preferLevel) {
        this.preferLevel = preferLevel;
    }

    /** 
     * Get the 'Code' attribute value. Specify brand code.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' attribute value. Specify brand code.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }
}
