
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BrandedFareIndicatorsBase">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="ns:BrandFiltersType" name="BrandFilters" minOccurs="0"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="SingleBrandedFare"/>
 *   &lt;xs:attribute use="optional" name="ParityModeForLowest">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class ParityModeForLowest -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="MultipleBrandedFares"/>
 *   &lt;xs:attribute type="xs:integer" use="optional" name="UpsellLimit"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="ItinParityBrandlessLeg"/>
 *   &lt;xs:attribute name="ParityMode">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class ParityMode -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 *   &lt;xs:attribute name="ItinParityFallbackMode">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class ItinParityFallbackMode -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 * &lt;/xs:complexType>
 * </pre>
 */
public class BrandedFareIndicatorsBase implements Serializable
{
    private BrandFiltersType brandFilters;
    private Boolean singleBrandedFare;
    private ParityModeForLowest parityModeForLowest;
    private Boolean multipleBrandedFares;
    private BigInteger upsellLimit;
    private Boolean itinParityBrandlessLeg;
    private ParityMode parityMode;
    private ItinParityFallbackMode itinParityFallbackMode;

    /** 
     * Get the 'BrandFilters' element value.
     * 
     * @return value
     */
    public BrandFiltersType getBrandFilters() {
        return brandFilters;
    }

    /** 
     * Set the 'BrandFilters' element value.
     * 
     * @param brandFilters
     */
    public void setBrandFilters(BrandFiltersType brandFilters) {
        this.brandFilters = brandFilters;
    }

    /** 
     * Get the 'SingleBrandedFare' attribute value. Return single brand option per itin
     * 
     * @return value
     */
    public Boolean getSingleBrandedFare() {
        return singleBrandedFare;
    }

    /** 
     * Set the 'SingleBrandedFare' attribute value. Return single brand option per itin
     * 
     * @param singleBrandedFare
     */
    public void setSingleBrandedFare(Boolean singleBrandedFare) {
        this.singleBrandedFare = singleBrandedFare;
    }

    /** 
     * Get the 'ParityModeForLowest' attribute value. 
            If set, given parity mode will be forced on the cheapest branded fare solution.
            If not specified, no parity (None) is forced on the cheapest branded fare solution.
            It's designed to work with MultipleBrandedFares feature only.
          
     * 
     * @return value
     */
    public ParityModeForLowest getParityModeForLowest() {
        return parityModeForLowest;
    }

    /** 
     * Set the 'ParityModeForLowest' attribute value. 
            If set, given parity mode will be forced on the cheapest branded fare solution.
            If not specified, no parity (None) is forced on the cheapest branded fare solution.
            It's designed to work with MultipleBrandedFares feature only.
          
     * 
     * @param parityModeForLowest
     */
    public void setParityModeForLowest(ParityModeForLowest parityModeForLowest) {
        this.parityModeForLowest = parityModeForLowest;
    }

    /** 
     * Get the 'MultipleBrandedFares' attribute value. Return multiple brand options per itin
     * 
     * @return value
     */
    public Boolean getMultipleBrandedFares() {
        return multipleBrandedFares;
    }

    /** 
     * Set the 'MultipleBrandedFares' attribute value. Return multiple brand options per itin
     * 
     * @param multipleBrandedFares
     */
    public void setMultipleBrandedFares(Boolean multipleBrandedFares) {
        this.multipleBrandedFares = multipleBrandedFares;
    }

    /** 
     * Get the 'UpsellLimit' attribute value. Indicates maximum number of requested branded upsells
     * 
     * @return value
     */
    public BigInteger getUpsellLimit() {
        return upsellLimit;
    }

    /** 
     * Set the 'UpsellLimit' attribute value. Indicates maximum number of requested branded upsells
     * 
     * @param upsellLimit
     */
    public void setUpsellLimit(BigInteger upsellLimit) {
        this.upsellLimit = upsellLimit;
    }

    /** 
     * Get the 'ItinParityBrandlessLeg' attribute value. Allow brandless legs in multiple brands upsell solutions
     * 
     * @return value
     */
    public Boolean getItinParityBrandlessLeg() {
        return itinParityBrandlessLeg;
    }

    /** 
     * Set the 'ItinParityBrandlessLeg' attribute value. Allow brandless legs in multiple brands upsell solutions
     * 
     * @param itinParityBrandlessLeg
     */
    public void setItinParityBrandlessLeg(Boolean itinParityBrandlessLeg) {
        this.itinParityBrandlessLeg = itinParityBrandlessLeg;
    }

    /** 
     * Get the 'ParityMode' attribute value. Multiple Branded Fares parity mode
     * 
     * @return value
     */
    public ParityMode getParityMode() {
        return parityMode;
    }

    /** 
     * Set the 'ParityMode' attribute value. Multiple Branded Fares parity mode
     * 
     * @param parityMode
     */
    public void setParityMode(ParityMode parityMode) {
        this.parityMode = parityMode;
    }

    /** 
     * Get the 'ItinParityFallbackMode' attribute value. Fallback mode for Multiple Branded Fares with Itin parity, when no itin parity solutions found
     * 
     * @return value
     */
    public ItinParityFallbackMode getItinParityFallbackMode() {
        return itinParityFallbackMode;
    }

    /** 
     * Set the 'ItinParityFallbackMode' attribute value. Fallback mode for Multiple Branded Fares with Itin parity, when no itin parity solutions found
     * 
     * @param itinParityFallbackMode
     */
    public void setItinParityFallbackMode(
            ItinParityFallbackMode itinParityFallbackMode) {
        this.itinParityFallbackMode = itinParityFallbackMode;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Leg"/>
     *     &lt;xs:enumeration value="Itin"/>
     *     &lt;xs:enumeration value="None"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum ParityModeForLowest implements Serializable {
        LEG("Leg"), ITIN("Itin"), NONE("None");
        private final String value;

        private ParityModeForLowest(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static ParityModeForLowest convert(String value) {
            for (ParityModeForLowest inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="Leg"/>
     *     &lt;xs:enumeration value="Itin"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum ParityMode implements Serializable {
        LEG("Leg"), ITIN("Itin");
        private final String value;

        private ParityMode(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static ParityMode convert(String value) {
            for (ParityMode inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="LegParity"/>
     *     &lt;xs:enumeration value="LowestSingle"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum ItinParityFallbackMode implements Serializable {
        LEG_PARITY("LegParity"), LOWEST_SINGLE("LowestSingle");
        private final String value;

        private ItinParityFallbackMode(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static ItinParityFallbackMode convert(String value) {
            for (ItinParityFallbackMode inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
