
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Indicates preferences for choice of airline cabin for a given travel situation.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CabinPrefType">
 *   &lt;xs:attributeGroup ref="ns:PreferLevelGroup"/>
 *   &lt;xs:attribute type="ns:CabinType" name="Cabin"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferLevelGroup">
 *   &lt;xs:attribute type="ns:PreferLevelType" default="Preferred" name="PreferLevel"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CabinPrefType implements Serializable
{
    private PreferLevelType preferLevel;
    private CabinType cabin;

    /** 
     * Get the 'PreferLevel' attribute value. Used to indicate a level of preference for an associate item, only, unacceptable, preferred.
     * 
     * @return value
     */
    public PreferLevelType getPreferLevel() {
        return preferLevel;
    }

    /** 
     * Set the 'PreferLevel' attribute value. Used to indicate a level of preference for an associate item, only, unacceptable, preferred.
     * 
     * @param preferLevel
     */
    public void setPreferLevel(PreferLevelType preferLevel) {
        this.preferLevel = preferLevel;
    }

    /** 
     * Get the 'Cabin' attribute value. Specify cabin type.
     * 
     * @return value
     */
    public CabinType getCabin() {
        return cabin;
    }

    /** 
     * Set the 'Cabin' attribute value. Specify cabin type.
     * 
     * @param cabin
     */
    public void setCabin(CabinType cabin) {
        this.cabin = cabin;
    }
}
