
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Used to specify a code and its associated attributes; meaning is derived from actual use.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="CodeListGroup">
 *   &lt;xs:attribute type="xs:string" use="optional" name="Code"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="CodeContext"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="URI"/>
 *   &lt;xs:attributeGroup ref="ns:QuantityGroup"/>
 * &lt;/xs:attributeGroup>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="QuantityGroup">
 *   &lt;xs:attribute type="xs:integer" use="optional" name="Quantity"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class CodeListGroup implements Serializable
{
    private String code;
    private String codeContext;
    private String URI;
    private BigInteger quantity;

    /** 
     * Get the 'Code' attribute value. Any code used to specify an item, for example, type of traveler, service code, room amenity, etc.
     * 
     * @return value
     */
    public String getCode() {
        return code;
    }

    /** 
     * Set the 'Code' attribute value. Any code used to specify an item, for example, type of traveler, service code, room amenity, etc.
     * 
     * @param code
     */
    public void setCode(String code) {
        this.code = code;
    }

    /** 
     * Get the 'CodeContext' attribute value. Identifies the source authority for the code.
     * 
     * @return value
     */
    public String getCodeContext() {
        return codeContext;
    }

    /** 
     * Set the 'CodeContext' attribute value. Identifies the source authority for the code.
     * 
     * @param codeContext
     */
    public void setCodeContext(String codeContext) {
        this.codeContext = codeContext;
    }

    /** 
     * Get the 'URI' attribute value. Identifies the location of the code table
     * 
     * @return value
     */
    public String getURI() {
        return URI;
    }

    /** 
     * Set the 'URI' attribute value. Identifies the location of the code table
     * 
     * @param URI
     */
    public void setURI(String URI) {
        this.URI = URI;
    }

    /** 
     * Get the 'Quantity' attribute value. 
                      Used to define a quantity of an associated element or attribute.
                  
     * 
     * @return value
     */
    public BigInteger getQuantity() {
        return quantity;
    }

    /** 
     * Set the 'Quantity' attribute value. 
                      Used to define a quantity of an associated element or attribute.
                  
     * 
     * @param quantity
     */
    public void setQuantity(BigInteger quantity) {
        this.quantity = quantity;
    }
}
