
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ComplexProcessingMessageType">
 *   &lt;xs:complexContent>
 *     &lt;xs:extension base="ns:ProcessingMessageType">
 *       &lt;xs:sequence>
 *         &lt;xs:element name="Leg" minOccurs="0" maxOccurs="10">
 *           &lt;!-- Reference to inner class Leg -->
 *         &lt;/xs:element>
 *       &lt;/xs:sequence>
 *     &lt;/xs:extension>
 *   &lt;/xs:complexContent>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ComplexProcessingMessageType extends ProcessingMessageType
    implements Serializable
{
    private List<Leg> legList = new ArrayList<Leg>();

    /** 
     * Get the list of 'Leg' element items.
     * 
     * @return list
     */
    public List<Leg> getLegList() {
        return legList;
    }

    /** 
     * Set the list of 'Leg' element items.
     * 
     * @param list
     */
    public void setLegList(List<Leg> list) {
        legList = list;
    }
    /** 
     * Optional list of departure dates for each leg
     * 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Leg" minOccurs="0" maxOccurs="10">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:date" use="required" name="DepartureDate"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Leg implements Serializable
    {
        private Date departureDate;

        /** 
         * Get the 'DepartureDate' attribute value. Departure date
         * 
         * @return value
         */
        public Date getDepartureDate() {
            return departureDate;
        }

        /** 
         * Set the 'DepartureDate' attribute value. Departure date
         * 
         * @param departureDate
         */
        public void setDepartureDate(Date departureDate) {
            this.departureDate = departureDate;
        }
    }
}
