
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * To specify connection locations, preference level for each, min connection time, and whether location is specified for stopping or changing.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectionType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="ConnectionLocation" maxOccurs="9">
 *       &lt;!-- Reference to inner class ConnectionLocation -->
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class ConnectionType implements Serializable
{
    private List<ConnectionLocation> connectionLocationList = new ArrayList<ConnectionLocation>();

    /** 
     * Get the list of 'ConnectionLocation' element items.
     * 
     * @return list
     */
    public List<ConnectionLocation> getConnectionLocationList() {
        return connectionLocationList;
    }

    /** 
     * Set the list of 'ConnectionLocation' element items.
     * 
     * @param list
     */
    public void setConnectionLocationList(List<ConnectionLocation> list) {
        connectionLocationList = list;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ConnectionLocation" maxOccurs="9">
     *   &lt;xs:complexType>
     *     &lt;xs:simpleContent>
     *       &lt;xs:extension base="xs:string">
     *         &lt;xs:attribute type="xs:string" use="required" name="LocationCode"/>
     *         &lt;xs:attribute type="ns:AllowedExcludedPreferLevelType" default="Only" name="PreferLevel"/>
     *       &lt;/xs:extension>
     *     &lt;/xs:simpleContent>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class ConnectionLocation implements Serializable
    {
        private String string;
        private String locationCode;
        private AllowedExcludedPreferLevelType preferLevel;

        /** 
         * Get the extension value.
         * 
         * @return value
         */
        public String getString() {
            return string;
        }

        /** 
         * Set the extension value.
         * 
         * @param string
         */
        public void setString(String string) {
            this.string = string;
        }

        /** 
         * Get the 'LocationCode' attribute value. IATA Airport Code indicating connection location, stop, origin or destination.
         * 
         * @return value
         */
        public String getLocationCode() {
            return locationCode;
        }

        /** 
         * Set the 'LocationCode' attribute value. IATA Airport Code indicating connection location, stop, origin or destination.
         * 
         * @param locationCode
         */
        public void setLocationCode(String locationCode) {
            this.locationCode = locationCode;
        }

        /** 
         * Get the 'PreferLevel' attribute value. The preference level for the airport. Available levels: Only, Unacceptable.
         * 
         * @return value
         */
        public AllowedExcludedPreferLevelType getPreferLevel() {
            return preferLevel;
        }

        /** 
         * Set the 'PreferLevel' attribute value. The preference level for the airport. Available levels: Only, Unacceptable.
         * 
         * @param preferLevel
         */
        public void setPreferLevel(AllowedExcludedPreferLevelType preferLevel) {
            this.preferLevel = preferLevel;
        }
    }
}
