
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" abstract="true" name="DateTimeType">
 *   &lt;xs:attribute type="xs:string" name="TimeWindowStart"/>
 *   &lt;xs:attribute type="xs:string" name="TimeWindowEnd"/>
 *   &lt;xs:attribute type="xs:integer" name="TimeTolerance"/>
 *   &lt;xs:attribute type="xs:integer" name="DateFlexibility"/>
 *   &lt;xs:attribute type="xs:integer" name="MaxOptionsPerDate"/>
 *   &lt;xs:attribute type="xs:integer" name="ConnectionTimeMin"/>
 *   &lt;xs:attribute type="xs:integer" name="ConnectionTimeMax"/>
 * &lt;/xs:complexType>
 * </pre>
 */
public abstract class DateTimeType implements Serializable
{
    private String timeWindowStart;
    private String timeWindowEnd;
    private BigInteger timeTolerance;
    private BigInteger dateFlexibility;
    private BigInteger maxOptionsPerDate;
    private BigInteger connectionTimeMin;
    private BigInteger connectionTimeMax;

    /** 
     * Get the 'TimeWindowStart' attribute value. Allowed amount of time before specified time.
     * 
     * @return value
     */
    public String getTimeWindowStart() {
        return timeWindowStart;
    }

    /** 
     * Set the 'TimeWindowStart' attribute value. Allowed amount of time before specified time.
     * 
     * @param timeWindowStart
     */
    public void setTimeWindowStart(String timeWindowStart) {
        this.timeWindowStart = timeWindowStart;
    }

    /** 
     * Get the 'TimeWindowEnd' attribute value. Allowed amount of time after specified time.
     * 
     * @return value
     */
    public String getTimeWindowEnd() {
        return timeWindowEnd;
    }

    /** 
     * Set the 'TimeWindowEnd' attribute value. Allowed amount of time after specified time.
     * 
     * @param timeWindowEnd
     */
    public void setTimeWindowEnd(String timeWindowEnd) {
        this.timeWindowEnd = timeWindowEnd;
    }

    /** 
     * Get the 'TimeTolerance' attribute value. Maximum time difference between actual and desired time.
     * 
     * @return value
     */
    public BigInteger getTimeTolerance() {
        return timeTolerance;
    }

    /** 
     * Set the 'TimeTolerance' attribute value. Maximum time difference between actual and desired time.
     * 
     * @param timeTolerance
     */
    public void setTimeTolerance(BigInteger timeTolerance) {
        this.timeTolerance = timeTolerance;
    }

    /** 
     * Get the 'DateFlexibility' attribute value. The number of alternate days around the travel date to search.
     * 
     * @return value
     */
    public BigInteger getDateFlexibility() {
        return dateFlexibility;
    }

    /** 
     * Set the 'DateFlexibility' attribute value. The number of alternate days around the travel date to search.
     * 
     * @param dateFlexibility
     */
    public void setDateFlexibility(BigInteger dateFlexibility) {
        this.dateFlexibility = dateFlexibility;
    }

    /** 
     * Get the 'MaxOptionsPerDate' attribute value. Number of options for requested date.
     * 
     * @return value
     */
    public BigInteger getMaxOptionsPerDate() {
        return maxOptionsPerDate;
    }

    /** 
     * Set the 'MaxOptionsPerDate' attribute value. Number of options for requested date.
     * 
     * @param maxOptionsPerDate
     */
    public void setMaxOptionsPerDate(BigInteger maxOptionsPerDate) {
        this.maxOptionsPerDate = maxOptionsPerDate;
    }

    /** 
     * Get the 'ConnectionTimeMin' attribute value. Minimal amount of time between flights
     * 
     * @return value
     */
    public BigInteger getConnectionTimeMin() {
        return connectionTimeMin;
    }

    /** 
     * Set the 'ConnectionTimeMin' attribute value. Minimal amount of time between flights
     * 
     * @param connectionTimeMin
     */
    public void setConnectionTimeMin(BigInteger connectionTimeMin) {
        this.connectionTimeMin = connectionTimeMin;
    }

    /** 
     * Get the 'ConnectionTimeMax' attribute value. Maximal amount of time between flights
     * 
     * @return value
     */
    public BigInteger getConnectionTimeMax() {
        return connectionTimeMax;
    }

    /** 
     * Set the 'ConnectionTimeMax' attribute value. Maximal amount of time between flights
     * 
     * @param connectionTimeMax
     */
    public void setConnectionTimeMax(BigInteger connectionTimeMax) {
        this.connectionTimeMax = connectionTimeMax;
    }
}
