
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/** 
 * 
 These parameters control how IntellSell should select itineraries
 based not necessarily on cheapest price,
 but also on other criteria that guarantee a diverse response.

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DiversityControlType">
 *   &lt;xs:sequence>
 *     &lt;xs:element name="LowFareBucket">
 *       &lt;xs:complexType>
 *         &lt;xs:attribute type="xs:string" use="optional" name="Options"/>
 *         &lt;xs:attribute type="xs:string" use="optional" name="FareCutOff"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *     &lt;xs:element name="Dimensions">
 *       &lt;xs:complexType>
 *         &lt;xs:sequence>
 *           &lt;xs:element name="TravelTime" minOccurs="0">
 *             &lt;!-- Reference to inner class TravelTime -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="Carrier" minOccurs="0">
 *             &lt;!-- Reference to inner class Carrier -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="OperatingDuplicate" minOccurs="0">
 *             &lt;!-- Reference to inner class OperatingDuplicate -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="InboundOutboundPairing" minOccurs="0">
 *             &lt;!-- Reference to inner class InboundOutboundPairing -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="TimeOfDay" minOccurs="0">
 *             &lt;!-- Reference to inner class TimeOfDay -->
 *           &lt;/xs:element>
 *           &lt;xs:element name="StopsNumber" minOccurs="0">
 *             &lt;!-- Reference to inner class StopsNumber -->
 *           &lt;/xs:element>
 *         &lt;/xs:sequence>
 *         &lt;xs:attribute type="xs:double" default="10" name="PriceWeight"/>
 *       &lt;/xs:complexType>
 *     &lt;/xs:element>
 *   &lt;/xs:sequence>
 * &lt;/xs:complexType>
 * </pre>
 */
public class DiversityControlType implements Serializable
{
    private String lowFareBucketOptions;
    private String lowFareBucketFareCutOff;
    private TravelTime travelTime;
    private Carrier carrier;
    private OperatingDuplicate operatingDuplicate;
    private InboundOutboundPairing inboundOutboundPairing;
    private TimeOfDay timeOfDay;
    private StopsNumber stopsNumber;
    private Double dimensionsPriceWeight;

    /** 
     * Get the 'Options' attribute value.
     * 
     * @return value
     */
    public String getLowFareBucketOptions() {
        return lowFareBucketOptions;
    }

    /** 
     * Set the 'Options' attribute value.
     * 
     * @param lowFareBucketOptions
     */
    public void setLowFareBucketOptions(String lowFareBucketOptions) {
        this.lowFareBucketOptions = lowFareBucketOptions;
    }

    /** 
     * Get the 'FareCutOff' attribute value.
     * 
     * @return value
     */
    public String getLowFareBucketFareCutOff() {
        return lowFareBucketFareCutOff;
    }

    /** 
     * Set the 'FareCutOff' attribute value.
     * 
     * @param lowFareBucketFareCutOff
     */
    public void setLowFareBucketFareCutOff(String lowFareBucketFareCutOff) {
        this.lowFareBucketFareCutOff = lowFareBucketFareCutOff;
    }

    /** 
     * Get the 'TravelTime' element value.
     * 
     * @return value
     */
    public TravelTime getTravelTime() {
        return travelTime;
    }

    /** 
     * Set the 'TravelTime' element value.
     * 
     * @param travelTime
     */
    public void setTravelTime(TravelTime travelTime) {
        this.travelTime = travelTime;
    }

    /** 
     * Get the 'Carrier' element value.
     * 
     * @return value
     */
    public Carrier getCarrier() {
        return carrier;
    }

    /** 
     * Set the 'Carrier' element value.
     * 
     * @param carrier
     */
    public void setCarrier(Carrier carrier) {
        this.carrier = carrier;
    }

    /** 
     * Get the 'OperatingDuplicate' element value.
     * 
     * @return value
     */
    public OperatingDuplicate getOperatingDuplicate() {
        return operatingDuplicate;
    }

    /** 
     * Set the 'OperatingDuplicate' element value.
     * 
     * @param operatingDuplicate
     */
    public void setOperatingDuplicate(OperatingDuplicate operatingDuplicate) {
        this.operatingDuplicate = operatingDuplicate;
    }

    /** 
     * Get the 'InboundOutboundPairing' element value.
     * 
     * @return value
     */
    public InboundOutboundPairing getInboundOutboundPairing() {
        return inboundOutboundPairing;
    }

    /** 
     * Set the 'InboundOutboundPairing' element value.
     * 
     * @param inboundOutboundPairing
     */
    public void setInboundOutboundPairing(
            InboundOutboundPairing inboundOutboundPairing) {
        this.inboundOutboundPairing = inboundOutboundPairing;
    }

    /** 
     * Get the 'TimeOfDay' element value.
     * 
     * @return value
     */
    public TimeOfDay getTimeOfDay() {
        return timeOfDay;
    }

    /** 
     * Set the 'TimeOfDay' element value.
     * 
     * @param timeOfDay
     */
    public void setTimeOfDay(TimeOfDay timeOfDay) {
        this.timeOfDay = timeOfDay;
    }

    /** 
     * Get the 'StopsNumber' element value.
     * 
     * @return value
     */
    public StopsNumber getStopsNumber() {
        return stopsNumber;
    }

    /** 
     * Set the 'StopsNumber' element value.
     * 
     * @param stopsNumber
     */
    public void setStopsNumber(StopsNumber stopsNumber) {
        this.stopsNumber = stopsNumber;
    }

    /** 
     * Get the 'PriceWeight' attribute value.
     * 
     * @return value
     */
    public Double getDimensionsPriceWeight() {
        return dimensionsPriceWeight;
    }

    /** 
     * Set the 'PriceWeight' attribute value.
     * 
     * @param dimensionsPriceWeight
     */
    public void setDimensionsPriceWeight(Double dimensionsPriceWeight) {
        this.dimensionsPriceWeight = dimensionsPriceWeight;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TravelTime" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:double" use="required" name="Weight"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TravelTime implements Serializable
    {
        private Double weight;

        /** 
         * Get the 'Weight' attribute value.
         * 
         * @return value
         */
        public Double getWeight() {
            return weight;
        }

        /** 
         * Set the 'Weight' attribute value.
         * 
         * @param weight
         */
        public void setWeight(Double weight) {
            this.weight = weight;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Carrier" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Default" minOccurs="0">
     *         &lt;!-- Reference to inner class Default -->
     *       &lt;/xs:element>
     *       &lt;xs:element name="Override" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Override -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:double" use="required" name="Weight"/>
     *     &lt;xs:attribute type="xs:boolean" default="false" name="OnlineIndicator"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class Carrier implements Serializable
    {
        private Default _default;
        private List<Override> overrideList = new ArrayList<Override>();
        private Double weight;
        private Boolean onlineIndicator;

        /** 
         * Get the 'Default' element value.
         * 
         * @return value
         */
        public Default getDefault() {
            return _default;
        }

        /** 
         * Set the 'Default' element value.
         * 
         * @param _default
         */
        public void setDefault(Default _default) {
            this._default = _default;
        }

        /** 
         * Get the list of 'Override' element items.
         * 
         * @return list
         */
        public List<Override> getOverrideList() {
            return overrideList;
        }

        /** 
         * Set the list of 'Override' element items.
         * 
         * @param list
         */
        public void setOverrideList(List<Override> list) {
            overrideList = list;
        }

        /** 
         * Get the 'Weight' attribute value.
         * 
         * @return value
         */
        public Double getWeight() {
            return weight;
        }

        /** 
         * Set the 'Weight' attribute value.
         * 
         * @param weight
         */
        public void setWeight(Double weight) {
            this.weight = weight;
        }

        /** 
         * Get the 'OnlineIndicator' attribute value.
         * 
         * @return value
         */
        public Boolean getOnlineIndicator() {
            return onlineIndicator;
        }

        /** 
         * Set the 'OnlineIndicator' attribute value.
         * 
         * @param onlineIndicator
         */
        public void setOnlineIndicator(Boolean onlineIndicator) {
            this.onlineIndicator = onlineIndicator;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Default" minOccurs="0">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Options"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Default implements Serializable
        {
            private String options;

            /** 
             * Get the 'Options' attribute value.
             * 
             * @return value
             */
            public String getOptions() {
                return options;
            }

            /** 
             * Set the 'Options' attribute value.
             * 
             * @param options
             */
            public void setOptions(String options) {
                this.options = options;
            }
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Override" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *     &lt;xs:attribute type="xs:string" use="required" name="Options"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Override implements Serializable
        {
            private String code;
            private String options;

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }

            /** 
             * Get the 'Options' attribute value.
             * 
             * @return value
             */
            public String getOptions() {
                return options;
            }

            /** 
             * Set the 'Options' attribute value.
             * 
             * @param options
             */
            public void setOptions(String options) {
                this.options = options;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="OperatingDuplicate" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="PreferredCarrier" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class PreferredCarrier -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:double" use="required" name="Weight"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class OperatingDuplicate implements Serializable
    {
        private List<PreferredCarrier> preferredCarrierList = new ArrayList<PreferredCarrier>();
        private Double weight;

        /** 
         * Get the list of 'PreferredCarrier' element items.
         * 
         * @return list
         */
        public List<PreferredCarrier> getPreferredCarrierList() {
            return preferredCarrierList;
        }

        /** 
         * Set the list of 'PreferredCarrier' element items.
         * 
         * @param list
         */
        public void setPreferredCarrierList(List<PreferredCarrier> list) {
            preferredCarrierList = list;
        }

        /** 
         * Get the 'Weight' attribute value.
         * 
         * @return value
         */
        public Double getWeight() {
            return weight;
        }

        /** 
         * Set the 'Weight' attribute value.
         * 
         * @param weight
         */
        public void setWeight(Double weight) {
            this.weight = weight;
        }
        /** 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferredCarrier" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:attribute type="xs:string" use="required" name="Code"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class PreferredCarrier implements Serializable
        {
            private String code;

            /** 
             * Get the 'Code' attribute value.
             * 
             * @return value
             */
            public String getCode() {
                return code;
            }

            /** 
             * Set the 'Code' attribute value.
             * 
             * @param code
             */
            public void setCode(String code) {
                this.code = code;
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="InboundOutboundPairing" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:double" use="required" name="Weight"/>
     *     &lt;xs:attribute type="xs:string" default="1" name="Duplicates"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class InboundOutboundPairing implements Serializable
    {
        private Double weight;
        private String duplicates;

        /** 
         * Get the 'Weight' attribute value.
         * 
         * @return value
         */
        public Double getWeight() {
            return weight;
        }

        /** 
         * Set the 'Weight' attribute value.
         * 
         * @param weight
         */
        public void setWeight(Double weight) {
            this.weight = weight;
        }

        /** 
         * Get the 'Duplicates' attribute value.
         * 
         * @return value
         */
        public String getDuplicates() {
            return duplicates;
        }

        /** 
         * Set the 'Duplicates' attribute value.
         * 
         * @param duplicates
         */
        public void setDuplicates(String duplicates) {
            this.duplicates = duplicates;
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="TimeOfDay" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:sequence>
     *       &lt;xs:element name="Distribution" minOccurs="0" maxOccurs="unbounded">
     *         &lt;!-- Reference to inner class Distribution -->
     *       &lt;/xs:element>
     *     &lt;/xs:sequence>
     *     &lt;xs:attribute type="xs:double" use="required" name="Weight"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class TimeOfDay implements Serializable
    {
        private List<Distribution> distributionList = new ArrayList<Distribution>();
        private Double weight;

        /** 
         * Get the list of 'Distribution' element items.
         * 
         * @return list
         */
        public List<Distribution> getDistributionList() {
            return distributionList;
        }

        /** 
         * Set the list of 'Distribution' element items.
         * 
         * @param list
         */
        public void setDistributionList(List<Distribution> list) {
            distributionList = list;
        }

        /** 
         * Get the 'Weight' attribute value.
         * 
         * @return value
         */
        public Double getWeight() {
            return weight;
        }

        /** 
         * Set the 'Weight' attribute value.
         * 
         * @param weight
         */
        public void setWeight(Double weight) {
            this.weight = weight;
        }
        /** 
         * Exactly one attribute: either Direction or Leg must be provided
         * 
         * Schema fragment(s) for this class:
         * <pre>
         * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Distribution" minOccurs="0" maxOccurs="unbounded">
         *   &lt;xs:complexType>
         *     &lt;xs:sequence>
         *       &lt;xs:element name="Range" minOccurs="0" maxOccurs="4">
         *         &lt;!-- Reference to inner class Range -->
         *       &lt;/xs:element>
         *     &lt;/xs:sequence>
         *     &lt;xs:attribute type="ns:OutboundOrInbound" use="optional" name="Direction"/>
         *     &lt;xs:attribute type="xs:string" use="optional" name="Leg"/>
         *     &lt;xs:attribute type="ns:DepartureOrArrival" default="Departure" name="Endpoint"/>
         *   &lt;/xs:complexType>
         * &lt;/xs:element>
         * </pre>
         */
        public static class Distribution implements Serializable
        {
            private List<Range> rangeList = new ArrayList<Range>();
            private OutboundOrInbound direction;
            private String leg;
            private DepartureOrArrival endpoint;

            /** 
             * Get the list of 'Range' element items.
             * 
             * @return list
             */
            public List<Range> getRangeList() {
                return rangeList;
            }

            /** 
             * Set the list of 'Range' element items.
             * 
             * @param list
             */
            public void setRangeList(List<Range> list) {
                rangeList = list;
            }

            /** 
             * Get the 'Direction' attribute value.
             * 
             * @return value
             */
            public OutboundOrInbound getDirection() {
                return direction;
            }

            /** 
             * Set the 'Direction' attribute value.
             * 
             * @param direction
             */
            public void setDirection(OutboundOrInbound direction) {
                this.direction = direction;
            }

            /** 
             * Get the 'Leg' attribute value.
             * 
             * @return value
             */
            public String getLeg() {
                return leg;
            }

            /** 
             * Set the 'Leg' attribute value.
             * 
             * @param leg
             */
            public void setLeg(String leg) {
                this.leg = leg;
            }

            /** 
             * Get the 'Endpoint' attribute value.
             * 
             * @return value
             */
            public DepartureOrArrival getEndpoint() {
                return endpoint;
            }

            /** 
             * Set the 'Endpoint' attribute value.
             * 
             * @param endpoint
             */
            public void setEndpoint(DepartureOrArrival endpoint) {
                this.endpoint = endpoint;
            }
            /** 
             * Schema fragment(s) for this class:
             * <pre>
             * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="Range" minOccurs="0" maxOccurs="4">
             *   &lt;xs:complexType>
             *     &lt;xs:attribute type="xs:string" use="required" name="Begin"/>
             *     &lt;xs:attribute type="xs:string" use="required" name="End"/>
             *     &lt;xs:attribute type="xs:string" use="optional" name="Options"/>
             *   &lt;/xs:complexType>
             * &lt;/xs:element>
             * </pre>
             */
            public static class Range implements Serializable
            {
                private String begin;
                private String end;
                private String options;

                /** 
                 * Get the 'Begin' attribute value.
                 * 
                 * @return value
                 */
                public String getBegin() {
                    return begin;
                }

                /** 
                 * Set the 'Begin' attribute value.
                 * 
                 * @param begin
                 */
                public void setBegin(String begin) {
                    this.begin = begin;
                }

                /** 
                 * Get the 'End' attribute value.
                 * 
                 * @return value
                 */
                public String getEnd() {
                    return end;
                }

                /** 
                 * Set the 'End' attribute value.
                 * 
                 * @param end
                 */
                public void setEnd(String end) {
                    this.end = end;
                }

                /** 
                 * Get the 'Options' attribute value.
                 * 
                 * @return value
                 */
                public String getOptions() {
                    return options;
                }

                /** 
                 * Set the 'Options' attribute value.
                 * 
                 * @param options
                 */
                public void setOptions(String options) {
                    this.options = options;
                }
            }
        }
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:element xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="StopsNumber" minOccurs="0">
     *   &lt;xs:complexType>
     *     &lt;xs:attribute type="xs:double" use="required" name="Weight"/>
     *   &lt;/xs:complexType>
     * &lt;/xs:element>
     * </pre>
     */
    public static class StopsNumber implements Serializable
    {
        private Double weight;

        /** 
         * Get the 'Weight' attribute value.
         * 
         * @return value
         */
        public Double getWeight() {
            return weight;
        }

        /** 
         * Set the 'Weight' attribute value.
         * 
         * @param weight
         */
        public void setWeight(Double weight) {
            this.weight = weight;
        }
    }
}
