
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;

/** 
 * Provides information on a specific documents.
 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="DocumentType">
 *   &lt;xs:sequence>
 *     &lt;xs:element type="xs:string" name="DocHolderName" minOccurs="0"/>
 *     &lt;xs:element type="xs:string" name="DocLimitations" minOccurs="0" maxOccurs="9"/>
 *   &lt;/xs:sequence>
 *   &lt;xs:attributeGroup ref="ns:PrivacyGroup"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocIssueAuthority"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocIssueLocation"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocID"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="DocType"/>
 *   &lt;xs:attributeGroup ref="ns:GenderGroup"/>
 *   &lt;xs:attributeGroup ref="ns:BirthDateGroup"/>
 *   &lt;xs:attributeGroup ref="ns:EffectiveExpireOptionalDateGroup"/>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="BirthDateGroup">
 *   &lt;xs:attribute type="xs:date" use="optional" name="BirthDate"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class DocumentType implements Serializable
{
    private String docHolderName;
    private List<String> docLimitationList = new ArrayList<String>();
    private PrivacyGroup privacyGroup;
    private String docIssueAuthority;
    private String docIssueLocation;
    private String docID;
    private String docType;
    private GenderGroup genderGroup;
    private Date birthDate;
    private EffectiveExpireOptionalDateGroup effectiveExpireOptionalDateGroup;

    /** 
     * Get the 'DocHolderName' element value. Specify document holder name.
     * 
     * @return value
     */
    public String getDocHolderName() {
        return docHolderName;
    }

    /** 
     * Set the 'DocHolderName' element value. Specify document holder name.
     * 
     * @param docHolderName
     */
    public void setDocHolderName(String docHolderName) {
        this.docHolderName = docHolderName;
    }

    /** 
     * Get the list of 'DocLimitations' element items. Used to indicate any limitations on the document (e.g. as a person may only be allowed to spend a max of 30 days in country on a visitor's visa).
     * 
     * @return list
     */
    public List<String> getDocLimitationList() {
        return docLimitationList;
    }

    /** 
     * Set the list of 'DocLimitations' element items. Used to indicate any limitations on the document (e.g. as a person may only be allowed to spend a max of 30 days in country on a visitor's visa).
     * 
     * @param list
     */
    public void setDocLimitationList(List<String> list) {
        docLimitationList = list;
    }

    /** 
     * Get the 'PrivacyGroup' attributeGroup value.
     * 
     * @return value
     */
    public PrivacyGroup getPrivacyGroup() {
        return privacyGroup;
    }

    /** 
     * Set the 'PrivacyGroup' attributeGroup value.
     * 
     * @param privacyGroup
     */
    public void setPrivacyGroup(PrivacyGroup privacyGroup) {
        this.privacyGroup = privacyGroup;
    }

    /** 
     * Get the 'DocIssueAuthority' attribute value. Indicates the group or association that granted the document.
     * 
     * @return value
     */
    public String getDocIssueAuthority() {
        return docIssueAuthority;
    }

    /** 
     * Set the 'DocIssueAuthority' attribute value. Indicates the group or association that granted the document.
     * 
     * @param docIssueAuthority
     */
    public void setDocIssueAuthority(String docIssueAuthority) {
        this.docIssueAuthority = docIssueAuthority;
    }

    /** 
     * Get the 'DocIssueLocation' attribute value. Indicates the location where the document was issued.
     * 
     * @return value
     */
    public String getDocIssueLocation() {
        return docIssueLocation;
    }

    /** 
     * Set the 'DocIssueLocation' attribute value. Indicates the location where the document was issued.
     * 
     * @param docIssueLocation
     */
    public void setDocIssueLocation(String docIssueLocation) {
        this.docIssueLocation = docIssueLocation;
    }

    /** 
     * Get the 'DocID' attribute value. Unique number assigned by authorities to document.
     * 
     * @return value
     */
    public String getDocID() {
        return docID;
    }

    /** 
     * Set the 'DocID' attribute value. Unique number assigned by authorities to document.
     * 
     * @param docID
     */
    public void setDocID(String docID) {
        this.docID = docID;
    }

    /** 
     * Get the 'DocType' attribute value. Indicates the type of document (e.g. Passport, Military ID, Drivers License, national ID, Vaccination Certificate). Refer to OTA Code List Document Type (DOC).
     * 
     * @return value
     */
    public String getDocType() {
        return docType;
    }

    /** 
     * Set the 'DocType' attribute value. Indicates the type of document (e.g. Passport, Military ID, Drivers License, national ID, Vaccination Certificate). Refer to OTA Code List Document Type (DOC).
     * 
     * @param docType
     */
    public void setDocType(String docType) {
        this.docType = docType;
    }

    /** 
     * Get the 'GenderGroup' attributeGroup value.
     * 
     * @return value
     */
    public GenderGroup getGenderGroup() {
        return genderGroup;
    }

    /** 
     * Set the 'GenderGroup' attributeGroup value.
     * 
     * @param genderGroup
     */
    public void setGenderGroup(GenderGroup genderGroup) {
        this.genderGroup = genderGroup;
    }

    /** 
     * Get the 'BirthDate' attribute value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @return value
     */
    public Date getBirthDate() {
        return birthDate;
    }

    /** 
     * Set the 'BirthDate' attribute value. Indicates the date of birth as indicated in the document, in ISO 8601 prescribed format.
     * 
     * @param birthDate
     */
    public void setBirthDate(Date birthDate) {
        this.birthDate = birthDate;
    }

    /** 
     * Get the 'EffectiveExpireOptionalDateGroup' attributeGroup value.
     * 
     * @return value
     */
    public EffectiveExpireOptionalDateGroup getEffectiveExpireOptionalDateGroup() {
        return effectiveExpireOptionalDateGroup;
    }

    /** 
     * Set the 'EffectiveExpireOptionalDateGroup' attributeGroup value.
     * 
     * @param effectiveExpireOptionalDateGroup
     */
    public void setEffectiveExpireOptionalDateGroup(
            EffectiveExpireOptionalDateGroup effectiveExpireOptionalDateGroup) {
        this.effectiveExpireOptionalDateGroup = effectiveExpireOptionalDateGroup;
    }
}
