
package com.gridnine.sabre.bfm;

import java.io.Serializable;
import java.math.BigInteger;

/** 
 * 
 This describes best available entertainment in a given cabin. These alements are later referenced from FlightAmenities

 * 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EntertainmentAmenityType">
 *   &lt;xs:attribute type="xs:integer" use="required" name="Id"/>
 *   &lt;xs:attribute type="ns:AmenityCostType" use="optional" name="Cost"/>
 *   &lt;xs:attribute type="xs:boolean" use="optional" name="Exists"/>
 *   &lt;xs:attribute use="optional" name="Type">
 *     &lt;xs:simpleType>
 *       &lt;!-- Reference to inner class Type -->
 *     &lt;/xs:simpleType>
 *   &lt;/xs:attribute>
 * &lt;/xs:complexType>
 * </pre>
 */
public class EntertainmentAmenityType implements Serializable
{
    private BigInteger id;
    private AmenityCostType cost;
    private Boolean exists;
    private Type type;

    /** 
     * Get the 'Id' attribute value.
     * 
     * @return value
     */
    public BigInteger getId() {
        return id;
    }

    /** 
     * Set the 'Id' attribute value.
     * 
     * @param id
     */
    public void setId(BigInteger id) {
        this.id = id;
    }

    /** 
     * Get the 'Cost' attribute value.
     * 
     * @return value
     */
    public AmenityCostType getCost() {
        return cost;
    }

    /** 
     * Set the 'Cost' attribute value.
     * 
     * @param cost
     */
    public void setCost(AmenityCostType cost) {
        this.cost = cost;
    }

    /** 
     * Get the 'Exists' attribute value.
     * 
     * @return value
     */
    public Boolean getExists() {
        return exists;
    }

    /** 
     * Set the 'Exists' attribute value.
     * 
     * @param exists
     */
    public void setExists(Boolean exists) {
        this.exists = exists;
    }

    /** 
     * Get the 'Type' attribute value.
     * 
     * @return value
     */
    public Type getType() {
        return type;
    }

    /** 
     * Set the 'Type' attribute value.
     * 
     * @param type
     */
    public void setType(Type type) {
        this.type = type;
    }
    /** 
     * Schema fragment(s) for this class:
     * <pre>
     * &lt;xs:simpleType xmlns:xs="http://www.w3.org/2001/XMLSchema">
     *   &lt;xs:restriction base="xs:string">
     *     &lt;xs:enumeration value="none"/>
     *     &lt;xs:enumeration value="livetv"/>
     *     &lt;xs:enumeration value="loop"/>
     *     &lt;xs:enumeration value="on-demand"/>
     *     &lt;xs:enumeration value="overhead"/>
     *     &lt;xs:enumeration value="seatback"/>
     *     &lt;xs:enumeration value="pre-download"/>
     *     &lt;xs:enumeration value="streaming"/>
     *     &lt;xs:enumeration value="tablet"/>
     *   &lt;/xs:restriction>
     * &lt;/xs:simpleType>
     * </pre>
     */
    public static enum Type implements Serializable {
        NONE("none"), LIVETV("livetv"), LOOP("loop"), ONDEMAND("on-demand"), OVERHEAD(
                "overhead"), SEATBACK("seatback"), PREDOWNLOAD("pre-download"), STREAMING(
                "streaming"), TABLET("tablet");
        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String xmlValue() {
            return value;
        }

        public static Type convert(String value) {
            for (Type inst : values()) {
                if (inst.xmlValue().equals(value)) {
                    return inst;
                }
            }
            return null;
        }
    }
}
