
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:complexType xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="EquipmentTypePref">
 *   &lt;xs:simpleContent>
 *     &lt;xs:extension base="ns:EquipmentType">
 *       &lt;xs:attributeGroup ref="ns:PreferLevelGroup"/>
 *       &lt;xs:attribute type="xs:boolean" use="optional" name="WideBody"/>
 *     &lt;/xs:extension>
 *   &lt;/xs:simpleContent>
 * &lt;/xs:complexType>
 * 
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="PreferLevelGroup">
 *   &lt;xs:attribute type="ns:PreferLevelType" default="Preferred" name="PreferLevel"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class EquipmentTypePref implements Serializable
{
    private EquipmentType equipmentType;
    private PreferLevelType preferLevel;
    private Boolean wideBody;

    /** 
     * Get the extension value.
     * 
     * @return value
     */
    public EquipmentType getEquipmentType() {
        return equipmentType;
    }

    /** 
     * Set the extension value.
     * 
     * @param equipmentType
     */
    public void setEquipmentType(EquipmentType equipmentType) {
        this.equipmentType = equipmentType;
    }

    /** 
     * Get the 'PreferLevel' attribute value. Used to indicate a level of preference for an associate item, only, unacceptable, preferred.
     * 
     * @return value
     */
    public PreferLevelType getPreferLevel() {
        return preferLevel;
    }

    /** 
     * Set the 'PreferLevel' attribute value. Used to indicate a level of preference for an associate item, only, unacceptable, preferred.
     * 
     * @param preferLevel
     */
    public void setPreferLevel(PreferLevelType preferLevel) {
        this.preferLevel = preferLevel;
    }

    /** 
     * Get the 'WideBody' attribute value. Specify if equipment should have a wide body or not.
     * 
     * @return value
     */
    public Boolean getWideBody() {
        return wideBody;
    }

    /** 
     * Set the 'WideBody' attribute value. Specify if equipment should have a wide body or not.
     * 
     * @param wideBody
     */
    public void setWideBody(Boolean wideBody) {
        this.wideBody = wideBody;
    }
}
