
package com.gridnine.sabre.bfm;

import java.io.Serializable;

/** 
 * Schema fragment(s) for this class:
 * <pre>
 * &lt;xs:attributeGroup xmlns:ns="http://www.opentravel.org/OTA/2003/05" xmlns:xs="http://www.w3.org/2001/XMLSchema" name="ExchangeAttributeGroup">
 *   &lt;xs:attribute type="xs:string" use="required" name="OriginalTktIssueDateTime"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="ExchangedTktIssueDateTime"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="PreviousExchangeDateTime"/>
 *   &lt;xs:attribute type="xs:short" use="optional" name="NumberOfTaxBoxes"/>
 *   &lt;xs:attribute type="xs:string" use="optional" name="BypassAdvancePurchaseOption"/>
 * &lt;/xs:attributeGroup>
 * </pre>
 */
public class ExchangeAttributeGroup implements Serializable
{
    private String originalTktIssueDateTime;
    private String exchangedTktIssueDateTime;
    private String previousExchangeDateTime;
    private Short numberOfTaxBoxes;
    private String bypassAdvancePurchaseOption;

    /** 
     * Get the 'OriginalTktIssueDateTime' attribute value. Original ticket issue date and time
     * 
     * @return value
     */
    public String getOriginalTktIssueDateTime() {
        return originalTktIssueDateTime;
    }

    /** 
     * Set the 'OriginalTktIssueDateTime' attribute value. Original ticket issue date and time
     * 
     * @param originalTktIssueDateTime
     */
    public void setOriginalTktIssueDateTime(String originalTktIssueDateTime) {
        this.originalTktIssueDateTime = originalTktIssueDateTime;
    }

    /** 
     * Get the 'ExchangedTktIssueDateTime' attribute value. Exchanged ticket issue date and time
     * 
     * @return value
     */
    public String getExchangedTktIssueDateTime() {
        return exchangedTktIssueDateTime;
    }

    /** 
     * Set the 'ExchangedTktIssueDateTime' attribute value. Exchanged ticket issue date and time
     * 
     * @param exchangedTktIssueDateTime
     */
    public void setExchangedTktIssueDateTime(String exchangedTktIssueDateTime) {
        this.exchangedTktIssueDateTime = exchangedTktIssueDateTime;
    }

    /** 
     * Get the 'PreviousExchangeDateTime' attribute value. Previous exchange date and time
     * 
     * @return value
     */
    public String getPreviousExchangeDateTime() {
        return previousExchangeDateTime;
    }

    /** 
     * Set the 'PreviousExchangeDateTime' attribute value. Previous exchange date and time
     * 
     * @param previousExchangeDateTime
     */
    public void setPreviousExchangeDateTime(String previousExchangeDateTime) {
        this.previousExchangeDateTime = previousExchangeDateTime;
    }

    /** 
     * Get the 'NumberOfTaxBoxes' attribute value. Number of tax boxes
     * 
     * @return value
     */
    public Short getNumberOfTaxBoxes() {
        return numberOfTaxBoxes;
    }

    /** 
     * Set the 'NumberOfTaxBoxes' attribute value. Number of tax boxes
     * 
     * @param numberOfTaxBoxes
     */
    public void setNumberOfTaxBoxes(Short numberOfTaxBoxes) {
        this.numberOfTaxBoxes = numberOfTaxBoxes;
    }

    /** 
     * Get the 'BypassAdvancePurchaseOption' attribute value. Bypass Advance Purchase Option
     * 
     * @return value
     */
    public String getBypassAdvancePurchaseOption() {
        return bypassAdvancePurchaseOption;
    }

    /** 
     * Set the 'BypassAdvancePurchaseOption' attribute value. Bypass Advance Purchase Option
     * 
     * @param bypassAdvancePurchaseOption
     */
    public void setBypassAdvancePurchaseOption(
            String bypassAdvancePurchaseOption) {
        this.bypassAdvancePurchaseOption = bypassAdvancePurchaseOption;
    }
}
